/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.utils.JSONUtils;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;

public class WorkerDescargaMetadatos
extends SwingWorker<Boolean, Integer> {
    private final PrincipalBase principal;

    public WorkerDescargaMetadatos(PrincipalBase principalBase) {
        this.principal = principalBase;
    }

    @Override
    protected Boolean doInBackground() {
        try {
            String url = String.valueOf(this.principal.getUrlDocumentos()) + "/v1/usuario/" + this.principal.getIdUsuario() + "/pila-documentos";
            GetRequest request = (GetRequest)((GetRequest)((GetRequest)Unirest.get((String)url).header("Authorization", "Bearer " + this.principal.getToken())).header("User-Agent", "Firmador Lyris Desktop 1.0")).queryString("opt", (Object)"usuario,recibo");
            System.out.println("preparing 'GET' request to URL : " + request.getUrl());
            HttpResponse response = request.asJson();
            System.out.println(((JsonNode)response.getBody()).toString());
            if (response.getStatus() == 200) {
                try {
                    this.principal.setMetadatos(JSONUtils.parsearJson(((JsonNode)response.getBody()).toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (response.getStatus() == 403) {
                this.principal.informarProblemaIrrecuperable("Error 403: Acceso prohibido.", "Error al cargar usuario");
            } else if (response.getStatus() == 401) {
                this.principal.informarProblemaIrrecuperable("Error 401: No autorizado.", "Error al cargar usuario");
            } else {
                this.principal.informarProblemaIrrecuperable("Ocurri\u00f3 un error al cargar metadatos, por favor comuniquese con el responsable.", "Error al cargar usuario");
            }
            if (this.principal.tiempoDeSleepsDeTesting != 0) {
                Thread.sleep(this.principal.tiempoDeSleepsDeTesting);
            }
            System.out.println("Sent 'GET' request to URL. " + response.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.principal.getFrame(), "Hubo un problema intentando conectar al servidor.", "Error de red", 0);
            this.principal.finalizar(1);
        }
        return true;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void process(List<Integer> chunks) {
        if (!this.isDone()) {
            this.principal.refrescarTabla();
        }
    }
}

