/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.TipoFirma;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.MultipartBody;
import kong.unirest.Unirest;
import org.apache.xml.security.utils.Base64;
import unirest.shaded.org.apache.http.MalformedChunkCodingException;

public class WorkerSubida
extends SwingWorker<Boolean, Object> {
    private PrincipalBase principal;

    public WorkerSubida(PrincipalBase principalBase) {
        this.principal = principalBase;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        for (Documento doc : this.principal.getDocumentos()) {
            doc.setEstado(EstadoDoc.SUBIENDO);
            this.publish(doc.getId());
            try {
                System.out.println("preparing 'POST' request to URL");
                MultipartBody request = null;
                switch (this.principal.getModoEjecucion()) {
                    case CARGA_RECIBOS: {
                        request = this.generarPostDeRecibo(doc);
                        break;
                    }
                    default: {
                        request = this.generarPostGeneral(doc);
                    }
                }
                System.out.println("Sending 'POST' request to URL : " + request.getUrl());
                HttpResponse response = request.asJson();
                if (response.getStatus() == 200) {
                    doc.setEstado(EstadoDoc.SUBIDO);
                } else {
                    doc.setEstado(EstadoDoc.INVALIDO);
                    System.out.println(((JsonNode)response.getBody()).toString());
                    System.out.println("Codigo de respuesta " + response.getStatus());
                    String mensaje = String.valueOf((String)((JsonNode)response.getBody()).getObject().get("mensaje")) + "<br/>";
                    if (mensaje.contains("ruta_hash")) {
                        mensaje = "ya existe un archivo con el mismo nombre, en la misma ruta. <br/>";
                    }
                    this.principal.mensajeErrorSubida = String.valueOf(this.principal.mensajeErrorSubida) + "El archivo " + doc.getPrintableFileName() + " fallo porque " + mensaje;
                }
                if (this.principal.tiempoDeSleepsDeTesting != 0) {
                    Thread.sleep(this.principal.tiempoDeSleepsDeTesting);
                }
                this.publish(doc.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getClass().equals(MalformedChunkCodingException.class)) {
                    this.ShowMessage("Hubo un problema al recibir la respuesta del servidor");
                    continue;
                }
                this.ShowMessage(e.getMessage());
            }
        }
        return true;
    }

    private MultipartBody generarPostGeneral(Documento doc) throws IOException {
        MultipartBody multiPartBody;
        TipoFirma docTipoFirma = doc.getTipoFirma();
        File signedF = new File(doc.getFullSignedFilePath());
        signedF.deleteOnExit();
        HttpRequestWithBody request = (HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(String.valueOf(this.principal.urlBase) + "/v1/documento/" + doc.getId() + "/firma")).header("Accept", "application/json")).header("Authorization", "Bearer " + this.principal.getToken())).header("User-Agent", "Firmador Lyris Desktop 1.0")).header("Connection", "Keep-Alive")).header("Cache-Control", "no-cache");
        if (doc.getTipoFirma().equals((Object)TipoFirma.PDF) || doc.getTipoFirma().equals((Object)TipoFirma.REC)) {
            multiPartBody = request.field("archivo", signedF, "application/pdf");
        } else {
            StringBuilder sb = this.toXmlString(signedF);
            multiPartBody = request.field("datos", (Object)sb);
        }
        System.out.println((Object)doc.getTipoFirma());
        if (docTipoFirma.equals((Object)TipoFirma.REC)) {
            multiPartBody = multiPartBody.field("estado", doc.stringPostConformidad());
        } else {
            multiPartBody = multiPartBody.field("tipo", doc.getTipoFirma().toLowerShortName());
            if (doc.getTipoFirma().equals((Object)TipoFirma.PDF) && !"".equals(this.principal.getFrame().getRazonText())) {
                multiPartBody = multiPartBody.field("comentario", this.principal.getFrame().getRazonText());
            }
        }
        return multiPartBody;
    }

    private StringBuilder toXmlString(File signedF) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(signedF));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb;
    }

    private MultipartBody generarPostDeRecibo(Documento doc) {
        File signedF = new File(doc.getFullSignedFilePath());
        signedF.deleteOnExit();
        MultipartBody multiPartBody = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(String.valueOf(this.principal.urlBase) + "/v1/recibo")).header("Accept", "application/json")).header("Authorization", "Bearer " + this.principal.getToken())).header("User-Agent", "Firmador Lyris Desktop 1.0")).header("Connection", "Keep-Alive")).header("Cache-Control", "no-cache")).field("original", new File(doc.getFullFilePath()), "application/pdf").field("firmado", signedF, "application/pdf").field("nombre", doc.getFileName());
        if (!this.principal.patronContieneFechaCompleta()) {
            multiPartBody = multiPartBody.field("fecha", this.principal.getFrame().getFechaEmision());
        }
        if (!this.principal.patronContieneTipo()) {
            multiPartBody = multiPartBody.field("tipo", this.principal.getFrame().getTipoReciboSeleccionado().toLowerShortName());
        }
        return multiPartBody;
    }

    private void ShowMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message);
            }
        });
    }

    @Override
    protected void done() {
        Unirest.shutDown();
    }

    @Override
    protected void process(List<Object> chunks) {
        if (!this.isDone()) {
            this.principal.refrescarTabla();
        }
    }

    public static void main(String[] args) throws Exception {
        long initTime = System.currentTimeMillis();
        String token = "eyJhbGciOiJSUzI1NiJ9.eyJjYWxsYmFja191cmwiOiJodHRwczovL3NpZ25hci5jb20uYXIvY2FsbGJhY2siLCJhdWQiOlsicmVzb3VyY2VzIl0sInNjb3BlIjpbInJlYWQiXSwiZXhwIjoxNTUwMDU0MjM1LCJhdXRob3JpdGllcyI6WyJST0xFX1VTRVIiXSwianRpIjoiNzRjYTA2MWItYzNlNi00ZTZhLThkMTItNGMxNmYyNDc3ZGZhIiwiY2xpZW50X2lkIjoiMzNlN2QwMGMtOGVmYS00YzM5LWI0NzktMmU4YmNiZjdkODZkIn0.Yj6yjDFMLxJ7uHIeq6gZVnPCNC6F5WyQ3UOEjmzI8KGQQOUtyqdJZscYpMQdrjmN1pTHcxtdSeABHPKxBuRW0KkgiKpq750oqoccI4tdkpilERZSReq1vPomkRHkPKVI6wAqQo__ypdbAM8xqt2hcHR1MCtkWLxk8e_2ZDBEnjg";
        Path p = new File("E:\\20218.pdf").toPath();
        String doc = Base64.encode((byte[])Files.readAllBytes(p));
        String json = "{\"cuil\":\"20-35441404-0\",\"documento\":\"" + doc + "\",\"type\":\"PDF\"}";
        HttpResponse request = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)"https://tst.firmar.gob.ar/firmador/api/signatures").header("Content-Type", "application/json")).header("Authorization", "Bearer " + token)).header("accept", "application/json")).body(json).asJson();
        List loc = request.getHeaders().get("Location");
        System.out.println(loc);
        System.out.println("Cargado en: " + (System.currentTimeMillis() - initTime) / 1000L + " segundos");
    }
}

