/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.entidades;

import ar.com.lyris.entidades.TipoRecibo;
import com.google.gson.annotations.SerializedName;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ModuloRecibos {
    @SerializedName(value="patron_carga")
    private String patronCarga;
    @SerializedName(value="patron_almacenamiento")
    private String patronDeAlmacenamiento;
    @SerializedName(value="ruta_certificados")
    private String rutaCertificados;
    @SerializedName(value="coordenadas_empleador")
    private int[] coordsEmpleador;
    @SerializedName(value="coordenadas_conformidad")
    private int[] coordsConformidad;
    @SerializedName(value="coordenadas_disconformidad")
    private int[] coordsDisconformidad;
    public boolean igualesConfDisconf = true;
    @SerializedName(value="tipos")
    private TipoRecibo[] tiposRecibo;
    @SerializedName(value="almacenes_software")
    private String[] almacenesSoftware;

    public String getPatronDeCarga() {
        return this.patronCarga;
    }

    public void setpatron_carga(String patronDeCarga) {
        this.patronCarga = patronDeCarga;
    }

    public String getPatronDeAlmacenamiento() {
        return this.patronDeAlmacenamiento;
    }

    public void setpatron_almacenamiento(String patronDeAlmacenamiento) {
        this.patronDeAlmacenamiento = patronDeAlmacenamiento;
    }

    public String getRutaCertificados() {
        return this.rutaCertificados;
    }

    public void setruta_certificados(String rutaCertificados) {
        this.rutaCertificados = rutaCertificados;
    }

    public int[] getCoordsEmpleador() {
        return this.coordsEmpleador;
    }

    public boolean patronConTipoRecibo() {
        return this.patronCarga.contains("#rt");
    }

    public boolean patronConFecha() {
        return this.patronConDia() || this.patronConMes() || this.patronConAnio();
    }

    public boolean patronConFechaCompleta() {
        return this.patronConDia() && this.patronConMes() && this.patronConAnio();
    }

    public boolean patronConDia() {
        return this.patronCarga.contains("#d");
    }

    public boolean patronConMes() {
        return this.patronCarga.contains("#m");
    }

    public boolean patronConAnio() {
        return this.patronCarga.contains("#Y");
    }

    public LocalDate calcularFechaPorDefecto(String archivo) {
        Calendar fecha = Calendar.getInstance();
        return fecha.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public int[] getCoordsConformidad() {
        return this.coordsConformidad;
    }

    public int[] getCoordsDisconformidad() {
        return this.coordsDisconformidad;
    }

    public void setcoordenadas_disconformidad(int[] coordsDisconformidad) {
        this.coordsDisconformidad = coordsDisconformidad;
    }

    public void setcoordenadas_conformidad(int[] coordsConformidad) {
        this.coordsConformidad = coordsConformidad;
    }

    public void setcoordenadas_empleador(int[] coordsEmpleador) {
        this.coordsEmpleador = coordsEmpleador;
    }

    public void actualizarConfDisconf() {
        this.igualesConfDisconf = Arrays.equals(this.getCoordsConformidad(), this.getCoordsDisconformidad());
    }

    public TipoRecibo[] getTiposRecibo() {
        return this.tiposRecibo;
    }

    public void setTipos(TipoRecibo[] tiposRecibo) {
        this.tiposRecibo = tiposRecibo;
    }

    public String[] getAlmacenesSoftware() {
        return this.almacenesSoftware;
    }

    public List<String> getListaAlmacenesSoftware() {
        return Arrays.asList(this.almacenesSoftware);
    }

    public void setalmacenes_software(String[] almacenesSoftware) {
        this.almacenesSoftware = almacenesSoftware;
    }
}

