/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.firma;

import es.mityc.firmaJava.ocsp.exception.OCSPException;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.certificate.ocsp.OCSPLiveConsultant;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseOCSPValidation {
    public static final String TRUSTER_NAME = "my";
    public static final Boolean USE_PROXY = false;
    public static final Boolean IS_PROXY_AUTH = true;
    public static final String PROXY_USER = "";
    public static final String PROXY_PASSWORD = "";
    public static final String PROXY_SERVER = "";
    public static final Integer PROXY_PORT = 3128;

    protected abstract String getCertificateToCheck();

    protected abstract String getOCSPResponder();

    protected abstract String doOCSPValidation(X509Certificate var1, ICertStatusRecoverer var2) throws OCSPException;

    protected String execute() {
        String resultado = null;
        try {
            this.configureConnection();
            String certificateToCheck = this.getCertificateToCheck();
            X509Certificate cert = this.getX509CertificateFromResource(certificateToCheck);
            String ocspServer = this.getOCSPResponder();
            TrustAbstract truster = TrustFactory.getInstance().getTruster(TRUSTER_NAME);
            if (truster == null) {
                System.out.println("No se ha encontrado el validador de confianza por lo que el ejemplo no se puede ejecutar");
            }
            OCSPLiveConsultant certStatusRecoverer = new OCSPLiveConsultant(ocspServer, truster);
            System.out.println("---------------------------");
            System.out.println("------- RESULTADO ---------");
            System.out.println("---------------------------");
            resultado = this.doOCSPValidation(cert, (ICertStatusRecoverer)certStatusRecoverer);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OCSPException ex) {
            Logger.getLogger(BaseOCSPValidation.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultado;
    }

    private X509Certificate getX509CertificateFromResource(String certificateResource) throws CertificateException, IOException {
        X509Certificate cert = null;
        InputStream is = this.getClass().getResourceAsStream(certificateResource);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)cf.generateCertificate(is);
        is.close();
        System.out.println("-----------------------------");
        System.out.println("-- CERTIFICADO A COMPROBAR --");
        System.out.println("-----------------------------");
        System.out.println("Emisor: " + cert.getIssuerDN());
        System.out.println("N\u00famero de serie: " + cert.getSerialNumber());
        System.out.println("V\u00e1lido a partir del: " + cert.getNotBefore());
        System.out.println("V\u00e1lido hasta: " + cert.getNotAfter());
        return cert;
    }

    private void configureConnection() {
        if (USE_PROXY.booleanValue()) {
            System.setProperty("http.proxyHost", "10.1.14.155");
            System.setProperty("http.proxyPort", Integer.toString(PROXY_PORT));
            if (IS_PROXY_AUTH.booleanValue()) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("mlrico", "lucrecia".toCharArray());
                    }
                });
            } else {
                Authenticator.setDefault(null);
            }
        }
    }

    protected String validateOcsp(X509Certificate cert) throws OCSPException {
        String resultado = null;
        try {
            System.out.println("-----------------------------");
            System.out.println("-- CERTIFICADO A COMPROBAR --");
            System.out.println("-----------------------------");
            System.out.println("Emisor: " + cert.getIssuerDN());
            System.out.println("N\u00famero de serie: " + cert.getSerialNumber());
            System.out.println("V\u00e1lido a partir del: " + cert.getNotBefore());
            System.out.println("V\u00e1lido hasta: " + cert.getNotAfter());
            String ocspServer = this.getOCSPResponder();
            TrustAbstract truster = TrustFactory.getInstance().getTruster("my.All");
            if (truster == null) {
                throw new OCSPException("No se ha encontrado el validador de confianza por lo que la validacion ocsp se puede ejecutar");
            }
            OCSPLiveConsultant certStatusRecoverer = new OCSPLiveConsultant(ocspServer, truster);
            System.out.println("---------------------------");
            System.out.println("------- RESULTADO ---------");
            System.out.println("---------------------------");
            resultado = this.doOCSPValidation(cert, (ICertStatusRecoverer)certStatusRecoverer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OCSPException(e.getMessage());
        }
        return resultado;
    }

    public abstract void setOCSP_RESPONDER(String var1);
}

