/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.firma;

import ar.com.lyris.firma.BaseOCSPValidation;
import es.mityc.firmaJava.ocsp.exception.OCSPException;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import java.security.cert.X509Certificate;

public class BasicOCSPValidation
extends BaseOCSPValidation {
    private String ocspResponder;
    private String certificateToCheck;

    @Override
    protected String getCertificateToCheck() {
        return this.certificateToCheck;
    }

    protected void setCertificateToCheck(String cert) {
        this.certificateToCheck = cert;
    }

    @Override
    protected String getOCSPResponder() {
        return this.ocspResponder;
    }

    @Override
    public void setOCSP_RESPONDER(String OCSP_RESPONDER) {
        this.ocspResponder = OCSP_RESPONDER;
    }

    @Override
    protected String doOCSPValidation(X509Certificate certificate, ICertStatusRecoverer certStatusRecoverer) throws OCSPException {
        ICertStatus certStatus = null;
        try {
            certStatus = certStatusRecoverer.getCertStatus(certificate);
        }
        catch (CertStatusException e) {
            String m = e.getMessage();
            System.err.println("Error al comprobar el estado del certificado");
            e.printStackTrace();
            throw new OCSPException(m);
        }
        catch (Exception e) {
            System.err.println("Error al comprobar el estado del certificado");
            e.printStackTrace();
            throw new OCSPException("Error al comprobar el estado del certificado");
        }
        if (certStatus != null) {
            switch (certStatus.getStatus().ordinal()) {
                case 1: {
                    System.out.println("El certificado consultado es v\u00e1lido.");
                    break;
                }
                case 2: {
                    System.out.println("El certificado consultado fue revocado el " + certStatus.getRevokedInfo().getRevokedDate() + ".");
                    break;
                }
                default: {
                    System.out.println("Se desconoce el estado del certificado.");
                    break;
                }
            }
        } else {
            System.out.println("Hubo un error al contactar con el servidor OCSP " + this.getOCSPResponder());
        }
        if (certStatus != null) {
            return certStatus.getStatus().name();
        }
        return null;
    }
}

