/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.firma;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CertificateFileAndPasswordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_FILE_NAME = ".digital_signer_applet.config";
    private static final String PFX_FILE_NAME_KEY = "last-PFX-file-name";
    private JButton mBrowseForCertButton = new JButton();
    private JTextField mCertFileNameTextField = new JTextField();
    private JLabel mChooseCertFileLabel = new JLabel();
    private JTextField mPasswordTextField = new JPasswordField();
    private JLabel mEnterPasswordLabel = new JLabel();
    private JButton mSignButton = new JButton();
    private JButton mCancelButton = new JButton();
    private boolean mResult = false;

    public CertificateFileAndPasswordDialog() {
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(470, 165));
        this.setBackground(SystemColor.control);
        this.setTitle("Seleccionar certificado digital");
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        int centerPosX = (screenSize.width - dialogSize.width) / 2;
        int centerPosY = (screenSize.height - dialogSize.height) / 2;
        this.setLocation(centerPosX, centerPosY);
        this.mChooseCertFileLabel.setText("Seleccione el archivo almac\u00e9n de certificados. (.PFX / .P12) :");
        this.mChooseCertFileLabel.setBounds(new Rectangle(10, 5, 350, 15));
        this.mChooseCertFileLabel.setFont(new Font("Dialog", 0, 12));
        this.mCertFileNameTextField.setBounds(new Rectangle(10, 25, 315, 30));
        this.mCertFileNameTextField.setFont(new Font("DialogInput", 0, 12));
        this.mCertFileNameTextField.setEditable(false);
        this.mCertFileNameTextField.setBackground(SystemColor.control);
        this.mBrowseForCertButton.setText("Examinar");
        this.mBrowseForCertButton.setBounds(new Rectangle(330, 25, 100, 25));
        this.mBrowseForCertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertificateFileAndPasswordDialog.this.browseForCertButton_actionPerformed();
            }
        });
        this.mEnterPasswordLabel.setText("Ingrese la contrase\u00f1a para su clave privada:");
        this.mEnterPasswordLabel.setBounds(new Rectangle(10, 55, 350, 15));
        this.mEnterPasswordLabel.setFont(new Font("Dialog", 0, 12));
        this.mPasswordTextField.setBounds(new Rectangle(10, 75, 400, 30));
        this.mPasswordTextField.setFont(new Font("DialogInput", 0, 12));
        this.mSignButton.setText("Firmar");
        this.mSignButton.setBounds(new Rectangle(110, 110, 75, 25));
        this.mSignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertificateFileAndPasswordDialog.this.signButton_actionPerformed();
            }
        });
        this.mCancelButton.setText("Cancelar");
        this.mCancelButton.setBounds(new Rectangle(220, 110, 100, 25));
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertificateFileAndPasswordDialog.this.cancelButton_actionPerformed();
            }
        });
        this.getContentPane().add((Component)this.mChooseCertFileLabel, null);
        this.getContentPane().add((Component)this.mCertFileNameTextField, null);
        this.getContentPane().add((Component)this.mBrowseForCertButton, null);
        this.getContentPane().add((Component)this.mEnterPasswordLabel, null);
        this.getContentPane().add((Component)this.mPasswordTextField, null);
        this.getContentPane().add((Component)this.mSignButton, null);
        this.getContentPane().add((Component)this.mCancelButton, null);
        this.getRootPane().setDefaultButton(this.mSignButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                String certFileName = CertificateFileAndPasswordDialog.this.mCertFileNameTextField.getText();
                if (certFileName != null && certFileName.length() != 0) {
                    CertificateFileAndPasswordDialog.this.mPasswordTextField.requestFocus();
                } else {
                    CertificateFileAndPasswordDialog.this.mBrowseForCertButton.requestFocus();
                }
            }
        });
    }

    private void browseForCertButton_actionPerformed() {
        JFileChooser fileChooser = new JFileChooser();
        PFXFileFilter pfxFileFilter = new PFXFileFilter();
        fileChooser.addChoosableFileFilter(pfxFileFilter);
        String certFileName = this.mCertFileNameTextField.getText();
        File directory = new File(certFileName).getParentFile();
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog(this) == 0) {
            String selectedCertFile = fileChooser.getSelectedFile().getAbsolutePath();
            this.mCertFileNameTextField.setText(selectedCertFile);
        }
    }

    private void signButton_actionPerformed() {
        this.mResult = true;
        this.hide();
    }

    private void cancelButton_actionPerformed() {
        this.mResult = false;
        this.hide();
    }

    public String getCertificateFileName() {
        String certFileName = this.mCertFileNameTextField.getText();
        return certFileName;
    }

    public String getCertificatePassword() {
        String password = this.mPasswordTextField.getText();
        return password;
    }

    public boolean run() {
        this.setModal(true);
        this.show();
        return this.mResult;
    }

    private static class PFXFileFilter
    extends FileFilter {
        private PFXFileFilter() {
        }

        @Override
        public boolean accept(File aFile) {
            if (aFile.isDirectory()) {
                return true;
            }
            String fileName = aFile.getName().toUpperCase();
            boolean accepted = fileName.endsWith(".PFX") || fileName.endsWith(".P12");
            return accepted;
        }

        @Override
        public String getDescription() {
            return "PKCS#12 certificate keystore file with private key (.PFX, .P12)";
        }
    }
}

