/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.firma;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.FirmaXML;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;

public abstract class GenericXMLSignature {
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private Provider provider;

    protected void execute() throws FileNotFoundException {
        DataToSign dataToSign = this.createDataToSign();
        Document docSigned = null;
        try {
            FirmaXML firma = this.createFirmaXML();
            this.certificate.checkValidity();
            Object[] res = firma.signFile(this.certificate, dataToSign, this.privateKey, this.provider);
            docSigned = (Document)res[0];
        }
        catch (Exception ex) {
            System.err.println("Error realizando la firma");
            ex.printStackTrace();
            return;
        }
        String filePath = this.getSignatureFileName();
        this.saveDocumentToFile(docSigned, this.getSignatureFileName());
    }

    protected abstract DataToSign createDataToSign();

    protected abstract String getSignatureFileName();

    protected FirmaXML createFirmaXML() {
        return new FirmaXML();
    }

    private void saveDocumentToFile(Document document, String pathfile) throws FileNotFoundException {
        try {
            FileOutputStream fos = new FileOutputStream(pathfile);
            UtilidadTratarNodo.saveDocumentToOutputStream((Document)document, (OutputStream)fos, (boolean)true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error al salvar el documento");
            e.printStackTrace();
            throw e;
        }
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

