/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.vistas;

import ar.com.gs.controladores.CertController;
import ar.com.gs.entidades.Token;
import ar.com.lyris.controladores.Principal;
import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.ModoDeEjecucion;
import ar.com.lyris.entidades.TipoFirma;
import ar.com.lyris.entidades.TipoRecibo;
import ar.com.lyris.vistas.CheckBoxCellRenderer;
import ar.com.lyris.vistas.ComponentMover;
import ar.com.lyris.vistas.DropShadowPanel;
import ar.com.lyris.vistas.HeaderRendererCustom;
import com.github.lgooddatepicker.components.DatePicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class Consola
extends JFrame {
    private static int TOKEN_DE_HARDWARE = 0;
    private static int ARCHIVO_DE_CERTIFICADO = 1;
    private static int ALMACEN_DE_WINDOWS = 2;
    private static int ALMACEN_EN_SERVIDOR = 3;
    private static int ALMACENADO_EN_SIGNAR = 4;
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JPasswordField passwordField;
    private JButton botonFirmar;
    public JProgressBar progressBar;
    public JLabel labelProgreso;
    private JTable tabla;
    private JComboBox<String> comboBoxUbicacionDeCert;
    private DefaultTableModel tablaModel;
    private String[] opciones = new String[]{"Token de Hardware", "Archivo de certificado", "Almacen de Windows", "Almacen en Servidor", "Almacenado en Signar"};
    private PrincipalBase principal;
    private JTextField textCert;
    private JComboBox<Token> comboRutaCert;
    public JTextArea txtAreaRazon;
    private JButton botonChooserCert;
    private JLabel lblRutaCert;
    private JLabel lblUsuario;
    public JLabel lblRazon;
    public JComboBox<TipoRecibo> comboTipoFirma;
    private String[] columnas;
    public JComboBox<String> comboTipoPeriodo;
    private JPanel panel;
    Font font;
    Font fontBold;
    private String backgroundColor;
    private Container tabFirmador;
    private Component lblTipoFirma;
    private DatePicker datePicker1;
    private JLabel lblInserteToken;
    private JLabel lblFirmadorDeDocumentos;
    private boolean existenTokensDeHardware = false;
    private boolean interfazCargada;
    List<String> almacenesSoftware = new ArrayList<String>();
    private boolean modoDev = false;
    private int contadorModoDev = 0;
    private JLabel lblClave;
    private JLabel labelCert;
    private static String textCertMessage = "Seleccione un archivo de certificado";
    public static String oscpMessage = "Opcional";
    public static String razonMessage = "Opcional";

    public Consola(final PrincipalBase principal) throws IOException, FontFormatException {
        if (PrincipalBase.isLinux) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {}
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.principal = principal;
        this.backgroundColor = "#2669a0";
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String properties = e.getPropertyName();
                if ("focusOwner".equals(properties) && e.getNewValue() != null) {
                    Component component = (Component)e.getNewValue();
                    String name = component.getName();
                    if ("txtCert".equals(name) && textCertMessage.equals(Consola.this.textCert.getText())) {
                        Consola.this.textCert.setText("");
                        Consola.this.textCert.setForeground(Color.decode("#2C3E50"));
                    } else if ("".equals(Consola.this.textCert.getText())) {
                        Consola.this.textCert.setText(textCertMessage);
                        Consola.this.textCert.setForeground(Color.GRAY);
                    } else if (!textCertMessage.equals(Consola.this.textCert.getText())) {
                        Consola.this.textCert.setForeground(Color.decode("#2C3E50"));
                    }
                    if (Consola.this.txtAreaRazon != null && principal.getModoEjecucion() != null && principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_DOCUMENTOS)) {
                        if ("txtAreaRazon".equals(name) && razonMessage.equals(Consola.this.txtAreaRazon.getText())) {
                            Consola.this.txtAreaRazon.setText("");
                            Consola.this.txtAreaRazon.setForeground(Color.decode("#2C3E50"));
                        } else if ("".equals(Consola.this.txtAreaRazon.getText())) {
                            Consola.this.txtAreaRazon.setText(razonMessage);
                            Consola.this.txtAreaRazon.setForeground(Color.GRAY);
                        }
                    }
                }
            }
        });
        int x = 82;
        InputStream is = Consola.class.getResourceAsStream("/font/Roboto-Regular.ttf");
        this.font = Font.createFont(0, is);
        this.font = this.font.deriveFont(0, 14.0f);
        Font fontSubtitle = this.font.deriveFont(1, 18.0f);
        is = Consola.class.getResourceAsStream("/font/Roboto-Regular.ttf");
        this.fontBold = Font.createFont(0, is);
        this.fontBold = this.fontBold.deriveFont(1, 14.0f);
        is = Consola.class.getResourceAsStream("/font/glyphicons-halflings-regular.ttf");
        Font glyph = Font.createFont(0, is);
        glyph = glyph.deriveFont(0, 24.0f);
        Font glyphSubtitle = glyph.deriveFont(0, 14.0f);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 983, 476);
        this.setMinimumSize(new Dimension(400, 0));
        this.setUndecorated(true);
        this.getRootPane().setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, Color.decode(this.backgroundColor)));
        this.contentPane = new JPanel();
        this.contentPane.setBackground(Color.decode("#f6f6f6"));
        this.contentPane.setBorder(null);
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JLabel label = new JLabel();
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(0);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                principal.finalizar(1);
            }
        });
        label.setForeground(Color.WHITE);
        label.setFont(glyph);
        label.setText(new String(Character.toChars(Integer.parseInt("E014", 16))));
        label.setBounds(941, 3, 37, 45);
        this.contentPane.add(label);
        this.lblFirmadorDeDocumentos = new JLabel("Firmador de documentos");
        this.lblFirmadorDeDocumentos.setVerticalAlignment(3);
        this.lblFirmadorDeDocumentos.setVerticalTextPosition(3);
        this.lblFirmadorDeDocumentos.setFont(this.font.deriveFont(1, 18.0f));
        this.lblFirmadorDeDocumentos.setForeground(Color.decode("#ffffff"));
        this.lblFirmadorDeDocumentos.setBounds(106, 18, 637, 24);
        this.contentPane.add(this.lblFirmadorDeDocumentos);
        JSeparator separator = new JSeparator();
        JPanel panelMinimizar = new JPanel();
        panelMinimizar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Consola.this.setExtendedState(1);
            }
        });
        panelMinimizar.setForeground(Color.WHITE);
        panelMinimizar.setOpaque(false);
        panelMinimizar.setBounds(904, 0, 35, 53);
        this.contentPane.add(panelMinimizar);
        separator.setBorder(new MatteBorder(0, 0, 4, 0, new Color(255, 255, 255)));
        separator.setBackground(Color.decode("#2C3E50"));
        separator.setForeground(Color.decode("#2C3E50"));
        separator.setBounds(909, 3, 26, 9);
        this.contentPane.add(separator);
        JLabel label_1 = new JLabel("V1.6");
        label_1.setBounds(941, 20, 110, 45);
        label_1.setForeground(Color.WHITE);
        this.contentPane.add(label_1);
        this.lblUsuario = new JLabel("Usuario: ");
        this.lblUsuario.setHorizontalAlignment(4);
        this.lblUsuario.setVerticalAlignment(3);
        this.lblUsuario.setForeground(Color.WHITE);
        this.lblUsuario.setFont(this.fontBold.deriveFont(1, 12.0f));
        this.lblUsuario.setBounds(650, 15, 240, 26);
        this.contentPane.add(this.lblUsuario);
        this.tabFirmador = new JPanel();
        this.tabFirmador.setBounds(15, 186, 416, 276);
        this.tabFirmador.setBackground(Color.decode("#ECF0F1"));
        this.tabFirmador.setLayout(null);
        JLabel lblUbicacinDeCertificados = new JLabel("Tipo de almac\u00e9n");
        lblUbicacinDeCertificados.setFont(this.fontBold);
        lblUbicacinDeCertificados.setForeground(Color.decode("#2C3E50"));
        lblUbicacinDeCertificados.setBounds(15, 10, 216, 29);
        this.tabFirmador.add(lblUbicacinDeCertificados);
        this.comboBoxUbicacionDeCert = new JComboBox();
        this.comboBoxUbicacionDeCert.setBackground(Color.WHITE);
        this.comboBoxUbicacionDeCert.setFont(this.fontBold);
        this.comboBoxUbicacionDeCert.setForeground(Color.decode("#2C3E50"));
        this.comboBoxUbicacionDeCert.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
        this.comboBoxUbicacionDeCert.setBounds(201, 10, 200, 29);
        this.tabFirmador.add(this.comboBoxUbicacionDeCert);
        this.lblClave = new JLabel("Clave acceso dispositivo");
        this.lblClave.setFont(this.fontBold);
        this.lblClave.setForeground(Color.decode("#2C3E50"));
        this.lblClave.setBounds(15, 91, 216, 29);
        this.tabFirmador.add(this.lblClave);
        this.passwordField = new JPasswordField(""){
            private static final long serialVersionUID = 872952887924187051L;

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocusInWindow();
            }
        };
        this.passwordField.setEditable(true);
        this.passwordField.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)), new EmptyBorder(0, 5, 0, 0)));
        this.passwordField.setFont(this.font);
        this.passwordField.setEchoChar('*');
        this.passwordField.setBounds(201, 91, 200, 29);
        this.tabFirmador.add(this.passwordField);
        this.botonFirmar = new JButton("Firmar");
        this.botonFirmar.setFocusTraversalPolicyProvider(true);
        this.botonFirmar.setBorder(null);
        this.botonFirmar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (principal.banderaFin) {
                    principal.finalizar(1);
                } else if (Consola.this.comprobarSiSePuedeFirmar()) {
                    Consola.this.botonFirmar.setEnabled(false);
                    new Thread(){

                        @Override
                        public void run() {
                            principal.firmar();
                        }
                    }.start();
                }
            }
        });
        this.botonFirmar.setFont(this.fontBold);
        this.botonFirmar.setForeground(Color.BLACK);
        this.botonFirmar.setEnabled(false);
        this.botonFirmar.setBounds(142, 235, 134, 29);
        this.tabFirmador.add(this.botonFirmar);
        this.comboRutaCert = new JComboBox();
        this.comboRutaCert.setFont(this.fontBold);
        this.comboRutaCert.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
        this.comboRutaCert.setBounds(201, 50, 200, 29);
        this.comboRutaCert.setVisible(false);
        this.tabFirmador.add(this.comboRutaCert);
        this.botonChooserCert = new JButton("+");
        this.botonChooserCert.setBorder(new MatteBorder(2, 0, 2, 2, new Color(220, 228, 236)));
        this.botonChooserCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Consola.this.cargarCertificado();
            }
        });
        this.botonChooserCert.setFont(this.fontBold);
        this.botonChooserCert.setEnabled(false);
        this.botonChooserCert.setVisible(false);
        this.botonChooserCert.setBounds(366, 50, 35, 29);
        this.tabFirmador.add(this.botonChooserCert);
        this.lblRutaCert = new JLabel("Ubicaci\u00f3n del certificado");
        this.lblRutaCert.setFont(this.fontBold);
        this.lblRutaCert.setForeground(Color.decode("#2C3E50"));
        this.lblRutaCert.setBounds(15, 50, 190, 29);
        this.lblRutaCert.setVisible(false);
        this.tabFirmador.add(this.lblRutaCert);
        this.lblInserteToken = new JLabel("Inserte token de hardware");
        this.lblInserteToken.setFont(this.fontBold);
        this.lblInserteToken.setForeground(Color.decode("#8b0000"));
        this.lblInserteToken.setBounds(201, 10, 200, 29);
        this.lblInserteToken.setVisible(true);
        this.tabFirmador.add(this.lblInserteToken);
        this.textCert = new JTextField(textCertMessage);
        this.textCert.setHorizontalAlignment(2);
        this.textCert.setEditable(true);
        this.textCert.setFont(this.font);
        this.textCert.setName("");
        this.textCert.setForeground(Color.GRAY);
        this.textCert.setBackground(Color.WHITE);
        this.textCert.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 0, new Color(220, 228, 236)), new EmptyBorder(0, 5, 0, 0)));
        this.textCert.setBounds(201, 50, 165, 29);
        this.textCert.setVisible(false);
        this.textCert.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Consola.this.textCert.setForeground(Color.decode("#2C3E50"));
                if (textCertMessage.equals(Consola.this.textCert.getText())) {
                    Consola.this.textCert.setText("");
                    Consola.this.textCert.setForeground(Color.decode("#2C3E50"));
                }
            }
        });
        this.tabFirmador.add(this.textCert);
        this.comboBoxUbicacionDeCert.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Consola.this.redefinirUbicacion();
                }
            }
        });
        this.labelCert = new JLabel();
        this.labelCert.setFont(this.font);
        this.labelCert.setVisible(false);
        this.labelCert.setHorizontalAlignment(2);
        this.labelCert.setBounds(201, 50, 200, 29);
        this.labelCert.setBackground(Color.WHITE);
        this.tabFirmador.add(this.labelCert);
        JLabel imagen = new JLabel("");
        imagen.setBounds(12, 2, 100, 53);
        this.contentPane.add(imagen);
        imagen.setIcon(new ImageIcon(Consola.resize(ImageIO.read(this.getClass().getResource("/img/logo-navbar_min.png")), 90, 25)));
        BufferedImage imgStream = ImageIO.read(this.getClass().getResource("/img/icon.png"));
        this.setIconImage(imgStream);
        this.setTitle("Complemento de firma de Signar");
        JLabel titleBar = new JLabel("");
        titleBar.setBackground(Color.decode(this.backgroundColor));
        titleBar.setOpaque(true);
        titleBar.setBorder(null);
        titleBar.setBounds(0, 0, 1245, 53);
        this.contentPane.add(titleBar);
        DropShadowPanel SombraTitleBar = new DropShadowPanel(7);
        SombraTitleBar.setBounds(-5, 0, 1010, 60);
        this.contentPane.add(SombraTitleBar);
        SombraTitleBar.setLayout(null);
        new ComponentMover(this, titleBar);
        this.panel = new JPanel();
        this.panel.setBounds(12, 0, 950, 551);
        this.panel.setBackground(Color.WHITE);
        this.contentPane.add(this.panel);
        this.panel.setLayout(null);
        JLabel lblConfiguracion = new JLabel("Parametros de firmado");
        lblConfiguracion.setForeground(Color.decode("#2C3E50"));
        lblConfiguracion.setFont(fontSubtitle);
        lblConfiguracion.setBounds(38, 157, 291, 32);
        this.panel.add(lblConfiguracion);
        this.panel.add(this.tabFirmador);
        JLabel lblProgreso = new JLabel("Progreso");
        lblProgreso.setForeground(Color.decode("#2669a0"));
        lblProgreso.setFont(fontSubtitle);
        lblProgreso.setBounds(38, 60, 112, 24);
        this.panel.add(lblProgreso);
        JLabel lblDocumentosYEstados = new JLabel("Documentos y estados");
        lblDocumentosYEstados.setForeground(Color.decode("#2C3E50"));
        lblDocumentosYEstados.setFont(fontSubtitle);
        lblDocumentosYEstados.setBounds(447, 60, 328, 29);
        this.panel.add(lblDocumentosYEstados);
        JPanel progressHolder = new JPanel();
        progressHolder.setBackground(Color.decode("#ECF0F1"));
        progressHolder.setBounds(15, 86, 416, 67);
        this.panel.add(progressHolder);
        progressHolder.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(15, 30, 386, 29);
        this.progressBar.setBackground(Color.white);
        this.progressBar.setForeground(Color.decode(this.backgroundColor));
        this.progressBar.setFont(this.fontBold);
        progressHolder.add(this.progressBar);
        this.progressBar.setStringPainted(true);
        this.progressBar.setName("");
        this.labelProgreso = new JLabel("Autenticando");
        this.labelProgreso.setBounds(15, 2, 386, 29);
        progressHolder.add(this.labelProgreso);
        this.labelProgreso.setForeground(Color.decode("#2C3E50"));
        this.labelProgreso.setFont(this.fontBold);
        JLabel glyphProgreso = new JLabel("");
        glyphProgreso.setForeground(Color.decode("#2C3E50"));
        glyphProgreso.setFont(glyphSubtitle);
        glyphProgreso.setText(new String(Character.toChars(Integer.parseInt("E031", 16))));
        glyphProgreso.setBounds(20, 62, 60, 20);
        this.panel.add(glyphProgreso);
        JLabel glyphParametro = new JLabel("");
        glyphParametro.setForeground(Color.decode("#2C3E50"));
        glyphParametro.setFont(glyphSubtitle);
        glyphParametro.setText(new String(Character.toChars(Integer.parseInt("E136", 16))));
        glyphParametro.setBounds(20, 164, 60, 20);
        this.panel.add(glyphParametro);
        glyphParametro.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Consola.this.contadorModoDev == 4 && !Consola.this.modoDev) {
                    Consola.this.cargarRecibosModoDev();
                } else if (principal.getModoEjecucion().equals((Object)ModoDeEjecucion.CARGA_RECIBOS)) {
                    Consola consola = Consola.this;
                    consola.contadorModoDev = consola.contadorModoDev + 1;
                }
            }
        });
        DropShadowPanel panelDeSombra = new DropShadowPanel(3);
        panelDeSombra.setBounds(9, 0, 956, 551);
        this.contentPane.add(panelDeSombra);
    }

    private void cargarRecibosModoDev() {
        this.modoDev = true;
        this.comboBoxUbicacionDeCert.setEnabled(true);
        this.comboBoxUbicacionDeCert.setVisible(true);
        this.comboBoxUbicacionDeCert.addItem(this.opciones[1]);
        this.comboBoxUbicacionDeCert.setSelectedItem(this.opciones[1]);
        this.redefinirUbicacion();
    }

    protected boolean comprobarSiSePuedeFirmar() {
        if (this.comboBoxUbicacionDeCert.getSelectedItem() != null && this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[2])) {
            return true;
        }
        if (this.passwordField.getPassword().length == 0) {
            Consola.mostrarMensaje("Ingrese una clave", "");
            return false;
        }
        if (this.comboBoxUbicacionDeCert.getItemCount() == 0) {
            Consola.mostrarMensaje("Conecte el token para continuar", "");
            return false;
        }
        return true;
    }

    public void actualizarPorModoEjecucion() {
        switch (this.principal.getModoEjecucion()) {
            case CARGA_RECIBOS: {
                int offset = 0;
                if (!this.principal.patronContieneTipo()) {
                    offset += 40;
                    this.lblTipoFirma = new JLabel("Tipo de recibo");
                    this.lblTipoFirma.setFont(this.fontBold);
                    this.lblTipoFirma.setForeground(Color.decode("#2C3E50"));
                    this.lblTipoFirma.setBounds(15, 130, 190, 29);
                    this.tabFirmador.add(this.lblTipoFirma);
                    this.comboTipoFirma = new JComboBox();
                    for (TipoRecibo r : TipoRecibo.ListaOrdenada()) {
                        this.comboTipoFirma.addItem(r);
                    }
                    this.comboTipoFirma.setBackground(Color.WHITE);
                    this.comboTipoFirma.setFont(this.fontBold);
                    this.comboTipoFirma.setForeground(Color.decode("#2C3E50"));
                    this.comboTipoFirma.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
                    this.comboTipoFirma.setBounds(201, 130, 200, 29);
                    this.comboTipoFirma.setSelectedIndex(1);
                    this.comboTipoFirma.setVisible(true);
                    this.tabFirmador.add(this.comboTipoFirma);
                }
                if (!this.principal.patronContieneFechaCompleta()) {
                    JLabel lblFechaEmision = new JLabel();
                    lblFechaEmision.setVisible(true);
                    lblFechaEmision = new JLabel("Fecha de Emision");
                    lblFechaEmision.setFont(this.fontBold);
                    lblFechaEmision.setForeground(Color.decode("#2C3E50"));
                    lblFechaEmision.setBounds(15, 130 + offset, 190, 29);
                    this.tabFirmador.add(lblFechaEmision);
                    this.datePicker1 = new DatePicker();
                    LocalDate fechaPorDefecto = this.principal.calcularFechaPorDefecto();
                    this.datePicker1.setDate(fechaPorDefecto);
                    this.datePicker1.setBounds(201, 130 + offset, 200, 29);
                    System.out.println(this.datePicker1.getDate().atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME));
                    this.tabFirmador.add((Component)this.datePicker1);
                }
                this.lblFirmadorDeDocumentos.setText("Firma de Recibos");
                this.tabFirmador.repaint();
                break;
            }
            case FIRMA_RECIBOS: {
                this.principal.actualizarConfDisconf();
                try {
                    this.almacenesSoftware = this.principal.getMetadatos().getModuloRecibos().getListaAlmacenesSoftware();
                }
                catch (NullPointerException e) {
                    this.almacenesSoftware = new ArrayList<String>();
                }
                this.comboBoxUbicacionDeCert.setEnabled(false);
                this.comboBoxUbicacionDeCert.setVisible(false);
                if (this.almacenesSoftware.contains("file")) {
                    this.agregarUbicacionDeCert(this.opciones[1]);
                }
                if (this.almacenesSoftware.contains("path")) {
                    if (this.principal.getMetadatos().getModuloRecibos().getRutaCertificados() == null) {
                        this.principal.informarProblemaIrrecuperable("No est\u00e1 configurada la ruta del servidor de certificados", "Error de configuracion de modulo de recibos");
                    }
                    this.agregarUbicacionDeCert(this.opciones[3]);
                }
                if (this.almacenesSoftware.contains("mscapi") && CertController.SO == 1) {
                    this.agregarUbicacionDeCert(this.opciones[2]);
                }
                if (this.almacenesSoftware.contains("backup") && this.principal.getMetadatos().getUsuario().hasCloudKeystore()) {
                    this.agregarUbicacionDeCert(this.opciones[4]);
                }
                this.lblFirmadorDeDocumentos.setText("Firma de Recibos");
                break;
            }
            default: {
                this.lblRazon = new JLabel("Raz\u00f3n de la firma");
                this.lblRazon.setFont(this.fontBold);
                this.lblRazon.setForeground(Color.decode("#2C3E50"));
                this.lblRazon.setBounds(15, 131, 190, 29);
                this.tabFirmador.add(this.lblRazon);
                this.comboBoxUbicacionDeCert.addItem(this.opciones[1]);
                this.comboBoxUbicacionDeCert.setSelectedItem(this.opciones[1]);
                if (CertController.SO == 1) {
                    this.agregarUbicacionDeCert(this.opciones[2]);
                }
                if (this.principal.getMetadatos().getUsuario().hasCloudKeystore()) {
                    this.agregarUbicacionDeCert(this.opciones[4]);
                    this.comboBoxUbicacionDeCert.setSelectedItem(this.opciones[4]);
                }
                this.txtAreaRazon = new JTextArea(razonMessage);
                this.txtAreaRazon.setLineWrap(true);
                this.txtAreaRazon.setFont(this.font);
                this.txtAreaRazon.setName("txtAreaRazon");
                this.txtAreaRazon.setForeground(Color.GRAY);
                this.txtAreaRazon.setBorder(new EmptyBorder(0, 5, 0, 0));
                JScrollPane sp = new JScrollPane(this.txtAreaRazon);
                sp.setBounds(13, 155, 388, 69);
                sp.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
                this.tabFirmador.add(sp);
            }
        }
        if (this.existenTokensDeHardware) {
            this.updateTokenStatus();
        }
        this.inicializarTabla();
        this.updateUser();
        this.redefinirUbicacion();
        this.interfazCargada = true;
    }

    private void agregarUbicacionDeCert(String string) {
        this.comboBoxUbicacionDeCert.addItem(string);
        this.comboBoxUbicacionDeCert.setSelectedItem(string);
        this.comboBoxUbicacionDeCert.setEnabled(true);
        this.comboBoxUbicacionDeCert.setVisible(true);
    }

    public void inicializarTabla() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        scrollPane.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setBounds(446, 86, 489, 375);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.panel.add(scrollPane);
        scrollPane.setAutoscrolls(true);
        this.tabla = new JTable(){
            private static final long serialVersionUID = -6178446841435519184L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component returnComp = super.prepareRenderer(renderer, row, column);
                Color alternateColor = new Color(250, 250, 250);
                Color whiteColor = Color.WHITE;
                if (!returnComp.getBackground().equals(this.getSelectionBackground())) {
                    Color bg = row % 2 == 0 ? whiteColor : alternateColor;
                    returnComp.setBackground(bg);
                    bg = null;
                }
                return returnComp;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (Consola.this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS) && column == 2) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (Consola.this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS) && column == 2) {
                    TipoFirma value = (TipoFirma)((Object)this.getValueAt(row, 0));
                    return value.equals((Object)TipoFirma.REC);
                }
                return super.isCellEditable(row, column);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                if (Consola.this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS)) {
                    try {
                        if (!Consola.this.principal.getDocumentos().get(row).isRecibo() && col == 2) {
                            return "Atributo solo configurable para recibos";
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return tip;
            }
        };
        this.columnas = this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS) ? "Tipo;Documento;Conformidad;Estado".split(";") : "Tipo;Documento;Estado".split(";");
        this.tabla.setModel(this.setTablaModel(new DefaultTableModel(null, this.columnas)));
        if (this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS)) {
            this.tabla.getColumnModel().getColumn(2).setCellRenderer(new CheckBoxCellRenderer());
            this.tabla.getColumnModel().getColumn(2).setHeaderRenderer(new HeaderRendererCustom(this.tabla.getTableHeader(), (Principal)this.principal));
            this.tabla.getColumnModel().getColumn(3).setMaxWidth(100);
            this.tabla.getColumnModel().getColumn(3).setPreferredWidth(90);
            this.tabla.getColumnModel().getColumn(3).setMinWidth(90);
        }
        this.tabla.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.tabla.getColumnModel().getColumn(0).setMaxWidth(50);
        this.tabla.getColumnModel().getColumn(0).setMinWidth(50);
        this.tabla.getColumnModel().getColumn(1).setMinWidth(80);
        this.tabla.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.tabla.getColumnModel().getColumn(2).setMaxWidth(90);
        this.tabla.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.tabla.getColumnModel().getColumn(2).setMinWidth(90);
        this.tabla.doLayout();
        this.tabla.setBorder(BorderFactory.createEmptyBorder());
        this.tabla.setShowGrid(false);
        this.tabla.setBackground(Color.WHITE);
        this.tabla.setRowSelectionAllowed(false);
        this.tabla.setForeground(Color.decode("#2C3E50"));
        this.tabla.setFont(this.font);
        this.tabla.setIntercellSpacing(new Dimension(0, 0));
        this.tabla.getTableHeader().setBackground(Color.decode("#ECF0F1"));
        this.tabla.getTableHeader().setForeground(Color.decode("#2C3E50"));
        this.tabla.getTableHeader().setFont(this.fontBold.deriveFont(1, 13.0f));
        this.tabla.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.decode("#ECF0F1")));
        this.tabla.setRowHeight(20);
        this.tabla.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                System.out.println(String.valueOf(row) + " " + column);
                if (column == 2) {
                    Consola.this.principal.getDocumentos().get(row).setEnConformidad((Boolean)target.getValueAt(row, column));
                }
            }
        });
        scrollPane.setViewportView(this.tabla);
    }

    protected void cargarCertificado() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            System.out.println("Archivo seleccionado: " + chooser.getSelectedFile().getName());
            this.textCert.setText(chooser.getSelectedFile().getPath());
        }
    }

    protected void redefinirUbicacion() {
        if (this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.CARGA_RECIBOS) && !this.principal.hayTokensConectados()) {
            this.comboBoxUbicacionDeCert.setEnabled(false);
            this.comboBoxUbicacionDeCert.setVisible(false);
        }
        if (this.comboBoxUbicacionDeCert.getItemCount() == 0) {
            this.comboBoxUbicacionDeCert.setEnabled(false);
            this.comboBoxUbicacionDeCert.setVisible(false);
        } else if (this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[TOKEN_DE_HARDWARE])) {
            this.passwordField.setVisible(true);
            this.lblClave.setVisible(true);
            this.comboRutaCert.setVisible(true);
            this.lblRutaCert.setText(this.opciones[TOKEN_DE_HARDWARE]);
            this.lblRutaCert.setVisible(true);
            this.textCert.setVisible(false);
            this.botonChooserCert.setVisible(false);
            this.botonChooserCert.setEnabled(false);
            this.habilitarFirmado();
        } else if (this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[ARCHIVO_DE_CERTIFICADO])) {
            this.passwordField.setVisible(true);
            this.lblClave.setVisible(true);
            this.comboRutaCert.setVisible(false);
            this.textCert.setVisible(true);
            this.textCert.setEditable(true);
            this.lblRutaCert.setText(this.opciones[ARCHIVO_DE_CERTIFICADO]);
            this.lblRutaCert.setVisible(true);
            this.botonChooserCert.setVisible(true);
            this.botonChooserCert.setEnabled(true);
            if (!"Seleccione un archivo de certificado".equals(this.textCert.getText())) {
                this.habilitarFirmado();
            }
        } else if (this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[ALMACEN_DE_WINDOWS])) {
            this.passwordField.setVisible(false);
            this.lblClave.setVisible(false);
            this.comboRutaCert.setVisible(false);
            this.textCert.setVisible(false);
            this.lblRutaCert.setVisible(false);
            this.botonChooserCert.setVisible(false);
            this.botonChooserCert.setEnabled(false);
        } else if (this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[ALMACEN_EN_SERVIDOR])) {
            this.passwordField.setVisible(true);
            this.lblClave.setVisible(true);
            this.comboRutaCert.setVisible(false);
            this.lblRutaCert.setText(this.opciones[ALMACEN_EN_SERVIDOR]);
            this.lblRutaCert.setVisible(true);
            this.textCert.setVisible(false);
            this.labelCert.setText(String.valueOf(this.principal.getMetadatos().getUsuario().getAcceso()) + ".p12");
            this.labelCert.setVisible(true);
            this.botonChooserCert.setVisible(false);
            this.botonChooserCert.setEnabled(false);
        } else if (this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[ALMACENADO_EN_SIGNAR])) {
            this.passwordField.setVisible(true);
            this.lblClave.setVisible(true);
            this.comboRutaCert.setVisible(false);
            this.lblRutaCert.setText(this.opciones[ALMACENADO_EN_SIGNAR]);
            this.lblRutaCert.setVisible(true);
            this.textCert.setVisible(false);
            this.labelCert.setText(this.principal.getMetadatos().getUsuario().getAcceso());
            this.labelCert.setVisible(true);
            this.botonChooserCert.setVisible(false);
            this.botonChooserCert.setEnabled(false);
        }
    }

    public void refrescarTabla() {
        if (this.tabla != null) {
            int docsProcesados = this.principal.getDocsProcesados();
            int cantDocs = this.principal.getCantDocumentos();
            this.setLabelBarra(String.valueOf(this.principal.estadoApp.getNombre()) + " documentos (" + docsProcesados + "/" + cantDocs + "):");
            if (this.principal.getProgressWorker() != null) {
                this.principal.getProgressWorker().refrescarSinDelay();
            }
            ((DefaultTableModel)this.tabla.getModel()).setRowCount(cantDocs);
            this.refrescarIdTabla(-1);
        }
    }

    public void refrescarIdTabla(int id) {
        if (this.tabla != null) {
            int i = 0;
            while (i < this.principal.getCantDocumentos()) {
                Documento doc = this.principal.getDocumentos().get(i);
                if (id < 0 || doc.getId() == id) {
                    this.tabla.setValueAt((Object)doc.getTif(), i, 0);
                    this.tabla.setValueAt(doc.getPrintableFileName(), i, 1);
                    if (this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS)) {
                        if (doc.isRecibo()) {
                            this.tabla.setValueAt(doc.getEnConformidad(), i, 2);
                        }
                        this.tabla.setValueAt((Object)doc.getEstado(), i, 3);
                    } else {
                        this.tabla.setValueAt((Object)doc.getEstado(), i, 2);
                    }
                }
                ++i;
            }
        }
    }

    public void habilitarFirmado() {
        this.refrescarTabla();
        if (this.principal.getProgressWorker() != null) {
            this.principal.finalizarProgressWorker();
            this.principal.getProgressWorker().isDone();
        }
        String modoDeEjecucion = this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_DOCUMENTOS) ? "Documentos" : "Recibos";
        this.labelProgreso.setText(String.valueOf(modoDeEjecucion) + " listos. Boton de firma habilitado");
        this.progressBar.setValue(100);
        this.botonFirmar.setBackground(Color.decode(this.backgroundColor));
        this.botonFirmar.setEnabled(true);
    }

    public void deshabilitarFirmado() {
        this.botonFirmar.setBackground(Color.LIGHT_GRAY);
        this.botonFirmar.setEnabled(false);
    }

    public DefaultTableModel getTablaModel() {
        return this.tablaModel;
    }

    public DefaultTableModel setTablaModel(DefaultTableModel tablaModel) {
        this.tablaModel = tablaModel;
        return tablaModel;
    }

    public static BufferedImage resize(Object img, int percent) {
        BufferedImage buff = (BufferedImage)img;
        return Consola.resize(buff, 45, 79);
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public String getRazonText() {
        return this.txtAreaRazon.getText();
    }

    public boolean tokenDeSoftwareSeleccionado() {
        return this.comboBoxUbicacionDeCert.getSelectedItem() != null && !this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[0]);
    }

    public String getPathTokenSoftware() {
        return this.textCert.getText();
    }

    public String getUrlImagen() {
        return "";
    }

    public String getProviderDeTokenSeleccionado() {
        return ((Token)this.comboRutaCert.getSelectedItem()).getProvider().getName();
    }

    public void finalizacion(String tipoDeFinalizacion) {
        this.principal.finalizarProgressWorker();
        this.labelProgreso.setText("El programa finalizo " + tipoDeFinalizacion);
        this.progresoCompleto();
    }

    public void setLabelBarra(String string) {
        if (this.labelProgreso != null) {
            this.labelProgreso.setText(string);
        }
    }

    public void updateUser() {
        this.lblUsuario.setText("Usuario: " + this.principal.getMetadatos().getUsuario().getAcceso());
    }

    public String getTextCert() {
        return this.textCert.getText();
    }

    public TipoRecibo getTipoReciboSeleccionado() {
        return (TipoRecibo)this.comboTipoFirma.getSelectedItem();
    }

    public void setTextCert(String textCert) {
        this.textCert.setText(textCert);
    }

    public void setProgress(int i, int nroDocs) {
        if (i == 0 && nroDocs == 0) {
            this.progressBar.setValue(0);
        }
    }

    private static void mostrarMensaje(String mensaje, String tipo) {
        System.out.println(mensaje);
        JOptionPane.showMessageDialog(null, mensaje);
    }

    public void informarFallo(String string) {
        JOptionPane.showMessageDialog(this, string, "Insane error", 0);
    }

    public void progresoCompleto() {
        this.progressBar.setValue(100);
    }

    public void updateTokenStatus() {
        if (this.comboRutaCert.getItemCount() == 0) {
            this.comboBoxUbicacionDeCert.addItem(this.opciones[0]);
            this.comboBoxUbicacionDeCert.setVisible(true);
            this.comboBoxUbicacionDeCert.setEnabled(true);
        }
        this.comboBoxUbicacionDeCert.setSelectedItem(this.opciones[0]);
        this.redefinirUbicacion();
        this.comboRutaCert.removeAllItems();
        for (Token t : this.principal.getTokens()) {
            if (!t.isConnected()) continue;
            this.comboRutaCert.addItem(t);
        }
    }

    public String getFechaEmision() {
        return this.datePicker1.getDate().atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public void repaintTabFirmador() {
        this.tabFirmador.repaint();
    }

    public void nuevoTokenConectado() {
        this.existenTokensDeHardware = true;
        if (this.interfazCargada) {
            this.updateTokenStatus();
        }
    }

    public boolean esUbicacionCertEnServer() {
        return this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[3]);
    }

    public boolean esUbicacionCertEnSignar() {
        return this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[4]);
    }

    public boolean MSCAPISeleccionado() {
        return this.comboBoxUbicacionDeCert.getSelectedItem().equals(this.opciones[2]);
    }
}

