/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.vistas;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.entidades.EstadoDoc;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressWorker
extends SwingWorker<Void, Integer> {
    private JProgressBar pb;
    private PrincipalBase principal;
    int delay;
    int index;
    int nroDocs;
    int maxParcial;
    int maxParcialAnterior;

    public ProgressWorker(PrincipalBase principalBase) {
        this.principal = principalBase;
        this.delay = 1000;
        this.index = 0;
        this.nroDocs = 0;
        this.maxParcial = 10;
        this.maxParcialAnterior = 10;
    }

    @Override
    protected void process(List<Integer> chunks) {
        if (!this.isDone()) {
            this.pb.setValue(chunks.get(chunks.size() - 1));
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (this.pb.getValue() < 99) {
            this.delay = this.principal.tiempoDeSleepsDeTesting != 0 ? 500 : (this.principal.getCantDocumentos() >= 4 ? 4000 : 1000 * this.principal.getCantDocumentos());
            this.logicaDeProgreso();
            if (this.index >= this.maxParcial) continue;
            ++this.index;
            this.publish(this.index);
            Thread.sleep(this.delay);
        }
        return null;
    }

    private void logicaDeProgreso() {
        this.nroDocs = this.principal.getCantDocEnEstados(EstadoDoc.INVALIDO, this.principal.estadoApp.getEstadoCompleto());
        if (this.principal.getCantDocumentos() == 0) {
            return;
        }
        this.maxParcial = 100 / this.principal.getCantDocumentos() * (this.nroDocs + 1);
        if (this.maxParcial != this.maxParcialAnterior) {
            this.index = 100 / this.principal.getCantDocumentos() * this.nroDocs;
            this.maxParcialAnterior = this.maxParcial;
        }
    }

    public void refrescarSinDelay() {
        this.logicaDeProgreso();
        this.publish(this.index);
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            System.out.println("Cancelado correctamente. no es error");
        }
    }

    public void setPBar() {
        this.pb = this.principal.getFrame().progressBar;
        this.pb.setValue(0);
    }
}

