/*
 * Decompiled with CFR 0.152.
 */
package ar.com.gs.controladores;

import ar.com.gs.controladores.DialogTokenPassword;
import ar.com.gs.controladores.TokenConectadoCallback;
import ar.com.gs.controladores.WorkerToken;
import ar.com.gs.entidades.Certificado;
import ar.com.gs.entidades.Token;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class CertController {
    public static volatile CertController certController;
    public static final int UNDEFINED = 0;
    public static final int WINDOWS = 1;
    public static final int LINUX = 2;
    public static final int MACOS = 3;
    public static int SO;
    public static int ARCH;
    private static final Logger LOG;
    private static PKCS11 tmpPKCS11;
    private static boolean tokenEncontrado;
    private AuthProvider aprov;
    private KeyStore ks;
    private String alias = null;
    private boolean useMSCAPI = false;
    private List<Certificado> certificados;
    private List<Token> tokens;
    private List<Long> usedSlots = new ArrayList<Long>();
    private WorkerToken workerToken;
    private Certificado certificadoSeleccionado;

    static {
        SO = 0;
        ARCH = 64;
        LOG = Logger.getLogger(CertController.class.getName());
    }

    private CertController() {
        this.setTokens(new ArrayList<Token>());
        String so = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("sun.arch.data.model");
        if (so.indexOf("win") >= 0) {
            SO = 1;
        } else if (so.indexOf("nux") >= 0) {
            SO = 2;
        } else if (so.indexOf("mac") >= 0) {
            SO = 3;
        }
        ARCH = arch.equals("64") ? 64 : 32;
        System.out.println("Modulo Gestor Certificados V2");
        this.workerToken = WorkerToken.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertController getInstance() {
        if (certController != null) return certController;
        Class<CertController> clazz = CertController.class;
        synchronized (CertController.class) {
            if (certController != null) return certController;
            certController = new CertController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return certController;
        }
    }

    public void esExcluyenteTokenHard() {
        this.workerToken.setTokenHardExcluyente();
    }

    public void initKeystore(String tipoToken, char[] password, String pathCert) throws Exception {
        this.certificados = new ArrayList<Certificado>();
        int noValidos = 0;
        int expirados = 0;
        try {
            if (tipoToken.equals("SW")) {
                if (this.isMSCAPI()) {
                    ClassLoader classLoader = CertController.class.getClassLoader();
                    try {
                        Class<?> MSCAPIClass = classLoader.loadClass("sun.security.mscapi.SunMSCAPI");
                        System.out.println("aClass.getName() = " + MSCAPIClass.getName());
                        BouncyCastleProvider providerBC = new BouncyCastleProvider();
                        Security.addProvider((Provider)providerBC);
                        Constructor<?> constructor = MSCAPIClass.getConstructor(new Class[0]);
                        Security.addProvider((Provider)constructor.newInstance(new Object[0]));
                        this.ks = KeyStore.getInstance("Windows-MY");
                        this.ks.load(null, null);
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("Se trat\u00f3 de instanciar MSCAPI y fall\u00f3");
                        e.printStackTrace();
                    }
                } else {
                    String filename = pathCert;
                    this.ks = KeyStore.getInstance("PKCS12");
                    FileInputStream keyStoreStream = new FileInputStream(filename);
                    this.ks.load(keyStoreStream, password);
                }
            } else {
                this.aprov = (AuthProvider)Security.getProvider(pathCert);
                System.out.println(pathCert);
                DialogTokenPassword cmdLineHdlr = new DialogTokenPassword(password);
                KeyStore.Builder ksBuilder = KeyStore.Builder.newInstance("PKCS11", this.aprov, new KeyStore.CallbackHandlerProtection((CallbackHandler)((Object)cmdLineHdlr)));
                this.aprov.login(new Subject(), (CallbackHandler)((Object)cmdLineHdlr));
                this.ks = ksBuilder.getKeyStore();
            }
            LOG.log(Level.INFO, "-- CERTIFICADOS DE FIRMA --");
            Enumeration<String> aliases = this.ks.aliases();
            System.out.println("Cantidad de alias de certificado: " + this.ks.size());
            while (aliases.hasMoreElements()) {
                this.alias = aliases.nextElement();
                System.out.println(this.alias);
                X509Certificate certAux = (X509Certificate)this.ks.getCertificate(this.alias);
                System.out.println(String.valueOf(this.alias) + " tiene clave asociada?" + this.ks.isKeyEntry(this.alias));
                if (!this.ks.isKeyEntry(this.alias)) continue;
                PrivateKey pk = (PrivateKey)this.ks.getKey(this.alias, password);
                Certificate[] chainAux = this.ks.getCertificateChain(this.alias);
                System.out.println("La cadena obtenida cuenta con " + chainAux.length + " certificados.");
                try {
                    certAux.checkValidity();
                    this.certificados.add(new Certificado(this.alias, certAux, pk, chainAux));
                }
                catch (CertificateExpiredException e) {
                    e.printStackTrace();
                    ++expirados;
                }
                catch (CertificateNotYetValidException e) {
                    ++noValidos;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CertificateExpiredException e) {
            throw new Exception("No se puede firmar. El certificado ha expirado.");
        }
        catch (CertificateNotYetValidException e) {
            throw new Exception("No se puede firmar. El certificado a\u00fan no es v\u00e1lido.");
        }
        catch (KeyStoreException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            LOG.log(Level.INFO, "Verifique que el token este conectado. Verifique su contrase\ufffda.");
            throw new Exception("Error - Verifique que el token este conectado. Verifique su contrase\ufffda.");
        }
        catch (ProviderException ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            LOG.log(Level.INFO, "Verifique que el token este conectado.");
            throw new ProviderException("Verifique que el token este conectado y ejecute nuevamente la aplicacion.");
        }
        catch (FailedLoginException ex) {
            throw new Exception("Contrase\u00f1a incorrecta");
        }
        catch (FileNotFoundException ex) {
            throw new Exception("No se encontr\u00f3 el archivo de certificado en destino.");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            LOG.log(Level.INFO, "Error de autenticaci\u00f3n.");
            throw new Exception("Error de autenticaci\u00f3n.");
        }
        if (this.certificados.isEmpty()) {
            if (expirados > 0 || noValidos > 0) {
                throw new Exception("El/los certificado/s estan expirados o no son v\ufffdlidos.");
            }
            throw new Exception("No se encontraron certificados.");
        }
    }

    public boolean initiatePkcs11Provider(Token t) throws Exception {
        long slot = CertController.getSlot(t.getDriver());
        String pkcs11ConfigTemp = String.valueOf(t.getPkcs11ConfigSettings()) + "\nslot=" + slot;
        if (tokenEncontrado) {
            System.out.println("Token encontrado");
            this.usedSlots.add(slot);
            SunPKCS11 result = new SunPKCS11((InputStream)new ByteArrayInputStream(pkcs11ConfigTemp.getBytes()));
            Security.addProvider(result);
            t.setProvider(result);
            t.setConnected(true);
            return true;
        }
        return false;
    }

    public static long[] getSlotsWithTokens(String libraryPath) throws IOException {
        CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
        String functionList = "C_GetFunctionList";
        tmpPKCS11 = null;
        long[] slotList = null;
        tokenEncontrado = false;
        try {
            try {
                try {
                    tmpPKCS11 = PKCS11.getInstance(libraryPath, functionList, initArgs, false);
                }
                catch (PKCS11Exception pKCS11Exception) {}
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Exception e) {
            try {
                initArgs = null;
                tmpPKCS11 = PKCS11.getInstance(libraryPath, functionList, initArgs, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (PKCS11Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            long[] lArray = slotList = tmpPKCS11.C_GetSlotList(true);
            int n = slotList.length;
            int n2 = 0;
            while (n2 < n) {
                long slot = lArray[n2];
                CK_TOKEN_INFO tokenInfo = tmpPKCS11.C_GetTokenInfo(slot);
                tokenEncontrado = true;
                LOG.log(Level.INFO, "slot: " + slot + "\nmanufacturerID: " + String.valueOf(tokenInfo.manufacturerID) + "\nmodel: " + String.valueOf(tokenInfo.model));
                ++n2;
            }
        }
        catch (PKCS11Exception ex) {
            if (ex.getCause() != null && !ex.getCause().equals("CKR_TOKEN_NOT_RECOGNIZED")) {
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return slotList;
    }

    public static long getSlot(String libraryPath) throws IOException {
        long[] slots = CertController.getSlotsWithTokens(libraryPath);
        long slot = 0L;
        try {
            if (slots.length > 0) {
                slot = slots[0];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return slot;
    }

    public void loadInstalledTokens() {
        this.loadTokens();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadTokens() {
        Scanner scanner = new Scanner(CertController.class.getResourceAsStream("token.list"));
        String driver = null;
        scanner.nextLine();
        block5: while (scanner.hasNextLine()) {
            String[] s = scanner.nextLine().split("[ ]*;[ ]*");
            switch (SO) {
                case 1: {
                    if (s[2].equals("undefined")) continue block5;
                    String location = "System32";
                    driver = String.valueOf(System.getenv("WINDIR")) + File.separator + location + File.separator + s[2];
                    break;
                }
                case 2: {
                    if (s[3].equals("undefined")) continue block5;
                    String location = ARCH == 64 ? "64" : "";
                    driver = s[3].replace("%loc%", location);
                    break;
                }
                case 3: {
                    if (s[4].equals("undefined")) continue block5;
                    driver = s[4];
                }
            }
            File f = new File(driver);
            if (!f.exists() || f.isDirectory()) continue;
            Token t = new Token(s[0], s[1], f.getAbsolutePath());
            this.getTokens().add(t);
        }
        scanner.close();
    }

    public int tokensConectados() {
        int aux = 0;
        for (Token t : this.getTokens()) {
            if (!t.isConnected()) continue;
            System.out.println(t.getPkcs11ConfigSettings());
            ++aux;
        }
        return aux;
    }

    public List<Certificado> getCertificados() {
        return this.certificados;
    }

    public Certificado obtenerCertificadoPorAlias(String aliasSeleccionado) {
        for (Certificado c : this.getCertificados()) {
            if (!c.getAlias().equals(aliasSeleccionado)) continue;
            return c;
        }
        return null;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public boolean isMSCAPI() {
        return this.useMSCAPI;
    }

    public void setMSCAPI(boolean useMSCAPI) {
        this.useMSCAPI = useMSCAPI;
    }

    public void setCallback(TokenConectadoCallback clase) {
        this.workerToken.setCallback(clase);
    }

    public void executeWorkerToken() {
        this.workerToken.execute();
    }

    public void finalizarBusquedaTokens() {
        this.workerToken.finalizarBusquedaTokens();
    }

    public Certificado getCertificadoSeleccionado() {
        return this.certificadoSeleccionado;
    }

    public void setCertificadoSeleccionado(Certificado certificadoSeleccionado) {
        this.certificadoSeleccionado = certificadoSeleccionado;
    }
}

