/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.entidades;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashMap;
import kong.unirest.json.JSONException;
import kong.unirest.json.JSONObject;

public class ConfigFirmaPDF {
    public static final int MODO_INVISIBLE = 0;
    public static final int MODO_HOJA_NUEVA = 1;
    public static final int MODO_HOJA_EXISTENTE = 2;
    private static ConfigFirmaPDF instancia;
    private int modoFirmado = 0;
    private String razon;
    private String font = "Helvetica";
    private int fontSize = 0;
    private int marginHor = 4;
    private int marginVer = 2;
    private int hojaAfirmar = 1;
    private int ubicacionFirma = 5;
    private boolean agregarSufijoArchivoFirmado = false;
    private int[] coordenadasDeFirma;

    public int getModoFirmado() {
        return this.modoFirmado;
    }

    public String getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getMarginHor() {
        return this.marginHor;
    }

    public int getMarginVer() {
        return this.marginVer;
    }

    public int getHojaAfirmar() {
        return this.hojaAfirmar;
    }

    public int getUbicacionFirma() {
        return this.ubicacionFirma;
    }

    private ConfigFirmaPDF() {
    }

    public static ConfigFirmaPDF getInstance() {
        if (instancia == null) {
            instancia = new ConfigFirmaPDF();
        }
        return instancia;
    }

    public void setModoFirmado(int modo) {
        this.modoFirmado = modo;
    }

    public void setModoFirmado(String paginaDeFirma) {
        switch (paginaDeFirma) {
            case "signaturesPage": {
                this.modoFirmado = 1;
                break;
            }
            case "last": {
                this.modoFirmado = 2;
                this.hojaAfirmar = -1;
                break;
            }
            case "first": {
                this.modoFirmado = 2;
                this.hojaAfirmar = 1;
                break;
            }
            default: {
                this.modoFirmado = 2;
                this.hojaAfirmar = Integer.parseInt(paginaDeFirma);
            }
        }
    }

    public void setFont(String object) {
        this.font = object;
    }

    public void setFontSize(int value) {
        this.fontSize = value;
    }

    public void setMarginHor(int textMargin) {
        this.marginHor = textMargin;
    }

    public void setMarginVer(int textMargin) {
        this.marginVer = textMargin;
    }

    public void setUbicacionFirma(int selectedIndex) {
        this.ubicacionFirma = selectedIndex;
    }

    public boolean isAgregarSufijoArchivoFirmado() {
        return this.agregarSufijoArchivoFirmado;
    }

    public void setAgregarSufijoArchivoFirmado(boolean agregarSufijoArchivoFirmado) {
        this.agregarSufijoArchivoFirmado = agregarSufijoArchivoFirmado;
    }

    public String asJson() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modoFirmado", this.modoFirmado);
        data.put("font", this.font);
        data.put("marginHor", this.marginHor);
        data.put("marginVer", this.marginVer);
        data.put("hojaAfirmar", this.hojaAfirmar == 1 ? 1 : -1);
        data.put("ubicacionFirma", this.ubicacionFirma);
        data.put("agregarSufijoArchivoFirmado", this.agregarSufijoArchivoFirmado);
        JSONObject json = new JSONObject(data);
        System.out.printf("JSON: %s", json.toString(2));
        return json.toString(2);
    }

    public void loadFromJson(String jsonString) {
        JSONObject json = new JSONObject(jsonString);
        try {
            this.modoFirmado = json.getInt("modoFirmado");
            this.font = json.getString("font");
            this.marginHor = json.getInt("marginHor");
            this.marginVer = json.getInt("marginVer");
            this.hojaAfirmar = json.getInt("hojaAfirmar") == 0 ? 1 : json.getInt("hojaAfirmar");
            this.ubicacionFirma = json.getInt("ubicacionFirma");
            this.agregarSufijoArchivoFirmado = json.getBoolean("agregarSufijoArchivoFirmado");
        }
        catch (JSONException e) {
            return;
        }
    }

    public String getRazon() {
        return this.razon;
    }

    public void setRazon(String razon) {
        this.razon = razon;
    }

    public void setCoordenadas(JsonArray asJsonArray) {
        this.coordenadasDeFirma = (int[])new Gson().fromJson((JsonElement)asJsonArray, int[].class);
    }

    public int[] getCoordenadas() {
        return this.coordenadasDeFirma;
    }
}

