/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.util.encoders.Hex;

public class ConfigProperties {
    private static final int DIAS_A_EXPIRAR = 15;
    private static String directorioPropiedades = String.valueOf(System.getProperty("user.home")) + File.separator + ".lyris";
    private static String configPropertiesName = "config.properties";
    private static String pathConfigProperties = String.valueOf(directorioPropiedades) + File.separator + configPropertiesName;
    private static Properties configProperties;

    public static void crearPropiedadesDeLyrisSiNoExiste() {
        File directorioPropiedadesFile = new File(directorioPropiedades);
        if (!directorioPropiedadesFile.exists()) {
            System.out.println("creating directory: " + directorioPropiedades);
            boolean result = false;
            try {
                directorioPropiedadesFile.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
            if (result) {
                System.out.println("DIR created");
            }
        }
        if (configProperties == null) {
            configProperties = new Properties();
            try {
                FileInputStream is = new FileInputStream(pathConfigProperties);
                configProperties.load(is);
                ((InputStream)is).close();
            }
            catch (FileNotFoundException e) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createDeviceProperties() {
        ConfigProperties.crearPropiedadesDeLyrisSiNoExiste();
        Long now = new Date().getTime();
        String expiration = configProperties.getProperty("properties.expiration");
        if (expiration == null || Long.parseLong(expiration) < now) {
            String timestamp = configProperties.getProperty("device.timestamp", String.valueOf(now));
            expiration = String.valueOf(now + 1296000000L);
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String javaVersion = System.getProperty("java.version");
            String sha256hex = ConfigProperties.generateHash(timestamp, os, arch);
            configProperties.setProperty("device.id", sha256hex);
            configProperties.setProperty("device.os", os);
            configProperties.setProperty("device.arch", arch);
            configProperties.setProperty("device.timestamp", timestamp);
            configProperties.setProperty("device.java", javaVersion);
            configProperties.setProperty("properties.expiration", expiration);
            ConfigProperties.storeToFile(configProperties);
        }
    }

    private static void storeToFile(Properties properties) {
        try {
            FileOutputStream fos = new FileOutputStream(pathConfigProperties);
            properties.store(fos, null);
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String generateHash(String timestamp, String os, String arch) {
        String originalString = String.valueOf(timestamp) + ";" + os + ";" + arch;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] hash = digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        return new String(Hex.encode((byte[])hash));
    }

    public static void actualizarPropiedades(Properties propiedades) {
        ConfigProperties.crearPropiedadesDeLyrisSiNoExiste();
        configProperties.putAll((Map<?, ?>)propiedades);
        ConfigProperties.storeToFile(configProperties);
    }

    public static Properties cargarPropiedades() {
        ConfigProperties.crearPropiedadesDeLyrisSiNoExiste();
        return configProperties;
    }

    public static Properties getPropiedades() {
        return configProperties;
    }

    public static void createImageCopy(String originalPath, String name) {
        Path targetPath = Paths.get(directorioPropiedades, name);
        try {
            FileInputStream in = new FileInputStream(originalPath);
            Files.copy(in, targetPath, new CopyOption[0]);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeImageCopy(String name) {
        File image = Paths.get(directorioPropiedades, name).toFile();
        image.delete();
    }

    public static String getDirectorioPropiedades() {
        return directorioPropiedades;
    }
}

