/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.utils;

import ar.com.lyris.signarStandalone.entidades.footprint.Origin;
import ar.com.lyris.signarStandalone.entidades.footprint.Transaction;
import ar.com.lyris.signarStandalone.utils.ConfigProperties;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;

public final class FootprintUtil {
    protected static String baseUrl = "https://sigtelemetry.signar.com.ar";
    private static CompletableFuture<HttpResponse<JsonNode>> future = null;

    public static void record(Integer signedDocs) {
        Properties props = ConfigProperties.cargarPropiedades();
        String templateId = "standalone_001";
        if (Principal.EJECUTA_ESQUEMA) {
            templateId = EsquemaController.getInstance().getTemplateId();
            if (EsquemaController.ESQUEMA_EN_TEST) {
                templateId = "test_" + templateId;
            }
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        Transaction transaction = new Transaction(templateId, signedDocs, Instant.now().getEpochSecond());
        transactions.add(transaction);
        Origin origin = new Origin(props.getProperty("device.id"), props.getProperty("device.arch"), props.getProperty("device.os"), transactions);
        future = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(String.valueOf(baseUrl) + "/firmas/registrar")).header("Content-Type", "application/json")).header("User-Agent", "SignarStandalone/V2.14.0")).body((Object)origin).asJsonAsync(response -> System.out.println(String.valueOf(response.getStatus()) + " footprint sent"));
    }

    public static void waitForAsyncs() {
        if (future != null) {
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
        }
    }
}

