/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.validador;

import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.ValidarFirmaXML;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.RelativeResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BasicValidation {
    private String pathArchivoOriginal;
    private String pathArchivoFirma;

    public BasicValidation(String pathArchivoOriginal, String pathArchivoFirma) {
        this.pathArchivoOriginal = pathArchivoOriginal;
        this.pathArchivoFirma = pathArchivoFirma;
    }

    public ArrayList<ResultadoValidacion> validate() throws IOException {
        InputStream fichero = null;
        try {
            File archivoFirma = new File(this.pathArchivoFirma);
            if (!archivoFirma.exists()) {
                throw new Exception("Archivo de firma inexistente");
            }
            fichero = new FileInputStream(archivoFirma);
            System.out.println();
            ArrayList results = null;
            Document doc = this.parseaDoc(fichero);
            if (doc == null) {
                System.out.println("Error de validaci\u00f3n. No se pudo parsear la firma.");
            }
            try {
                ValidarFirmaXML vXml = new ValidarFirmaXML();
                File fileIn = new File(this.pathArchivoOriginal);
                if (!fileIn.exists()) {
                    throw new Exception("Archivo original inexistente");
                }
                RelativeResourceResolver resolver = new RelativeResourceResolver(fileIn);
                vXml.addResolver((MITyCResourceResolver)resolver);
                results = vXml.validar(doc, "./", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fichero != null) {
                    fichero.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private Document parseaDoc(InputStream fichero) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            System.out.println("Error interno al parsear la firma");
            ex.printStackTrace();
            return null;
        }
        Document doc = null;
        try {
            Document document = doc = db.parse(fichero);
            return document;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Error interno al validar firma");
            ex.printStackTrace();
        }
        finally {
            dbf = null;
            db = null;
        }
        return null;
    }
}

