/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.vistas;

import ar.com.lyris.signarestandalone.controladores.Principal;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

class ButtonEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    protected JButton button;
    private String label;
    private int isPushed = -1;
    private Principal principal;

    public ButtonEditor(JCheckBox checkBox, Principal principal) {
        super(checkBox);
        this.principal = principal;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = row;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed >= 0) {
            this.principal.removerFila(this.isPushed);
        }
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

