/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.vistas;

import ar.com.lyris.signarStandalone.entidades.ImageConfig;
import ar.com.lyris.signarStandalone.entidades.ImagePosition;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImageConfigPanel
extends JPanel {
    private static final long serialVersionUID = -2032089314178169468L;
    private JCheckBox enableCheck;
    private JTextField imageField;
    private JButton cleanButton;
    private JLabel errorMessage;
    private List<JComponent> subPanelComponents;
    private ImageConfig config;

    public ImageConfigPanel(ImageConfig stored) {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.subPanelComponents = new ArrayList<JComponent>();
        this.config = stored;
        this.add(this.checkBox(stored));
        this.add(Box.createRigidArea(new Dimension(0, 8)));
        this.add(this.subPanel1(stored));
        this.add(this.subPanel2(stored));
        this.enableSubPanelComponents(stored.isEnabled());
    }

    private JCheckBox checkBox(ImageConfig stored) {
        this.enableCheck = new JCheckBox("Adjuntar imagen");
        this.enableCheck.setSelected(stored.isEnabled());
        this.enableCheck.setAlignmentX(0.0f);
        this.enableCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImageConfigPanel.this.config.setEnabled(ImageConfigPanel.this.enableCheck.isSelected());
                ImageConfigPanel.this.enableSubPanelComponents(ImageConfigPanel.this.enableCheck.isSelected());
            }
        });
        return this.enableCheck;
    }

    private JPanel subPanel1(ImageConfig stored) {
        JLabel selectLabel = new JLabel("Seleccionar");
        this.imageField = new JTextField("");
        this.imageField.setEditable(false);
        this.imageField.setText(stored.getName());
        this.imageField.setMaximumSize(new Dimension(165, 25));
        EmptyBorder margin = new EmptyBorder(0, 0, 0, 0);
        this.imageField.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, new Color(128, 128, 128)), margin));
        JButton addButton = new JButton("+");
        addButton.setBorder(new MatteBorder(1, 0, 1, 1, new Color(128, 128, 128)));
        addButton.setFont(new Font("Helvetica", 1, 16));
        addButton.setMaximumSize(new Dimension(20, 25));
        addButton.setMinimumSize(new Dimension(30, 25));
        addButton.setToolTipText("A\u00f1adir imagen");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigPanel.this.selectImageFile();
            }
        });
        this.cleanButton = new JButton("Limpiar");
        this.cleanButton.setBorder(null);
        this.cleanButton.setContentAreaFilled(false);
        this.cleanButton.setForeground(new Color(175, 0, 0));
        this.cleanButton.setVisible(!stored.getName().isEmpty());
        this.cleanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigPanel.this.config.setOriginalPath("");
                ImageConfigPanel.this.config.setName("");
                ImageConfigPanel.this.imageField.setText("");
                ImageConfigPanel.this.cleanButton.setVisible(false);
            }
        });
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 3));
        subPanel.setMaximumSize(new Dimension(421, 45));
        subPanel.setAlignmentX(0.0f);
        JPanel auxiliar = new JPanel();
        auxiliar.setLayout(new BoxLayout(auxiliar, 2));
        auxiliar.setAlignmentX(0.0f);
        auxiliar.add(Box.createRigidArea(new Dimension(4, 0)));
        auxiliar.add(selectLabel);
        auxiliar.add(Box.createRigidArea(new Dimension(8, 0)));
        auxiliar.add(this.imageField);
        auxiliar.add(addButton);
        auxiliar.add(Box.createRigidArea(new Dimension(16, 0)));
        auxiliar.add(this.cleanButton);
        subPanel.add(auxiliar);
        subPanel.add(this.errorLabel());
        this.subPanelComponents.add(selectLabel);
        this.subPanelComponents.add(this.imageField);
        this.subPanelComponents.add(addButton);
        this.subPanelComponents.add(this.cleanButton);
        return subPanel;
    }

    private JLabel errorLabel() {
        this.errorMessage = new JLabel("Debes seleccionar una imagen");
        this.errorMessage.setVisible(false);
        this.errorMessage.setForeground(Color.RED);
        this.errorMessage.setAlignmentX(0.0f);
        EmptyBorder margin = new EmptyBorder(0, 4, 0, 0);
        this.errorMessage.setBorder(new CompoundBorder(this.errorMessage.getBorder(), margin));
        return this.errorMessage;
    }

    private JPanel subPanel2(ImageConfig stored) {
        JLabel positionLabel = new JLabel("Posici\u00f3n relativa a la firma");
        final JComboBox<ImagePosition> positionsCombo = new JComboBox<ImagePosition>(ImagePosition.values());
        positionsCombo.setSelectedItem((Object)stored.getPosition());
        positionsCombo.setMaximumSize(new Dimension(165, 25));
        positionsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigPanel.this.config.setPosition((ImagePosition)((Object)positionsCombo.getSelectedItem()));
            }
        });
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 2));
        subPanel.setMaximumSize(new Dimension(421, 25));
        subPanel.setAlignmentX(0.0f);
        subPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        subPanel.add(positionLabel);
        subPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        subPanel.add(positionsCombo);
        this.subPanelComponents.add(positionLabel);
        this.subPanelComponents.add(positionsCombo);
        return subPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableCheck.setEnabled(enabled);
        this.enableSubPanelComponents(enabled);
    }

    private void enableSubPanelComponents(boolean enabled) {
        this.errorMessage.setVisible(false);
        this.subPanelComponents.stream().forEach(c -> c.setEnabled(enabled && this.enableCheck.isSelected()));
    }

    private void selectImageFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Seleccione una imagen");
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("JPG, JPEG and PNG Images", "jpg", "jpeg", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setMultiSelectionEnabled(false);
        int option = fc.showOpenDialog(this);
        switch (option) {
            case 0: {
                File selectedFile = fc.getSelectedFile();
                if (!selectedFile.exists()) break;
                this.config.setOriginalPath(selectedFile.getAbsolutePath());
                this.config.setName(selectedFile.getName());
                this.imageField.setText(selectedFile.getName());
                this.errorMessage.setVisible(false);
                this.cleanButton.setVisible(true);
                break;
            }
            case -1: {
                String title = "Error grave";
                String message = "Error al seleccionar la imagen. Comun\u00edquese con el administrador.";
                JOptionPane.showMessageDialog(this, message, title, 0);
                Principal.getInstance().finalizar(1);
            }
        }
    }

    public ImageConfig getConfig() {
        return this.config;
    }

    public boolean validateConfig() {
        if (this.imageField.getText().isEmpty()) {
            this.errorMessage.setVisible(true);
            return false;
        }
        return true;
    }
}

