/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.gs.controladores.CertController;
import ar.com.lyris.signarStandalone.entidades.ConfigFirmaPDF;
import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import ar.com.lyris.signarestandalone.controladores.WorkerDescargaCert;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public class ConfigFirmaController {
    public static volatile ConfigFirmaController configFirmaController;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    private WorkerDescargaCert workerDescargaCert;
    private int metodosDeFirma = 0;
    private List<String> certLocation = new ArrayList<String>();
    private boolean excluyenteTokenHard = false;
    private HashMap<String, String> formValues;

    private ConfigFirmaController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigFirmaController getInstance() {
        if (configFirmaController != null) return configFirmaController;
        Class<ConfigFirmaController> clazz = ConfigFirmaController.class;
        synchronized (ConfigFirmaController.class) {
            if (configFirmaController != null) return configFirmaController;
            configFirmaController = new ConfigFirmaController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configFirmaController;
        }
    }

    public ConfigFirmaPDF getConfigFirma() {
        return ConfigFirmaPDF.getInstance();
    }

    public void procesarFirmaPDF(JsonObject jsonObject) {
        if (jsonObject.get("reason") != null) {
            String razon = this.procesarRazon(jsonObject.get("reason").getAsString());
            ConfigFirmaPDF.getInstance().setRazon(razon);
        }
        if (jsonObject.get("VisibilityConfig") != null) {
            this.procesarVisibilidad(jsonObject.get("VisibilityConfig").getAsJsonObject());
        }
    }

    private String procesarRazon(String razon) {
        if (razon.contains("{$Date}")) {
            LocalDateTime localDateTime = LocalDateTime.now();
            String date = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).format(localDateTime);
            System.out.println(date);
            razon = razon.replace("{$Date}", date);
        }
        if (EsquemaController.PatronVarAmpersand.matcher(razon = this.esquemaController.parseParameters(razon)).find()) {
            this.esquemaController.agregarDerivable("reason", razon);
        }
        return razon;
    }

    private void procesarVisibilidad(JsonObject visibilityConfig) {
        block30: {
            String value;
            String paginaDeFirma = this.esquemaController.parseParameters(visibilityConfig.get("signaturePage").getAsString());
            if (paginaDeFirma.equals("custom")) {
                paginaDeFirma = this.esquemaController.parseParameters(visibilityConfig.get("customPageNumber").getAsString());
            }
            ConfigFirmaPDF.getInstance().setModoFirmado(paginaDeFirma);
            if (visibilityConfig.get("coordinates") != null) {
                if (visibilityConfig.get("coordinates").isJsonPrimitive()) {
                    String coordinates = visibilityConfig.get("coordinates").getAsString();
                    if (EsquemaController.PatronVarAmpersand.matcher(coordinates).find()) {
                        this.esquemaController.agregarDerivable("coordinates", coordinates);
                    } else {
                        String coordinatesArray = this.esquemaController.parseParameters(coordinates);
                        String[] stringArray = coordinatesArray.split(",");
                        int[] intArray = Stream.of(stringArray).mapToInt(Integer::parseInt).toArray();
                        JsonElement jsonTree = new Gson().toJsonTree((Object)intArray);
                        ConfigFirmaPDF.getInstance().setCoordenadas(jsonTree.getAsJsonArray());
                    }
                } else {
                    ConfigFirmaPDF.getInstance().setCoordenadas(visibilityConfig.get("coordinates").getAsJsonArray());
                }
            }
            if (visibilityConfig.get("fontSize") != null) {
                int fontSize = visibilityConfig.get("fontSize").getAsInt();
                ConfigFirmaPDF.getInstance().setFontSize(fontSize);
            }
            if (visibilityConfig.get("font") != null) {
                String font = visibilityConfig.get("font").getAsString();
                ConfigFirmaPDF.getInstance().setFont(font);
            }
            if (visibilityConfig.get("signatureLocation") == null) break block30;
            String signatureLocation = visibilityConfig.get("signatureLocation").getAsString();
            switch (value = this.esquemaController.parseParameters(signatureLocation)) {
                case "upper-left": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(0);
                    break;
                }
                case "upper-center": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(1);
                    break;
                }
                case "upper-right": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(2);
                    break;
                }
                case "lower-left": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(3);
                    break;
                }
                case "lower-center": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(4);
                    break;
                }
                case "lower-right": {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(5);
                    break;
                }
                default: {
                    ConfigFirmaPDF.getInstance().setUbicacionFirma(5);
                }
            }
        }
    }

    public void configurarPathCertificado(String uri) {
        ++this.metodosDeFirma;
        this.certLocation.add(Consola.OPCIONES_UBIC_CERT[3]);
        this.workerDescargaCert = WorkerDescargaCert.getInstance();
        this.workerDescargaCert.setURL(uri);
        this.workerDescargaCert.execute();
    }

    public int getMetodosDeFirma() {
        return this.metodosDeFirma;
    }

    public void agregarCertLocation(String string) {
        this.certLocation.add(string);
    }

    public String getAlmacenSeleccionado() {
        return (String)Consola.getInstance().getAlmacenSeleccionado();
    }

    public String getRutaCertNube() {
        return this.workerDescargaCert.getRutaCertNube();
    }

    public List<String> getCertLocation() {
        return this.certLocation;
    }

    public String replaceReservedWords(String razon, String subjectDN) {
        if (razon.contains("{$SIGNER}")) {
            razon = razon.replace("{$SIGNER}", subjectDN);
        }
        if (razon.contains("{$DATE}")) {
            SimpleDateFormat formateador = new SimpleDateFormat("dd 'de' MMMM 'de' yyyy", new Locale("ES"));
            String fecha = formateador.format(new Date());
            razon = razon.replace("{$DATE}", fecha);
        }
        return razon;
    }

    public void configurarMSCAPI() {
        CertController.getInstance();
        if (CertController.SO == 1) {
            ++this.metodosDeFirma;
            this.certLocation.add(Consola.OPCIONES_UBIC_CERT[2]);
        }
    }

    public void habilitarCertificadoLocal() {
        ++this.metodosDeFirma;
        this.certLocation.add(Consola.OPCIONES_UBIC_CERT[1]);
    }

    public void agregarTokenHWUbicdeCert() {
        ++this.metodosDeFirma;
        this.certLocation.add(Consola.OPCIONES_UBIC_CERT[0]);
        Consola.getInstance().agregarTokenHWUbicdeCert();
    }

    public void habilitarCertificadoDescargado(boolean descargadoOK) {
        if (descargadoOK) {
            Consola.getInstance().setAlmacenSeleccionado(Consola.OPCIONES_UBIC_CERT[3]);
        } else if (this.certLocation.size() == 1) {
            String message = "Hubo un problema con la descarga de certificado, consulte con el administrador";
            Principal.getInstance().informarProblemaIrrecuperable(message, "Error de red");
        } else {
            this.certLocation.remove(Consola.OPCIONES_UBIC_CERT[3]);
            Consola.getInstance().quitarDeAlmacenes(Consola.OPCIONES_UBIC_CERT[3]);
        }
    }

    public void setExcluyenteTokenHard() {
        CertController.getInstance().esExcluyenteTokenHard();
        this.excluyenteTokenHard = true;
    }

    public boolean esExcluyenteTokenHard() {
        return this.excluyenteTokenHard;
    }

    public void setFormValues(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().contains("$")) {
            jsonElement = this.esquemaController.parseToJsonObjectParameters(jsonElement.getAsString());
        }
        this.formValues = JSONUtils.asHashMap(jsonElement.getAsJsonObject());
    }

    public HashMap<String, String> getFormValues() {
        return this.formValues;
    }
}

