/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.WorkerSubida;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class DestinationsController {
    public static final int DESTINO_SUBIDA = 0;
    public static volatile DestinationsController destinationsController;
    private WorkerSubida workerSubida;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    public final int metodoEjecucion = 0;

    private DestinationsController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DestinationsController getInstance() {
        if (destinationsController != null) return destinationsController;
        Class<DestinationsController> clazz = DestinationsController.class;
        synchronized (DestinationsController.class) {
            if (destinationsController != null) return destinationsController;
            destinationsController = new DestinationsController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return destinationsController;
        }
    }

    public void procesarDestinos(JsonObject jsonData) {
        String fileField;
        JsonObject remote;
        if (jsonData.getAsJsonObject("remote") != null) {
            this.workerSubida = WorkerSubida.getInstance();
            remote = jsonData.getAsJsonObject("remote");
            this.workerSubida.setURL(this.esquemaController.parseParameters(remote.get("URI").getAsString()));
            this.workerSubida.setMethod(remote.get("method").getAsString());
            fileField = remote.get("fileField").getAsString();
            fileField = this.esquemaController.parseParameters(fileField);
            this.workerSubida.setFileField(fileField);
            if (remote.get("keepName") != null) {
                boolean keepName = remote.get("keepName").getAsBoolean();
                this.workerSubida.setKeepName(keepName);
            }
            this.parseFormFields(remote.get("formFields").getAsJsonObject());
            HashMap<String, String> destinationHeaders = JSONUtils.asHashMap(remote.getAsJsonObject("headers"));
            if (destinationHeaders != null) {
                this.computarHeaders(destinationHeaders);
            }
        }
        if (jsonData.getAsJsonObject("signatureFootprint") != null) {
            remote = jsonData.getAsJsonObject("signatureFootprint");
            this.workerSubida = WorkerSubida.getInstance();
            fileField = remote.get("URI").getAsString();
            String string = this.esquemaController.parseParameters(fileField);
        }
    }

    private void parseFormFields(JsonObject jsonElement) {
        HashMap<String, String> fields = JSONUtils.asHashMap(jsonElement);
        HashMap auxFields = (HashMap)fields.clone();
        fields.forEach((key, value) -> {
            String valAux = value;
            valAux = this.esquemaController.parseParameters(valAux);
            if (value.contains("{$FILE_ID}")) {
                this.workerSubida.setFormFieldWithFileID((String)key, valAux);
                auxFields.remove(key);
            }
            if (value.contains("{$SIGNER}")) {
                this.workerSubida.setFormFieldWithSigner((String)key, valAux);
                auxFields.remove(key);
            }
            if (value.contains("{$SELECTED_OPTION}")) {
                this.workerSubida.setFormFieldWithSelectedOption((String)key, valAux);
                auxFields.remove(key);
            }
            if (value.contains("{$FILE_NAME}")) {
                this.workerSubida.setFormFieldWithFileName((String)key, valAux);
                auxFields.remove(key);
            }
            if (EsquemaController.PatronVarAmpersand.matcher((CharSequence)value).find()) {
                this.esquemaController.agregarDerivable("formField&" + key, (String)value);
                auxFields.remove(key);
            } else {
                auxFields.put(key, valAux);
            }
        });
        this.workerSubida.setFormFields(auxFields);
    }

    void computarHeaders(HashMap<String, String> destinationheaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.esquemaController.getDefaultHeaders());
        destinationheaders.forEach((key, value) -> {
            String newValue = this.esquemaController.parseParameters((String)value);
            headers.put((String)key, newValue);
        });
        this.workerSubida.setHeaders(headers);
    }

    public void iniciarSubida() {
        this.workerSubida.execute();
    }
}

