/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.gs.controladores.CertController;
import ar.com.gs.controladores.TokenConectadoCallback;
import ar.com.gs.entidades.Token;
import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoApp;
import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarStandalone.utils.ConfigProperties;
import ar.com.lyris.signarStandalone.utils.FootprintUtil;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarStandalone.vistas.DialogCertificados;
import ar.com.lyris.signarStandalone.vistas.ProgressWorker;
import ar.com.lyris.signarestandalone.controladores.ConfigFirmaController;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.WorkerFirmado;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import kong.unirest.Unirest;

public class Principal
implements TokenConectadoCallback {
    private static volatile Principal principal;
    protected Consola frame;
    public EstadoApp estadoApp;
    public boolean banderaFin;
    private List<Documento> documentosInvalidos;
    private List<Documento> documentos;
    private ProgressWorker progressWorker;
    private CertController certController;
    private String carpetaBase;
    private WorkerFirmado workerFirmado;
    private EsquemaController esquemaController;
    public static boolean EJECUTA_ESQUEMA;
    HashMap<String, String> defaultHeaders;

    private Principal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Principal getInstance() {
        if (principal != null) return principal;
        Class<Principal> clazz = Principal.class;
        synchronized (Principal.class) {
            if (principal != null) return principal;
            principal = new Principal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return principal;
        }
    }

    public void iniciar(String[] args) {
        this.progressWorker = ProgressWorker.getInstance();
        this.inicializarVariables();
        this.cargarArgumentos(args);
        this.invocarConsola();
        this.certController = CertController.getInstance();
        this.certController.setCallback(this);
        this.certController.executeWorkerToken();
        if (EJECUTA_ESQUEMA) {
            try {
                this.esquemaController.inicializar();
            }
            catch (Exception e) {
                e.printStackTrace();
                String mensaje = "Ocurri\u00f3 un problema al cargar los argumentos, contactese con el administrador";
                this.informarProblemaIrrecuperable(mensaje, "Problema irrecuperable");
            }
        }
    }

    public void cargarArgumentos(String[] args) {
        System.out.println(args.length);
        if (args.length == 1) {
            String decoded = new String(Base64.getDecoder().decode(args[0]));
            System.out.println(decoded);
            args = decoded.split(";", 2);
        }
        if (args.length == 2) {
            EJECUTA_ESQUEMA = true;
            this.esquemaController = EsquemaController.getInstance();
            try {
                this.esquemaController.setUrlEsquema(args[0]);
                this.esquemaController.setParameters(args[1]);
            }
            catch (MalformedURLException | URISyntaxException e) {
                principal.informarProblemaIrrecuperable("URL Schema mal formada", "Error Irrecuperable");
                e.printStackTrace();
            }
            catch (Exception e) {
                principal.informarProblemaIrrecuperable(e.getMessage(), "Error Irrecuperable");
                e.printStackTrace();
            }
        } else {
            EJECUTA_ESQUEMA = false;
        }
    }

    public int getDocsProcesados() {
        return this.getCantDocEnEstados(this.estadoApp.getEstadoPrevio(), this.estadoApp.getEstadoCompleto());
    }

    private void invocarConsola() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Principal.this.frame = Consola.getInstance();
                Principal.this.frame.setVisible(true);
                Principal.this.progressWorker.setPBar();
                Principal.this.progressWorker.execute();
                if (!EJECUTA_ESQUEMA) {
                    Principal.this.cargarPropiedades();
                }
            }
        });
    }

    void guardarPropiedades() throws IOException {
        System.out.println(this.getFrame().carpetaDestino);
        if (this.getFrame().carpetaDestino != null || this.getDocumentos().size() > 0) {
            Properties propiedades = new Properties();
            propiedades.setProperty("firmadorStandalone.carpetaDestino", this.getFrame().carpetaDestino.getAbsolutePath());
            propiedades.setProperty("firmadorStandalone.carpetaBase", this.getDocumentos().get(0).getFilePath());
            ConfigProperties.actualizarPropiedades(propiedades);
        }
    }

    private void inicializarVariables() {
        this.configUnirest();
        ConfigProperties.createDeviceProperties();
        this.estadoApp = EstadoApp.INICIADA;
        this.banderaFin = false;
        this.documentosInvalidos = new ArrayList<Documento>();
        this.documentos = new ArrayList<Documento>();
    }

    public Consola getFrame() {
        return this.frame;
    }

    public void finalizar(int status) {
        FootprintUtil.waitForAsyncs();
        System.exit(status);
    }

    private void cargarPropiedades() {
        String rutaCarpetaDestino;
        Properties propiedades = ConfigProperties.cargarPropiedades();
        String propiedadesPDF = (String)propiedades.get("firmadorStandalone.pdfConfig");
        if (propiedadesPDF != null) {
            ConfigFirmaController.getInstance().getConfigFirma().loadFromJson(propiedadesPDF);
        }
        if ((rutaCarpetaDestino = propiedades.getProperty("firmadorStandalone.carpetaDestino", null)) != null) {
            this.getFrame().setCarpetaDestino(new File(rutaCarpetaDestino));
        }
        this.carpetaBase = propiedades.getProperty("firmadorStandalone.carpetaBase", null);
    }

    public void firmar() {
        this.estadoApp = EstadoApp.FIRMANDO;
        this.certController.finalizarBusquedaTokens();
        if (EJECUTA_ESQUEMA && EsquemaController.ESQUEMA_EN_TEST) {
            try {
                InputStream is = this.getClass().getResourceAsStream("/firma/FOR_TESTING.p12");
                File file = File.createTempFile("testing", ".p12");
                file.deleteOnExit();
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                String cert = file.getAbsolutePath();
                this.certController.initKeystore("SW", "Demo1248".toCharArray(), cert);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.certController.setCertificadoSeleccionado(this.certController.getCertificados().get(0));
        } else if (EJECUTA_ESQUEMA) {
            ConfigFirmaController configFirmaController = ConfigFirmaController.getInstance();
            if (ConfigFirmaController.getInstance().esExcluyenteTokenHard() || configFirmaController.getAlmacenSeleccionado().equals(Consola.OPCIONES_UBIC_CERT[0])) {
                try {
                    this.certController.initKeystore("HW", this.getFrame().getPassword(), this.getProviderDeTokenSeleccionado());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error grave", 0);
                    this.estadoApp = EstadoApp.EN_ESPERA;
                    this.frame.habilitarFirmado();
                    e1.printStackTrace();
                    return;
                }
            } else if (configFirmaController.getAlmacenSeleccionado().equals(Consola.OPCIONES_UBIC_CERT[3])) {
                try {
                    this.certController.initKeystore("SW", this.frame.getPassword(), configFirmaController.getRutaCertNube());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error grave", 0);
                    this.estadoApp = EstadoApp.EN_ESPERA;
                    this.frame.habilitarFirmado();
                    e1.printStackTrace();
                    return;
                }
            } else if (configFirmaController.getAlmacenSeleccionado().equals(Consola.OPCIONES_UBIC_CERT[2])) {
                try {
                    this.certController.setMSCAPI(true);
                    this.certController.initKeystore("SW", this.frame.getPassword(), "");
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error grave", 0);
                    this.estadoApp = EstadoApp.EN_ESPERA;
                    this.frame.habilitarFirmado();
                    e1.printStackTrace();
                    return;
                }
            } else if (configFirmaController.getAlmacenSeleccionado().equals(Consola.OPCIONES_UBIC_CERT[1])) {
                try {
                    String path = Consola.getInstance().getPathTokenSoftware();
                    this.certController.initKeystore("SW", this.frame.getPasswordFileCert(), path);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error grave", 0);
                    this.estadoApp = EstadoApp.EN_ESPERA;
                    this.frame.habilitarFirmado();
                    e1.printStackTrace();
                    return;
                }
            }
        } else {
            try {
                this.certController.initKeystore("HW", this.getFrame().getPassword(), this.getProviderDeTokenSeleccionado());
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error grave", 0);
                this.estadoApp = EstadoApp.EN_ESPERA;
                this.frame.habilitarFirmado();
                e1.printStackTrace();
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DialogCertificados().setVisible(true);
            }
        });
    }

    public String getProviderDeTokenSeleccionado() {
        for (Token t : this.certController.getTokens()) {
            if (!t.isConnected()) continue;
            return t.getProvider().getName();
        }
        return null;
    }

    public void certificadoSeleccionado() {
        this.workerFirmado = WorkerFirmado.getInstance();
        this.workerFirmado.execute();
    }

    public void etapaFinal() {
        this.getFrame().finalizacion("correctamente");
        if (!EJECUTA_ESQUEMA) {
            String mensaje = "Proceso de firma finalizado. \u00bfAbrir la carpeta destino?";
            Object[] buttons = new String[]{"Si", "No"};
            int returnValue = JOptionPane.showOptionDialog(this.getFrame(), mensaje, "Finalizado Correctamente", 0, 1, null, buttons, buttons[0]);
            if (returnValue == 0) {
                try {
                    Desktop.getDesktop().open(this.getFrame().carpetaDestino);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.guardarPropiedades();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            int finalizados = 0;
            boolean exito = true;
            try {
                for (Documento doc : this.getDocumentos()) {
                    System.out.println(String.valueOf(doc.getFileName()) + " " + (Object)((Object)doc.getEstado()));
                    if (!doc.getEstado().equals((Object)EstadoDoc.SUBIDO)) continue;
                    ++finalizados;
                }
                System.out.println("subidos: " + finalizados);
                if (finalizados == 0) {
                    this.getFrame().informarFallo("Fall\u00f3 la carga de los documentos firmados, consulte con su administrador.");
                    this.finalizar(1);
                }
                FootprintUtil.record(finalizados);
                if (this.documentosInvalidos.size() > 0) {
                    exito = false;
                    String mensajeDocsInvalidos = "Los siguientes archivos no pudieron ser subidos luego de ser firmados:\n";
                    for (Documento doc : this.documentosInvalidos) {
                        mensajeDocsInvalidos = String.valueOf(mensajeDocsInvalidos) + doc.getFileName();
                    }
                    this.getFrame().informarFallo(mensajeDocsInvalidos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("mensaje " + e.getMessage());
                JOptionPane.showMessageDialog(this.getFrame(), e.getMessage(), "Error", 0);
                return;
            }
            String mensaje = "Proceso de firma finalizado";
            String titulo = "Finalizado " + (exito ? "correctamente" : "con errores");
            JOptionPane.showMessageDialog(this.getFrame(), mensaje, titulo, 1);
        }
        this.finalizar(1);
    }

    public void informarProblema(String desc, String titulo) {
        Object[] buttons = new String[]{"Si", "No"};
        int returnValue = JOptionPane.showOptionDialog(this.getFrame(), desc, titulo, 2, 0, null, buttons, buttons[0]);
        if (returnValue > 0) {
            this.finalizar(1);
        }
    }

    public List<Documento> getDocumentos() {
        return this.documentos;
    }

    public void AgregarDocumentos() {
        Consola.getInstance().cargarTabla();
        this.getFrame().labelProgreso.setText("Documentos seleccionados");
        JFileChooser fc = null;
        try {
            if (!Principal.isLinux()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            fc = new JFileChooser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.carpetaBase != null) {
            fc.setCurrentDirectory(new File(this.carpetaBase));
        }
        fc.setFileSelectionMode(2);
        fc.setFileFilter(new FileNameExtensionFilter("PDF Documents", "pdf"));
        fc.setDialogTitle("Seleccione uno o mas documentos");
        fc.setMultiSelectionEnabled(true);
        int seleccion = fc.showOpenDialog(this.getFrame().getContentPane());
        if (seleccion == -1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Ocurrio un error, comuniquese con el administrador", "Error Grave", 0);
            this.finalizar(1);
        }
        if (seleccion == 0) {
            System.out.println("filechooser correcto");
            File f = new File(fc.getSelectedFile().getAbsolutePath());
            if (f.exists()) {
                if (fc.getSelectedFile().isDirectory()) {
                    File[] ficheros = f.listFiles();
                    int x = 0;
                    while (x < ficheros.length) {
                        this.crearDocumento(ficheros[x]);
                        ++x;
                    }
                } else {
                    File[] files = fc.getSelectedFiles();
                    int x = 0;
                    while (x < files.length) {
                        this.crearDocumento(files[x]);
                        ++x;
                    }
                }
            }
        }
        if (!this.documentos.isEmpty()) {
            this.getFrame().refrescarTabla();
            this.setEstadoApp(EstadoApp.EN_ESPERA);
            this.getFrame().habilitarFirmado();
        }
    }

    public String seleccionarArchivoOriginal(String tipo, JDialog thisFrame) {
        JFileChooser fc = new JFileChooser();
        if (this.carpetaBase != null) {
            fc.setCurrentDirectory(new File(this.carpetaBase));
        }
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Seleccione el " + tipo + " a validar");
        fc.setMultiSelectionEnabled(false);
        int seleccion = fc.showOpenDialog(thisFrame);
        if (seleccion == -1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Ocurrio un error, comuniquese con el administrador", "Error Grave", 0);
            this.finalizar(1);
        }
        if (seleccion == 0) {
            System.out.println("filechooser correcto");
            File f = new File(fc.getSelectedFile().getAbsolutePath());
            if (f.exists()) {
                return f.getAbsolutePath();
            }
        }
        return null;
    }

    public void elegirCarpetaDestino() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Seleccione destino de documentos firmados");
        int seleccion = fc.showOpenDialog(this.getFrame().getContentPane());
        if (seleccion == -1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Ocurrio un error, comuniquese con el administrador", "Error Grave", 0);
            this.finalizar(1);
        }
        if (seleccion == 0) {
            System.out.println("filechooser destino correcto");
            File f = new File(fc.getSelectedFile().getAbsolutePath());
            if (f.exists() && fc.getSelectedFile().isDirectory()) {
                this.getFrame().setCarpetaDestino(f);
            }
        }
    }

    private void crearDocumento(File file) {
        if (this.yaExisteDocumento(file.getName())) {
            JOptionPane.showMessageDialog(this.getFrame(), "Ya se encuentra un archivo de nombre " + file.getName() + " en la lista de archivos a firmar.", "Error grave", 0);
            return;
        }
        Documento docTemp = new Documento();
        docTemp.setNombreVisible(file.getName());
        docTemp.setArchivo(file);
        docTemp.setId(String.valueOf(this.getDocumentos().size()));
        docTemp.setEstado(EstadoDoc.CARGADO);
        this.getDocumentos().add(docTemp);
    }

    private boolean yaExisteDocumento(String name) {
        for (Documento d : this.documentos) {
            if (!d.getFileName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getCantDocumentos() {
        return this.documentos.size();
    }

    public int getCantDocEnEstados(EstadoDoc estado, EstadoDoc estado2) {
        int bandera = 0;
        for (Documento doc : this.documentos) {
            if (!doc.getEstado().equals((Object)estado) && !doc.getEstado().equals((Object)estado2)) continue;
            ++bandera;
        }
        return bandera;
    }

    public void documentoInvalido(Documento doc) {
        doc.setEstado(EstadoDoc.INVALIDO);
        ArrayList<Documento> docsAux = new ArrayList<Documento>();
        for (Documento documento : this.documentos) {
            if (documento.getId() == doc.getId()) continue;
            docsAux.add(documento);
        }
        this.documentos = docsAux;
        this.documentosInvalidos.add(doc);
        this.getFrame().refrescarIdTabla(doc.getId());
    }

    public void removerFila(int isPushed) {
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(isPushed);
        this.getFrame().removerFila(isPushed);
    }

    @Override
    public void informarProblemaIrrecuperable(String desc, String titulo) {
        JOptionPane.showMessageDialog(this.getFrame(), desc, titulo, 0);
        this.finalizar(1);
    }

    @Override
    public void tokenConectado() {
        this.getFrame().nuevoTokenConectado();
    }

    public int getCantDocEnEstados(EstadoDoc estado) {
        return this.getCantDocEnEstados(estado, estado);
    }

    void finFirmado() {
        int finalizados = 0;
        try {
            this.workerFirmado.get();
            for (Documento doc : this.getDocumentos()) {
                System.out.println(String.valueOf(doc.getFileName()) + " " + (Object)((Object)doc.getEstado()));
                if (!doc.getEstado().equals((Object)EstadoDoc.FIRMADO)) continue;
                ++finalizados;
            }
            System.out.println("finalizados: " + finalizados);
            if (finalizados != this.documentos.size()) {
                this.getFrame().informarFallo("Fallo el firmado de uno o mas documentos");
            }
            if (this.documentosInvalidos.size() > 0) {
                String mensajeDocsInvalidos = "Los siguientes archivos fueron quitados de la lista al no poder ser firmados:\n";
                for (Documento doc : this.documentosInvalidos) {
                    mensajeDocsInvalidos = String.valueOf(mensajeDocsInvalidos) + doc.getFileName();
                }
                this.getFrame().informarFallo(mensajeDocsInvalidos);
            }
            if (finalizados == 0) {
                this.getFrame().informarFallo("No quedan documentos para firmar, compruebe el error y/o reintente mas tarde.");
                this.finalizar(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("mensaje " + e.getMessage());
            JOptionPane.showMessageDialog(this.getFrame(), e.getMessage(), "Error", 0);
            return;
        }
        if (EJECUTA_ESQUEMA) {
            this.esquemaController.finFirmado();
        } else {
            if (finalizados > 0) {
                FootprintUtil.record(finalizados);
            }
            this.etapaFinal();
        }
    }

    public void setEstadoApp(EstadoApp estado) {
        this.estadoApp = estado;
    }

    public boolean estadoApp(EstadoApp estadoVariable) {
        return this.estadoApp == estadoVariable;
    }

    public void habilitarFirmado() {
        this.estadoApp = EstadoApp.EN_ESPERA;
        this.frame.habilitarFirmado();
    }

    public static boolean isLinux() {
        CertController.getInstance();
        return CertController.SO == 2;
    }

    private void configUnirest() {
        Unirest.config().followRedirects(false).enableCookieManagement(false);
        this.defaultHeaders = new HashMap();
        this.defaultHeaders.put("User-Agent", "SignarStandaloneV2.14.0");
    }
}

