/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoApp;
import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingWorker;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class WorkerDescarga
extends SwingWorker<Boolean, String> {
    public static volatile WorkerDescarga workerDescarga;
    private String url;
    private HashMap<String, String> headers;
    private Consola consola;

    private WorkerDescarga() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerDescarga getInstance() {
        if (workerDescarga != null) return workerDescarga;
        Class<WorkerDescarga> clazz = WorkerDescarga.class;
        synchronized (WorkerDescarga.class) {
            if (workerDescarga != null) return workerDescarga;
            workerDescarga = new WorkerDescarga();
            // ** MonitorExit[var0] (shouldn't be in output)
            return workerDescarga;
        }
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        this.consola = Consola.getInstance();
        List<Documento> documentos = Principal.getInstance().getDocumentos();
        boolean urlContainsFILE_IDflag = this.url.contains("{$FILE_ID}");
        for (Documento doc : documentos) {
            doc.setEstado(EstadoDoc.DESCARGANDO);
            this.publish(new String[0]);
            String requestURL = urlContainsFILE_IDflag ? this.url.replace("{$FILE_ID}", doc.getId()) : this.url;
            GetRequest request = (GetRequest)Unirest.get((String)requestURL).headers(this.headers);
            System.out.println("preparing 'GET' request to URL : " + request.getUrl());
            HttpResponse response = request.asBytes();
            System.out.println(response.getStatus());
            if (response.getStatus() == 200) {
                doc.setArchivo(this.persistTempFile((HttpResponse<byte[]>)response, doc));
                doc.setEstado(EstadoDoc.CARGADO);
                this.publish(new String[0]);
                System.out.println(doc.getFilePath());
                continue;
            }
            if (response.getStatus() == 401) {
                doc.setEstado(EstadoDoc.INVALIDO);
                this.publish(doc.getId());
                System.out.println(String.valueOf(doc.getId()) + " no existe");
                continue;
            }
            doc.setEstado(EstadoDoc.INVALIDO);
            this.publish(doc.getId());
            System.out.println(String.valueOf(doc.getId()) + " no pudo ser descargado");
        }
        return null;
    }

    private File persistTempFile(HttpResponse<byte[]> response, Documento doc) throws IOException {
        String inputLine;
        String preFileName = doc.getRemotePath();
        if (preFileName == null) {
            preFileName = doc.getId();
        }
        System.out.println("Content disposition recibido:");
        String cd = response.getHeaders().getFirst("Content-Disposition");
        System.out.println(cd);
        preFileName = preFileName.endsWith(".pdf") ? preFileName.substring(0, preFileName.length() - 4) : preFileName;
        String[] splittedFilename = new String[]{preFileName, "pdf"};
        if (cd != null && !cd.isEmpty()) {
            String fileName = cd.replaceFirst("(?i)^.*filename=\"?([^\"]+)\"?.*$", "$1");
            splittedFilename = fileName.split("\\.(?=[^\\.]+$)");
        }
        File temp = File.createTempFile(String.valueOf(splittedFilename[0]) + "__", "." + splittedFilename[1]);
        ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream((byte[])response.getBody()));
        System.out.println(temp.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(temp);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])response.getBody())));
        StringBuffer responseFile = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            responseFile.append(inputLine);
        }
        in.close();
        temp.deleteOnExit();
        doc.setNombreVisible(String.valueOf(splittedFilename[0]) + "." + splittedFilename[1]);
        return temp;
    }

    public void setURL(String urlString) {
        this.url = urlString;
    }

    public void setMethod(String asString) {
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    @Override
    protected void done() {
        Principal.getInstance().setEstadoApp(EstadoApp.EN_ESPERA);
        this.consola.habilitarFirmado();
    }

    @Override
    protected void process(List<String> chunks) {
        this.consola.refrescarTabla();
    }
}

