/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mscapi;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.keystore.KeyTool;
import es.mityc.javasign.utils.CopyFilesTool;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSCAPIStore
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(MSCAPIStore.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String MY_STORE = "Windows-MY";
    private static final String ROOT_STORE = "Windows-ROOT";
    private static final String CA_STORE = "Windows-CA";
    private static final String LOCAL_MACHINE_MY_STORE = "Windows-LocalMachine-MY";
    private static final String LOCAL_MACHINE_ROOT_STORE = "Windows-LocalMachine-ROOT";
    private static final String LOCAL_MACHINE_CA_STORE = "Windows-LocalMachine-CA";
    private static final String SUN_MSCAPI_PROVIDER = "SunMSCAPI";
    private static final String SUN_MSCAPI_MITYC_KEY_STORE_CLASS = "es.mityc.javasign.pkstore.mscapi.mityc.KeyStore";
    private static final String SUN_MSCAPI_MITYC_PROVIDER_CLASS = "es.mityc.javasign.pkstore.mscapi.mityc.SunMSCAPI_MITyC";
    private static boolean initialized = false;
    private IPassStoreKS passHandler;
    private Provider provider;
    private LocationStoreType locationStore;
    private boolean usingSunMSCAPIMITyC;

    private synchronized void copyLibrary() throws CopyFileException {
        if (!initialized) {
            CopyFilesTool cft = new CopyFilesTool("libs/sunmscapimityc/MITyCLibCertJNI_sunmscapimityc.properties", this.getClass().getClassLoader());
            cft.copyFilesOS(null, "explorer", true);
            initialized = true;
        }
    }

    public MSCAPIStore(IPassStoreKS passStoreHandler) throws CertStoreException {
        this(passStoreHandler, LocationStoreType.CurrentUser);
    }

    public MSCAPIStore(IPassStoreKS passStoreHandler, LocationStoreType location) throws CertStoreException {
        block5: {
            this.usingSunMSCAPIMITyC = false;
            this.locationStore = location;
            try {
                Class.forName(SUN_MSCAPI_MITYC_KEY_STORE_CLASS);
                this.copyLibrary();
                Class<?> sunMscapiMITyCProviderClass = Class.forName(SUN_MSCAPI_MITYC_PROVIDER_CLASS);
                Constructor<?> constructor = sunMscapiMITyCProviderClass.getConstructor(new Class[0]);
                this.provider = (Provider)constructor.newInstance(new Object[0]);
                LOG.info((Object)I18N.getLocalMessage("i18n.mityc.cert.mscapi.9"));
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)I18N.getLocalMessage("i18n.mityc.cert.mscapi.8", new Object[]{ex.getMessage()}));
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)"", (Throwable)ex);
            }
        }
        if (this.provider == null) {
            this.provider = Security.getProvider(SUN_MSCAPI_PROVIDER);
            if (this.provider == null) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.7"));
            }
            LOG.info((Object)I18N.getLocalMessage("i18n.mityc.cert.mscapi.10"));
        } else {
            this.usingSunMSCAPIMITyC = true;
        }
        this.passHandler = passStoreHandler == null ? new NullPassStorePK() : passStoreHandler;
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = MY_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_MY_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, this.provider);
            ks.load(null, null);
            PrivateKey resultado = KeyTool.findPrivateKey(ks, certificate, this.passHandler);
            return resultado;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", new Object[]{ex.getMessage(), ex}));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", new Object[]{ex.getMessage(), ex}));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", new Object[]{ex.getMessage(), ex}));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", new Object[]{ex.getMessage(), ex}));
        }
    }

    public Provider getProvider(X509Certificate certificate) {
        return this.provider;
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = MY_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_MY_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, this.provider);
            ks.load(null, null);
            return KeyTool.getCertificatesWithKeys(ks);
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", new Object[]{ex.getMessage(), ex}));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", new Object[]{ex.getMessage(), ex}));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", new Object[]{ex.getMessage(), ex}));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", new Object[]{ex.getMessage(), ex}));
        }
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        try {
            String storeName = null;
            switch (this.locationStore) {
                case CurrentUser: {
                    storeName = ROOT_STORE;
                    break;
                }
                case LocalMachine: {
                    storeName = LOCAL_MACHINE_ROOT_STORE;
                }
            }
            KeyStore ks = KeyStore.getInstance(storeName, this.provider);
            ks.load(null, null);
            ArrayList<X509Certificate> lista = new ArrayList<X509Certificate>();
            lista.addAll(KeyTool.getTrustCertificates(ks));
            if (this.usingSunMSCAPIMITyC) {
                switch (this.locationStore) {
                    case CurrentUser: {
                        storeName = CA_STORE;
                        break;
                    }
                    case LocalMachine: {
                        storeName = LOCAL_MACHINE_CA_STORE;
                    }
                }
                ks = KeyStore.getInstance(storeName, this.provider);
                ks.load(null, null);
                lista.addAll(KeyTool.getTrustCertificates(ks));
            }
            return lista;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.1", new Object[]{ex.getMessage(), ex}));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.2", new Object[]{ex.getMessage(), ex}));
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.3", new Object[]{ex.getMessage(), ex}));
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mscapi.4", new Object[]{ex.getMessage(), ex}));
        }
    }

    public class NullPassStorePK
    implements IPassStoreKS {
        public char[] getPassword(X509Certificate certificate, String alias) {
            return new char[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationStoreType {
        CurrentUser,
        LocalMachine;

    }
}

