/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.trust.ITrustServices;
import es.mityc.javasign.trust.PropsTruster;
import es.mityc.javasign.trust.TrustAdapter;
import es.mityc.javasign.trust.TrustException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class MyPropsTruster
extends PropsTruster
implements ITrustServices {
    private static final String CONF_FILE = "trust/myTruster.properties";
    private static final String EXT_CONF_FILE = "truster.properties";
    private static final String USER_PATH_CONF = "myTrusterPath.properties";
    private static final String PATH_KEY = "es.mityc.myTruster.path";

    public MyPropsTruster(String externalConfPath) {
        super(CONF_FILE, externalConfPath);
    }

    public static synchronized TrustAdapter getInstance(String externalConfPath) {
        if (instance == null) {
            instance = new MyPropsTruster(externalConfPath);
        }
        return instance;
    }

    private static synchronized void reloadInstance(String externalConfPath) {
        ((PropsTruster)instance).loadConf(CONF_FILE, externalConfPath);
    }

    public void addCA(X509Certificate cert, PropsTruster.TrusterType type) throws TrustException {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(USER_PATH_CONF));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (props == null || !props.contains(PATH_KEY)) {
            throw new TrustException();
        }
        this.addCA(cert, type, System.getProperty("user.home") + props.getProperty(PATH_KEY));
    }

    public void addCA(X509Certificate cert, PropsTruster.TrusterType type, String path) throws TrustException {
        String pathToCert;
        File desFile;
        String[] dn = cert.getSubjectX500Principal().getName("CANONICAL").split(",");
        String subjectName = dn[2].substring(dn[2].lastIndexOf(61) + 1);
        if ((subjectName = subjectName.replace(" ", "")).length() > 16) {
            subjectName = subjectName.substring(0, 16);
        }
        if (!(desFile = new File(pathToCert = path + File.separator + "CAs")).exists()) {
            desFile.mkdir();
        }
        pathToCert = path + File.separator + "CAs" + File.separator + subjectName + ".cer";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pathToCert);
            fos.write(cert.getEncoded());
        }
        catch (IOException e) {
            throw new TrustException((Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new TrustException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        String extPropsPath = path + File.separator + EXT_CONF_FILE;
        File extPropsFile = new File(extPropsPath);
        if (!extPropsFile.exists()) {
            try {
                if (!extPropsFile.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                throw new TrustException((Throwable)e);
            }
        }
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(extPropsFile);
            props.load(fis);
            fis.close();
            String key = type.toString() + '.' + subjectName;
            int i = 2;
            while (props.contains(key)) {
                key = type.toString() + '.' + subjectName + i;
                ++i;
            }
            props.setProperty(key, pathToCert);
            fos = new FileOutputStream(extPropsFile);
            props.store(fos, null);
            MyPropsTruster.reloadInstance(extPropsPath);
        }
        catch (IOException e) {
            throw new TrustException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

