/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilidadTratarNodo {
    private static Log log = LogFactory.getLog(UtilidadTratarNodo.class);
    private static final String[] IDs = new String[]{"Id", "id", "ID"};
    private static Random rnd = new Random(new Date().getTime());
    private static final int RND_MAX_SIZE = 0x100000;
    public static final String XPOINTER_ID = "#xpointer(id('";
    public static final String XPOINTER_ROOT = "#xpointer(/)";

    public static byte[] obtenerByteNodo(Document doc, String ns, String nombreHijos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        return UtilidadTratarNodo.obtenerByteNodo(doc.getDocumentElement(), ns, nombreHijos, canonicalization, 0);
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, CanonicalizationEnum canonicalization, int tope) throws FirmaXMLError {
        return UtilidadTratarNodo.obtenerByteNodo(padre, ns, nombreHijos, true, canonicalization, tope);
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, boolean requerido, CanonicalizationEnum canonicalization, int tope) throws FirmaXMLError {
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            throw new FirmaXMLError("Canonicalization Method desconocido");
        }
        ArrayList<Object> nodesHijos = new ArrayList();
        if (ns == null) {
            ns = padre.getNamespaceURI();
        }
        if (tope <= 0) {
            NodeList nodosSinTope = padre.getElementsByTagNameNS(ns, nombreHijos);
            for (int i = 0; i < nodosSinTope.getLength(); ++i) {
                nodesHijos.add((Element)nodosSinTope.item(i));
            }
        } else {
            nodesHijos = UtilidadTratarNodo.obtenerNodos(padre, tope, new NombreNodo(ns, nombreHijos));
        }
        log.debug((Object)("N\u00famero de firmas en el documento: " + nodesHijos.size()));
        if (nodesHijos.size() == 0 && requerido) {
            log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error8") + " " + I18n.getResource("libreriaxades.firmaxml.error33") + " " + nombreHijos));
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8") + " " + I18n.getResource("libreriaxades.firmaxml.error33") + " " + nombreHijos);
        }
        if (nodesHijos.size() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            for (int i = 0; i < nodesHijos.size(); ++i) {
                XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodesHijos.get(i));
                try {
                    XMLSignatureInput resultado = null;
                    resultado = t.performTransforms(xmlSignatureInput);
                    bais.write(resultado.getBytes());
                    continue;
                }
                catch (TransformationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (CanonicalizationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (IOException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, Element tope) throws FirmaXMLError {
        NodeList nodesHijos = null;
        if (ns == null) {
            ns = padre.getNamespaceURI();
        }
        if ((nodesHijos = padre.getChildNodes()).getLength() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            for (int i = 0; i < nodesHijos.getLength(); ++i) {
                Node nodo = nodesHijos.item(i);
                if (nodo.getNodeType() != 1) continue;
                if (tope != null && tope.isEqualNode(nodo)) break;
                if (!nodo.getLocalName().equals(nombreHijos) || (ns == null ? nodo.getNamespaceURI() != null : !ns.equals(nodo.getNamespaceURI()))) continue;
                XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(nodo);
                try {
                    XMLSignatureInput resultado = null;
                    resultado = t.performTransforms(xmlSignatureInput);
                    bais.write(resultado.getBytes());
                    continue;
                }
                catch (TransformationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (CanonicalizationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (IOException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static byte[] obtenerByteNodo(Element padre, ArrayList<NombreNodo> nombreHijos, Element tope) throws FirmaXMLError {
        NodeList nodesHijos = null;
        nodesHijos = padre.getChildNodes();
        if (nodesHijos.getLength() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            for (int i = 0; i < nodesHijos.getLength(); ++i) {
                Node nodo = nodesHijos.item(i);
                if (nodo.getNodeType() != 1) continue;
                if (tope != null && tope.isEqualNode(nodo)) break;
                NombreNodo nombreNodo = new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName());
                if (nombreHijos.indexOf(nombreNodo) == -1) continue;
                XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(nodo);
                try {
                    XMLSignatureInput resultado = null;
                    resultado = t.performTransforms(xmlSignatureInput);
                    bais.write(resultado.getBytes());
                    continue;
                }
                catch (TransformationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (CanonicalizationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (IOException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, Element tope, NombreNodo nombreHijo) {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        for (int i = 0; i < nodesHijos.getLength(); ++i) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() != 1) continue;
            if (tope != null && tope.isEqualNode(nodo)) break;
            if (!new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName()).equals(nombreHijo)) continue;
            resultado.add((Element)nodo);
        }
        return resultado;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, Element tope, ArrayList<NombreNodo> nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        for (int i = 0; i < nodesHijos.getLength(); ++i) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() != 1) continue;
            if (tope != null && tope.isEqualNode(nodo)) break;
            if (nombreHijos.indexOf(new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName())) == -1) continue;
            resultado.add((Element)nodo);
        }
        return resultado;
    }

    public static byte[] obtenerByteNuevo(ArrayList<Element> nodos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodos == null || nodos.size() == 0) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        for (Element nodo : nodos) {
            try {
                bais.write(UtilidadTratarNodo.obtenerByte(nodo, canonicalization));
            }
            catch (IOException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
        }
        if (bais.size() > 0) {
            return bais.toByteArray();
        }
        return null;
    }

    public static byte[] obtenerByte(Element nodo, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodo == null) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        Transforms t = new Transforms(nodo.getOwnerDocument());
        try {
            t.addTransform(canonicalization.toString());
        }
        catch (TransformationException e) {
            log.error((Object)e);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodo);
        try {
            XMLSignatureInput resultado = null;
            resultado = t.performTransforms(xmlSignatureInput);
            return resultado.getBytes();
        }
        catch (TransformationException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        catch (CanonicalizationException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        catch (IOException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
    }

    public static byte[] obtenerByte(ArrayList<Element> nodos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodos == null || nodos.size() == 0) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        Transforms t = new Transforms(nodos.get(0).getOwnerDocument());
        try {
            t.addTransform(canonicalization.toString());
        }
        catch (TransformationException e) {
            log.error((Object)e);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        for (Element nodo : nodos) {
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodo);
            try {
                XMLSignatureInput resultado = null;
                resultado = t.performTransforms(xmlSignatureInput);
                bais.write(resultado.getBytes());
            }
            catch (TransformationException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            catch (CanonicalizationException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            catch (IOException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
        }
        if (bais.size() > 0) {
            return bais.toByteArray();
        }
        return null;
    }

    public static ArrayList<String> obtenerIDs(ArrayList<Element> elementos) {
        if (elementos == null) {
            return null;
        }
        ArrayList<String> resultado = new ArrayList<String>();
        block0: for (Element elemento : elementos) {
            int i;
            boolean encontrado = false;
            NamedNodeMap map = elemento.getAttributes();
            for (i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                if (!attr.isId()) continue;
                resultado.add(attr.getValue());
                encontrado = true;
                break;
            }
            if (encontrado) continue;
            for (i = 0; i < IDs.length; ++i) {
                if (!elemento.hasAttribute(IDs[i])) continue;
                resultado.add(elemento.getAttribute(IDs[i]));
                continue block0;
            }
        }
        return resultado;
    }

    public static Element getElementById(NodeList list, String id) {
        Element resultado = null;
        if (list != null) {
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element el;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !id.equals((el = (Element)node).getAttribute("Id"))) continue;
                resultado = el;
                break;
            }
        }
        return resultado;
    }

    private static Element exploreElementById(Element el, String id) {
        if (el != null) {
            for (int i = 0; i < IDs.length; ++i) {
                if (!id.equals(el.getAttribute(IDs[i]))) continue;
                return el;
            }
            NodeList nodes = el.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element temp;
                Node nodo = nodes.item(i);
                if (nodo.getNodeType() != 1 || (temp = UtilidadTratarNodo.exploreElementById((Element)nodo, id)) == null) continue;
                return temp;
            }
        }
        return null;
    }

    public static Element getElementById(Document doc, String id) {
        if (doc == null || id == null) {
            return null;
        }
        String string = id != null ? (id.startsWith("#") ? (id.startsWith(XPOINTER_ID) ? id.substring(XPOINTER_ID.length(), id.length() - 2) : id.substring(1)) : id) : (id = null);
        if (id.length() == 0) {
            return doc.getDocumentElement();
        }
        Element el = doc.getElementById(id);
        if (el == null) {
            el = UtilidadTratarNodo.exploreElementById(doc.getDocumentElement(), id);
        }
        return el;
    }

    public static Element getElementById(Element padre, String id) {
        Element el = UtilidadTratarNodo.getElementById(padre.getOwnerDocument(), id);
        if (el != null) {
            Node temp;
            for (temp = el; temp != null && !temp.isSameNode(padre); temp = temp.getParentNode()) {
            }
            if (temp != null) {
                return el;
            }
        }
        return null;
    }

    public static boolean isChildNode(Element child, Element parent) {
        Node temp;
        for (temp = child; temp != null && !temp.isSameNode(parent); temp = temp.getParentNode()) {
        }
        return temp != null;
    }

    public static boolean isChildNode(Element child, NombreNodo parent, Element top) {
        Node temp;
        for (temp = child; temp != null && !temp.isSameNode(top) && !parent.equals(temp); temp = temp.getParentNode()) {
        }
        return parent.equals(temp);
    }

    public static String newID(Document doc, String prefix) {
        String newID = prefix + rnd.nextInt(0x100000);
        while (UtilidadTratarNodo.getElementById(doc, newID) != null) {
            newID = prefix + rnd.nextInt(0x100000);
        }
        return newID;
    }

    public static Element getFirstElementChild(Node node, boolean strict) {
        Node nodeTemp;
        for (nodeTemp = node.getFirstChild(); nodeTemp != null && nodeTemp.getNodeType() != 1; nodeTemp = nodeTemp.getNextSibling()) {
            if (!strict || nodeTemp.getNodeType() != 3) continue;
            String text = nodeTemp.getNodeValue().trim();
            text = text.replaceAll("/n", "");
            text = text.replaceAll("/r", "");
            if ((text = text.replaceAll(" ", "")).equals("")) continue;
            return null;
        }
        return (Element)nodeTemp;
    }

    public static Element getNextElementSibling(Node node, boolean strict) {
        Node nodeTemp;
        for (nodeTemp = node.getNextSibling(); nodeTemp != null && nodeTemp.getNodeType() != 1; nodeTemp = nodeTemp.getNextSibling()) {
            if (!strict || nodeTemp.getNodeType() != 3) continue;
            String text = nodeTemp.getNodeValue().trim();
            text = text.replaceAll("/n", "");
            text = text.replaceAll("/r", "");
            if ((text = text.replaceAll(" ", "")).equals("")) continue;
            return null;
        }
        return (Element)nodeTemp;
    }

    public static ArrayList<Element> getElementChildNodes(Element nodo, boolean strict) {
        ArrayList<Element> retorno = new ArrayList<Element>();
        Element hijo = UtilidadTratarNodo.getFirstElementChild(nodo, strict);
        int tope = nodo.getChildNodes().getLength();
        for (int i = 0; i < tope && hijo != null; ++i) {
            retorno.add(hijo);
            hijo = UtilidadTratarNodo.getNextElementSibling(hijo, strict);
        }
        return retorno;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, int tope, NombreNodo nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        if (tope < 1) {
            tope = 1;
        }
        for (int i = 0; i < nodesHijos.getLength(); ++i) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() != 1) continue;
            if (nombreHijos.equals(new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName()))) {
                resultado.add((Element)nodo);
            }
            if (tope <= 1) continue;
            NodeList nodosHijos2 = nodo.getChildNodes();
            for (int j = 0; j < nodosHijos2.getLength(); ++j) {
                Node nodo2 = nodosHijos2.item(j);
                if (nodo2.getNodeType() != 1) continue;
                if (nombreHijos.equals(new NombreNodo(nodo2.getNamespaceURI(), nodo2.getLocalName()))) {
                    resultado.add((Element)nodo2);
                }
                if (tope <= 2) continue;
                NodeList nodosHijos3 = nodo2.getChildNodes();
                for (int k = 0; k < nodosHijos3.getLength(); ++k) {
                    Node nodo3 = nodosHijos3.item(k);
                    if (nodo3.getNodeType() != 1) continue;
                    if (nombreHijos.equals(new NombreNodo(nodo3.getNamespaceURI(), nodo3.getLocalName()))) {
                        resultado.add((Element)nodo3);
                    }
                    if (tope <= 3) continue;
                    NodeList nodosHijos4 = nodo3.getChildNodes();
                    for (int l = 0; l < nodosHijos4.getLength(); ++l) {
                        Node nodo4 = nodosHijos4.item(l);
                        if (nodo4.getNodeType() != 1) continue;
                        if (nombreHijos.equals(new NombreNodo(nodo4.getNamespaceURI(), nodo4.getLocalName()))) {
                            resultado.add((Element)nodo4);
                        }
                        if (tope <= 4) continue;
                        NodeList nodosHijos5 = nodo4.getChildNodes();
                        for (int m = 0; m < nodosHijos5.getLength(); ++m) {
                            Node nodo5 = nodosHijos5.item(m);
                            if (nodo5.getNodeType() != 1 || !nombreHijos.equals(new NombreNodo(nodo5.getNamespaceURI(), nodo5.getLocalName()))) continue;
                            resultado.add((Element)nodo5);
                        }
                    }
                }
            }
        }
        return resultado;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, int tope, String nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        if (tope < 1) {
            tope = 1;
        }
        for (int i = 0; i < nodesHijos.getLength(); ++i) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() != 1) continue;
            if (nombreHijos.equals(nodo.getLocalName())) {
                resultado.add((Element)nodo);
            }
            if (tope <= 1) continue;
            NodeList nodosHijos2 = nodo.getChildNodes();
            for (int j = 0; j < nodosHijos2.getLength(); ++j) {
                Node nodo2 = nodosHijos2.item(j);
                if (nodo2.getNodeType() != 1) continue;
                if (nombreHijos.equals(nodo2.getLocalName())) {
                    resultado.add((Element)nodo2);
                }
                if (tope <= 2) continue;
                NodeList nodosHijos3 = nodo2.getChildNodes();
                for (int k = 0; k < nodosHijos3.getLength(); ++k) {
                    Node nodo3 = nodosHijos3.item(k);
                    if (nodo3.getNodeType() != 1) continue;
                    if (nombreHijos.equals(nodo3.getLocalName())) {
                        resultado.add((Element)nodo3);
                    }
                    if (tope <= 3) continue;
                    NodeList nodosHijos4 = nodo3.getChildNodes();
                    for (int l = 0; l < nodosHijos4.getLength(); ++l) {
                        Node nodo4 = nodosHijos4.item(l);
                        if (nodo4.getNodeType() != 1) continue;
                        if (nombreHijos.equals(nodo4.getLocalName())) {
                            resultado.add((Element)nodo4);
                        }
                        if (tope <= 4) continue;
                        NodeList nodosHijos5 = nodo4.getChildNodes();
                        for (int m = 0; m < nodosHijos5.getLength(); ++m) {
                            Node nodo5 = nodosHijos5.item(m);
                            if (nodo5.getNodeType() != 1 || !nombreHijos.equals(nodo5.getLocalName())) continue;
                            resultado.add((Element)nodo5);
                        }
                    }
                }
            }
        }
        return resultado;
    }

    public static void saveDocumentToOutputStream(Document document, OutputStream outputStream) {
        XMLUtils.outputDOM((Node)document, (OutputStream)outputStream);
    }

    public static void saveDocumentToOutputStream(Document document, OutputStream outputStream, boolean addPreamble) {
        XMLUtils.outputDOM((Node)document, (OutputStream)outputStream, (boolean)addPreamble);
    }
}

