/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.xades.EnumFormatoFirma;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.role.IClaimedRole;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.xml.refs.ObjectToSign;
import es.mityc.javasign.xml.xades.IStoreElements;
import es.mityc.javasign.xml.xades.LocalFileStoreElements;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataToSign {
    private Date signDate;
    private File xmlInFileToSign;
    private String xmlToSign;
    private String basePath;
    private boolean enveloped;
    private ArrayList<ObjectToSign> objects;
    private File signingCert;
    private String[] productionPlace;
    private ArrayList<IClaimedRole> claimedRoles;
    private ICertStatusRecoverer certStatusManager;
    private String algDigestXmlDSig = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String algDigestTSA = "http://www.w3.org/2000/09/xmldsig#sha1";
    private XAdESSchemas esquema = XAdESSchemas.XAdES_132;
    private IStoreElements storer;
    private boolean addPolicy = false;
    private String policyKey;
    private EnumFormatoFirma xadesFormat = EnumFormatoFirma.XAdES_BES;
    private Document doc;
    private String parentSignNode;
    private XADES_X_TYPES xadesXType = XADES_X_TYPES.TYPE_1;
    private String encoding = "UTF-8";

    public DataToSign(File xmlToSign) {
        this.xmlInFileToSign = xmlToSign;
        this.basePath = xmlToSign.getParent();
        this.signDate = new Date();
    }

    public DataToSign(String xmlToSign) {
        this.xmlToSign = xmlToSign;
        this.signDate = new Date();
    }

    public DataToSign() {
        this.signDate = new Date();
    }

    public void setXMLEncoding(String _encoding) {
        this.encoding = _encoding;
    }

    public String getXMLEncoding() {
        return this.encoding;
    }

    public void setXAdESXType(XADES_X_TYPES _xadesXType) {
        this.xadesXType = _xadesXType;
    }

    public XADES_X_TYPES getXAdESXType() {
        return this.xadesXType;
    }

    public String getParentSignNode() {
        return this.parentSignNode;
    }

    public void setParentSignNode(String parentNode) {
        this.parentSignNode = parentNode;
    }

    public EnumFormatoFirma getXadesFormat() {
        return this.xadesFormat;
    }

    public void setXadesFormat(EnumFormatoFirma xadesFormat) {
        this.xadesFormat = xadesFormat;
    }

    public boolean hasPolicy() {
        return this.addPolicy;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setAddPolicy(boolean addPolicy) {
        this.addPolicy = addPolicy;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public void setElementsStorer(IStoreElements storer) {
        this.storer = storer;
    }

    public IStoreElements getElementsStorer() {
        if (this.storer == null) {
            LocalFileStoreElements nullStorer = new LocalFileStoreElements();
            nullStorer.init(this.getBaseURI());
            this.storer = nullStorer;
        }
        return this.storer;
    }

    public boolean isEnveloped() {
        return this.enveloped;
    }

    public void setEnveloped(boolean enveloped) {
        this.enveloped = enveloped;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.enveloped) {
            if (this.xmlInFileToSign != null) {
                is = new FileInputStream(this.xmlInFileToSign);
            } else if (this.xmlToSign != null) {
                is = new ByteArrayInputStream(this.xmlToSign.getBytes());
            }
        }
        return is;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getBaseURI() {
        if (this.basePath != null) {
            return this.basePath;
        }
        return "";
    }

    public void setBaseURI(String basePath) {
        this.basePath = basePath;
    }

    public void addObject(ObjectToSign object) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        this.objects.add(object);
    }

    public ArrayList<ObjectToSign> getObjects() {
        return this.objects;
    }

    public Date getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public File getSigningCert() {
        return this.signingCert;
    }

    public void setSigningCert(File signingCert) {
        this.signingCert = signingCert;
    }

    public void setProductionPlace(String city, String state, String postalCode, String country) {
        if (city == null && state == null && postalCode == null && country == null) {
            this.productionPlace = null;
        } else {
            this.productionPlace = new String[4];
            this.productionPlace[0] = city;
            this.productionPlace[1] = state;
            this.productionPlace[2] = postalCode;
            this.productionPlace[3] = country;
        }
    }

    public String[] getProductionPlace() {
        return this.productionPlace;
    }

    public void addClaimedRol(IClaimedRole data) {
        if (this.claimedRoles == null) {
            this.claimedRoles = new ArrayList();
        }
        this.claimedRoles.add(data);
    }

    public ArrayList<IClaimedRole> getClaimedRoles() {
        return this.claimedRoles;
    }

    public ICertStatusRecoverer getCertStatusManager() {
        return this.certStatusManager;
    }

    public void setCertStatusManager(ICertStatusRecoverer certStatusManager) {
        this.certStatusManager = certStatusManager;
    }

    public File getXmlInFileToSign() {
        return this.xmlInFileToSign;
    }

    public String getAlgDigestXmlDSig() {
        return this.algDigestXmlDSig;
    }

    public void setAlgDigestXmlDSig(String algDigestXmlDSig) {
        if (algDigestXmlDSig != null) {
            this.algDigestXmlDSig = algDigestXmlDSig;
        }
    }

    public String getAlgDigestTSA() {
        return this.algDigestTSA;
    }

    public void setAlgDigestTSA(String algDigestTSA) {
        this.algDigestTSA = algDigestTSA;
    }

    public XAdESSchemas getEsquema() {
        return this.esquema;
    }

    public void setEsquema(XAdESSchemas esquema) {
        this.esquema = esquema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XADES_X_TYPES {
        TYPE_1,
        TYPE_2;

    }
}

