/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.SignerOutputStream;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)XMLSignature.class.getName());
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA1 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    private SignedInfo _signedInfo = null;
    private KeyInfo _keyInfo = null;
    private boolean _followManifestsDuringValidation = false;
    private Element signatureValueElement;

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, int HMACOutputLength) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, HMACOutputLength, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, String CanonicalizationMethodURI) throws XMLSecurityException {
        this(doc, BaseURI, SignatureMethodURI, 0, CanonicalizationMethodURI);
    }

    public XMLSignature(Document doc, String BaseURI, String SignatureMethodURI, int HMACOutputLength, String CanonicalizationMethodURI) throws XMLSecurityException {
        super(doc);
        String xmlnsDsPrefix = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (xmlnsDsPrefix == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlnsDsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._signedInfo = new SignedInfo(this._doc, SignatureMethodURI, HMACOutputLength, CanonicalizationMethodURI);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Document doc, String BaseURI, Element SignatureMethodElem, Element CanonicalizationMethodElem) throws XMLSecurityException {
        super(doc);
        String xmlnsDsPrefix = XMLSignature.getDefaultPrefixBindings("http://www.w3.org/2000/09/xmldsig#");
        if (xmlnsDsPrefix == null) {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlnsDsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = BaseURI;
        this._signedInfo = new SignedInfo(this._doc, SignatureMethodElem, CanonicalizationMethodElem);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(this.signatureValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Element element, String BaseURI) throws XMLSignatureException, XMLSecurityException {
        super(element, BaseURI);
        Element signedInfoElem = XMLUtils.getNextElement(element.getFirstChild());
        if (signedInfoElem == null) {
            Object[] exArgs = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", exArgs);
        }
        this._signedInfo = new SignedInfo(signedInfoElem, BaseURI);
        this.signatureValueElement = XMLUtils.getNextElement(signedInfoElem.getNextSibling());
        if (this.signatureValueElement == null) {
            Object[] exArgs = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", exArgs);
        }
        Element keyInfoElem = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling());
        if (keyInfoElem != null && keyInfoElem.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && keyInfoElem.getLocalName().equals("KeyInfo")) {
            this._keyInfo = new KeyInfo(keyInfoElem, BaseURI);
        }
    }

    public void setId(String Id) {
        if (Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this._signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            byte[] signatureValue = Base64.decode(this.signatureValueElement);
            return signatureValue;
        }
        catch (Base64DecodingException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    private void setSignatureValueElement(byte[] bytes) {
        while (this.signatureValueElement.hasChildNodes()) {
            this.signatureValueElement.removeChild(this.signatureValueElement.getFirstChild());
        }
        String base64codedValue = Base64.encode(bytes);
        if (base64codedValue.length() > 76 && !XMLUtils.ignoreLineBreaks()) {
            base64codedValue = "\n" + base64codedValue + "\n";
        }
        Text t = this._doc.createTextNode(base64codedValue);
        this.signatureValueElement.appendChild(t);
    }

    public KeyInfo getKeyInfo() {
        if (this._keyInfo == null) {
            this._keyInfo = new KeyInfo(this._doc);
            Element keyInfoElement = this._keyInfo.getElement();
            Element firstObject = null;
            Node sibling = this._constructionElement.getFirstChild();
            firstObject = XMLUtils.selectDsNode(sibling, "Object", 0);
            if (firstObject != null) {
                this._constructionElement.insertBefore(keyInfoElement, firstObject);
                XMLUtils.addReturnBeforeChild(this._constructionElement, firstObject);
            } else {
                this._constructionElement.appendChild(keyInfoElement);
                XMLUtils.addReturnToElement(this._constructionElement);
            }
        }
        return this._keyInfo;
    }

    public void appendObject(ObjectContainer object) throws XMLSignatureException {
        this._constructionElement.appendChild(object.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public ObjectContainer getObjectItem(int i) {
        Element objElem = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Object", i);
        try {
            return new ObjectContainer(objElem, this._baseURI);
        }
        catch (XMLSecurityException ex) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key signingKey) throws XMLSignatureException {
        if (signingKey instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        try {
            SignedInfo si = this.getSignedInfo();
            SignatureAlgorithm sa = si.getSignatureAlgorithm();
            sa.initSign(signingKey);
            si.generateDigestValues();
            UnsyncBufferedOutputStream so = new UnsyncBufferedOutputStream(new SignerOutputStream(sa));
            try {
                ((OutputStream)so).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            si.signInOctectStream(so);
            byte[] jcebytes = sa.sign();
            this.setSignatureValueElement(jcebytes);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public void addResourceResolver(ResourceResolver resolver) {
        this.getSignedInfo().addResourceResolver(resolver);
    }

    public void addResourceResolver(ResourceResolverSpi resolver) {
        this.getSignedInfo().addResourceResolver(resolver);
    }

    public boolean checkSignatureValue(X509Certificate cert) throws XMLSignatureException {
        if (cert != null) {
            return this.checkSignatureValue(cert.getPublicKey());
        }
        Object[] exArgs = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", exArgs);
    }

    public boolean checkSignatureValue(Key pk) throws XMLSignatureException {
        if (pk == null) {
            Object[] exArgs = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", exArgs);
        }
        try {
            SignedInfo si = this.getSignedInfo();
            SignatureAlgorithm sa = si.getSignatureAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SignatureMethodURI = " + sa.getAlgorithmURI()));
                log.debug((Object)("jceSigAlgorithm    = " + sa.getJCEAlgorithmString()));
                log.debug((Object)("jceSigProvider     = " + sa.getJCEProviderName()));
                log.debug((Object)("PublicKey = " + pk));
            }
            sa.initVerify(pk);
            SignerOutputStream so = new SignerOutputStream(sa);
            UnsyncBufferedOutputStream bos = new UnsyncBufferedOutputStream(so);
            si.signInOctectStream(bos);
            try {
                ((OutputStream)bos).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            byte[] sigBytes = this.getSignatureValue();
            if (!sa.verify(sigBytes)) {
                log.warn((Object)"Signature verification failed.");
                return false;
            }
            return si.verify(this._followManifestsDuringValidation);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public void addDocument(String referenceURI, Transforms trans, String digestURI, String ReferenceId, String ReferenceType) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, digestURI, ReferenceId, ReferenceType);
    }

    public void addDocument(String referenceURI, Transforms trans, String digestURI) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, digestURI, null, null);
    }

    public void addDocument(String referenceURI, Transforms trans) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, trans, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String referenceURI) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, referenceURI, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate cert) throws XMLSecurityException {
        X509Data x509data = new X509Data(this._doc);
        x509data.addCertificate(cert);
        this.getKeyInfo().add(x509data);
    }

    public void addKeyInfo(PublicKey pk) {
        this.getKeyInfo().add(pk);
    }

    public SecretKey createSecretKey(byte[] secretKeyBytes) {
        return this.getSignedInfo().createSecretKey(secretKeyBytes);
    }

    public void setFollowNestedManifests(boolean followManifests) {
        this._followManifestsDuringValidation = followManifests;
    }

    public String getBaseLocalName() {
        return "Signature";
    }
}

