/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    static final byte[] none = "error".getBytes();
    final MessageDigestAlgorithm mda;
    static Log log = LogFactory.getLog((String)DigesterOutputStream.class.getName());

    public DigesterOutputStream(MessageDigestAlgorithm mda) {
        this.mda = mda;
    }

    public byte[] toByteArray() {
        return none;
    }

    public void write(byte[] arg0) {
        this.write(arg0, 0, arg0.length);
    }

    public void write(int arg0) {
        this.mda.update((byte)arg0);
    }

    public void write(byte[] arg0, int arg1, int arg2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre-digested input:");
            StringBuffer sb = new StringBuffer(arg2);
            for (int i = arg1; i < arg1 + arg2; ++i) {
                sb.append((char)arg0[i]);
            }
            log.debug((Object)sb.toString());
        }
        this.mda.update(arg0, arg1, arg2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

