/*
 * Decompiled with CFR 0.152.
 */
package ar.com.gs.entidades;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Certificado {
    private String alias;
    private X509Certificate cert;
    private PrivateKey key;
    private Certificate[] certificateChain;
    private long diasAExpirar;
    private Provider provider;

    public Certificado(String alias, X509Certificate cert, PrivateKey pk, Certificate[] certificateChain) {
        this.alias = alias;
        this.cert = cert;
        this.key = pk;
        this.certificateChain = certificateChain;
        Date today = new Date();
        Date certDate = cert.getNotAfter();
        long diff = certDate.getTime() - today.getTime();
        this.diasAExpirar = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public String getAlias() {
        return this.alias;
    }

    public long getDiasAExpirar() {
        return this.diasAExpirar;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

