/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.controladores.WorkerDescarga;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.ModoDeEjecucion;
import ar.com.lyris.vistas.ProgressWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;

public class Principal
extends PrincipalBase {
    public ModoDeEjecucion modoDeEjecucion;

    public Principal(String[] args) {
        super(args);
    }

    @Override
    public void run() {
        this.iniciarCertController(this);
        this.descargarMetadatos();
        this.cargarPropiedades();
        if (this.getDocumentos().isEmpty()) {
            JOptionPane.showMessageDialog(this.getFrame(), "No se encontraron documentos para firmar \n", "Error grave", 0);
            this.getFrame().finalizacion("con errores");
            this.finalizar(1);
        }
        this.actualizarSiHayRecibos();
        this.getFrame().actualizarPorModoEjecucion();
        this.setProgressWorker(new ProgressWorker(this));
        this.getProgressWorker().execute();
        WorkerDescarga wDescarga = new WorkerDescarga(this);
        wDescarga.execute();
        try {
            wDescarga.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        int finalizados = 0;
        for (Documento doc : this.getDocumentos()) {
            if (!doc.getEstado().equals((Object)EstadoDoc.DESCARGADO)) continue;
            ++finalizados;
        }
        if (finalizados == this.getCantDocumentos()) {
            this.getFrame().habilitarFirmado();
        } else if (finalizados > 1) {
            this.informarProblemaAlternativa("Fallo la descarga de uno o mas documentos, \u00bfcontinuar de todas formas?", "Problema en la descarga");
            this.limpiarDocNoDescargados();
            this.getFrame().habilitarFirmado();
        }
    }

    private void limpiarDocNoDescargados() {
        ArrayList<Documento> aux = new ArrayList<Documento>();
        for (Documento doc : this.getDocumentos()) {
            if (!doc.getEstado().equals((Object)EstadoDoc.DESCARGADO)) continue;
            aux.add(doc);
        }
        this.setDocumentos(aux);
        this.refrescarTabla();
    }

    public void setearConformidadDeTodosLosRecibos(boolean b) {
        for (Documento d : this.getDocumentos()) {
            d.setEnConformidad(b);
        }
    }

    private void actualizarSiHayRecibos() {
        this.modoDeEjecucion = ModoDeEjecucion.FIRMA_DOCUMENTOS;
        for (Documento d : this.getDocumentos()) {
            if (!d.isRecibo()) continue;
            this.modoDeEjecucion = ModoDeEjecucion.FIRMA_RECIBOS;
            this.reordenarListaDoc();
            System.out.println("Modo de ejecucion, hay recibos");
            break;
        }
    }

    @Override
    public ModoDeEjecucion getModoEjecucion() {
        return this.modoDeEjecucion;
    }

    private void reordenarListaDoc() {
        Collections.sort(this.getDocumentos(), new Comparator<Documento>(){

            @Override
            public int compare(Documento d1, Documento d2) {
                return d2.getTif().compareTo(d1.getTif());
            }
        });
    }
}

