/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoApp;
import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.Filtro;
import ar.com.lyris.entidades.Metadatos;
import ar.com.lyris.entidades.ModoDeEjecucion;
import ar.com.lyris.entidades.TipoFirma;
import ar.com.lyris.entidades.TipoRecibo;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PrincipalCargaRecibo
extends PrincipalBase {
    private List<TipoRecibo> tiposDeRecibo;

    public PrincipalCargaRecibo(String[] args) {
        super(args);
    }

    @Override
    public void run() {
        this.iniciarCertController(this);
        this.descargarMetadatos();
        this.cargarPropiedades();
        this.estadoApp = EstadoApp.DESCARGANDO;
        this.getFrame().labelProgreso.setText("Recibos seleccionados");
        this.lanzarFileChooser();
        this.getFrame().actualizarPorModoEjecucion();
        this.getFrame().habilitarFirmado();
    }

    private void lanzarFileChooser() {
        block10: {
            int seleccion;
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            fc.setFileFilter(new FileNameExtensionFilter("PDF Documents", "pdf"));
            fc.setDialogTitle("Seleccione uno o mas recibos");
            fc.setMultiSelectionEnabled(true);
            if (!this.rutaArchivos.equals("")) {
                fc.setCurrentDirectory(new File(this.rutaArchivos));
            }
            if ((seleccion = fc.showOpenDialog(this.getFrame().getContentPane())) == -1) {
                JOptionPane.showMessageDialog(this.getFrame(), "Ocurrio un error, intente mas tarde.", "Insane error", 0);
                this.finalizar(1);
            }
            if (seleccion == 1) {
                JOptionPane.showMessageDialog(this.getFrame(), "No se seleccionaron recibos.", "Insane error", 0);
                this.finalizar(1);
            }
            if (seleccion != 0) break block10;
            System.out.println("filechooser correcto");
            File f = new File(fc.getSelectedFile().getAbsolutePath());
            if (f.exists()) {
                this.setDocumentos(new ArrayList<Documento>());
                if (fc.getSelectedFile().isDirectory()) {
                    this.rutaArchivos = f.getParent();
                    File[] ficheros = f.listFiles(new Filtro(".pdf"));
                    int x = 0;
                    while (x < ficheros.length) {
                        this.crearRecibo(ficheros[x]);
                        ++x;
                    }
                } else {
                    File[] files = fc.getSelectedFiles();
                    int x = 0;
                    while (x < files.length) {
                        if (x == 0) {
                            this.rutaArchivos = files[x].getAbsoluteFile().getParent();
                        }
                        if (files[x].getName().toLowerCase().endsWith("pdf")) {
                            this.crearRecibo(files[x]);
                        }
                        ++x;
                    }
                }
            }
        }
    }

    private void crearRecibo(File file) {
        Documento docTemp = new Documento();
        docTemp.setArchivo(file);
        docTemp.obtenerNombreDesdeArchivo();
        docTemp.setId(this.getDocumentos().size());
        docTemp.setEstado(EstadoDoc.CARGADO);
        docTemp.setTif(TipoFirma.REC);
        docTemp.setTempFilePath();
        this.getDocumentos().add(docTemp);
    }

    @Override
    public void setMetadatos(JsonObject metadatos) {
        this.metadatos = new Metadatos();
        this.metadatos.fromJson(metadatos);
    }

    @Override
    public ModoDeEjecucion getModoEjecucion() {
        return ModoDeEjecucion.CARGA_RECIBOS;
    }

    public List<TipoRecibo> getTiposDeRecibo() {
        return this.tiposDeRecibo;
    }

    public void setTiposDeRecibo(List<TipoRecibo> list) {
        this.tiposDeRecibo = list;
    }
}

