/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoDoc;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class WorkerDescarga
extends SwingWorker<Boolean, Integer> {
    private final PrincipalBase principal;

    public WorkerDescarga(PrincipalBase principalBase) {
        this.principal = principalBase;
    }

    @Override
    protected Boolean doInBackground() {
        try {
            for (Documento doc : this.principal.getDocumentos()) {
                doc.setEstado(EstadoDoc.DESCARGANDO);
                this.publish(doc.getId());
                GetRequest request = (GetRequest)((GetRequest)Unirest.get((String)(String.valueOf(this.principal.getUrlDocumentos()) + "/v1/archivo/" + doc.getEncodedWebResource())).header("Authorization", "Bearer " + this.principal.getToken())).header("User-Agent", "Firmador Lyris Desktop 1.0");
                System.out.println("preparing 'GET' request to URL : " + request.getUrl());
                HttpResponse response = request.asBytes();
                System.out.println(response.getStatus());
                if (response.getStatus() == 200) {
                    String inputLine;
                    String[] splittedFilename = doc.getPrintableFileName().split("\\.(?=[^\\.]+$)");
                    File temp = File.createTempFile(String.valueOf(splittedFilename[0]) + "__", "." + splittedFilename[1]);
                    System.out.println(temp.getAbsolutePath());
                    ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream((byte[])response.getBody()));
                    System.out.println(temp.getAbsolutePath());
                    FileOutputStream fos = new FileOutputStream(temp);
                    fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
                    fos.close();
                    BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])response.getBody())));
                    StringBuffer responseFile = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        responseFile.append(inputLine);
                    }
                    in.close();
                    temp.deleteOnExit();
                    doc.setArchivo(temp);
                    doc.setPreview(this.generarPreview(temp));
                    if (response.getStatus() == 200) {
                        doc.setEstado(EstadoDoc.DESCARGADO);
                    }
                    if (this.principal.tiempoDeSleepsDeTesting != 0) {
                        Thread.sleep(this.principal.tiempoDeSleepsDeTesting);
                    }
                    System.out.println("Sent 'GET' request to URL. " + response.getStatus());
                    this.publish(doc.getId());
                    System.out.println(doc.getFilePath());
                    continue;
                }
                if (response.getStatus() == 401) {
                    doc.setEstado(EstadoDoc.NOEXISTE);
                    this.publish(doc.getId());
                    System.out.println(String.valueOf(doc.getPrintableFileName()) + " no existe");
                    continue;
                }
                doc.setEstado(EstadoDoc.NOEXISTE);
                this.publish(doc.getId());
                System.out.println(String.valueOf(doc.getPrintableFileName()) + " no existe");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "Hubo un problema intentando conectar al servidor.";
            JOptionPane.showMessageDialog(this.principal.getFrame(), message, "Error de red", 0);
            this.principal.finalizar(1);
        }
        return true;
    }

    private BufferedImage generarPreview(File temp) {
        return null;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void process(List<Integer> chunks) {
        if (!this.isDone()) {
            this.principal.refrescarTabla();
        }
    }
}

