/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.entidades;

import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.TipoFirma;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class Documento {
    private int id;
    private EstadoDoc estado = EstadoDoc.EN_ESPERA;
    private TipoFirma tipoFirma;
    private File archivo = null;
    private String printableFileName = "";
    private Boolean enConformidad = true;
    private BufferedImage preview;
    private String tempFilePath = null;
    private String encodedWebResource;

    public Documento() {
    }

    public Documento(JsonObject doc) {
        this();
        this.setId(doc.get("id").getAsInt());
        this.setNombre(doc.get("nombre").getAsString());
        this.setTipo(doc.get("tipo").getAsString());
        this.setRuta(doc.get("ruta").getAsString());
    }

    public void setTempFilePath() {
        try {
            String extension = this.tipoFirma.equals((Object)TipoFirma.XML) ? ".xml" : ".pdf";
            this.tempFilePath = File.createTempFile(this.getFileNameWithoutExt(), extension).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return this.archivo.getName();
    }

    public String getFileNameWithoutExt() {
        return this.archivo.getName().substring(0, this.archivo.getName().length() - 4);
    }

    public String getSignedFileName() {
        if (this.tipoFirma.equals((Object)TipoFirma.XML)) {
            return String.valueOf(this.getFileNameWithoutExt()) + ".xml";
        }
        return "f_" + this.archivo.getName();
    }

    public String getFullFilePath() {
        return String.valueOf(this.getFilePath()) + File.separator + this.getFileName();
    }

    public String getFullSignedFilePath() {
        if (this.tempFilePath != null) {
            return this.tempFilePath;
        }
        return String.valueOf(this.getFilePath()) + File.separator + this.getSignedFileName();
    }

    public String getFilePath() {
        if (this.archivo == null) {
            return null;
        }
        return this.archivo.getParentFile().getPath();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int did) {
        this.id = did;
    }

    public EstadoDoc getEstado() {
        return this.estado;
    }

    public void setEstado(EstadoDoc estado) {
        this.estado = estado;
    }

    public String getPrintableFileName() {
        return this.printableFileName;
    }

    public File getArchivo() {
        return this.archivo;
    }

    public void setArchivo(File archivo) {
        this.archivo = archivo;
    }

    public void setNombre(String printableFileName) {
        this.printableFileName = printableFileName;
    }

    public void obtenerNombreDesdeArchivo() {
        String aux1 = this.archivo.getAbsolutePath().replace("\\" + this.archivo.getName(), "");
        String aux2 = aux1.substring(aux1.lastIndexOf("\\") + 1, aux1.length());
        this.printableFileName = String.valueOf(aux2) + "\\" + this.archivo.getName();
    }

    public TipoFirma getTif() {
        return this.tipoFirma;
    }

    public void setTif(TipoFirma tf) {
        this.tipoFirma = tf;
    }

    public void calcularTipoFirma() {
        String extension = "";
        int i = this.encodedWebResource.lastIndexOf(46);
        if (i >= 0) {
            extension = this.encodedWebResource.substring(i + 1);
        }
        if (this.tipoFirma == null) {
            this.tipoFirma = extension.equals("pdf") ? TipoFirma.PDF : TipoFirma.XML;
        }
    }

    public void setRuta(String ruta) {
        this.encodedWebResource = ruta.replace(" ", "%20");
        this.calcularTipoFirma();
    }

    public String getEncodedWebResource() {
        return this.encodedWebResource;
    }

    public void imprimirPorConsola() {
        System.out.println("Documento: " + this.id + "/ Nombre: " + this.archivo.getName());
        System.out.println("Estado: " + (Object)((Object)this.estado));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Documento other = (Documento)obj;
        return this.id == other.id;
    }

    public Boolean getEnConformidad() {
        return this.enConformidad;
    }

    public void setEnConformidad(Boolean enConformidad) {
        System.out.println(enConformidad + " seteado en la conformidad de " + this.printableFileName);
        this.enConformidad = enConformidad;
    }

    public String stringConformidad() {
        return this.getEnConformidad() != false ? "En conformidad" : "En disconformidad";
    }

    public String stringPostConformidad() {
        return this.getEnConformidad() != false ? "conformidad" : "disconformidad";
    }

    public BufferedImage getPreview() {
        return this.preview;
    }

    public void setPreview(BufferedImage preview) {
        this.preview = preview;
    }

    public TipoFirma getTipoFirma() {
        return this.tipoFirma;
    }

    public boolean isRecibo() {
        return this.getTif().equals((Object)TipoFirma.REC);
    }

    public void setTipo(String tf) {
        if (tf.equals("recibo")) {
            this.setTif(TipoFirma.REC);
        }
    }
}

