/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.firma;

import ar.com.gs.entidades.Certificado;
import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.controladores.WorkerFirmado;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.ModoDeEjecucion;
import ar.com.lyris.entidades.TipoFirma;
import ar.com.lyris.firma.BasicOCSPValidation;
import ar.com.lyris.firma.RelativeDetachedSignature;
import ar.com.lyris.vistas.Consola;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignature;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import es.mityc.firmaJava.ocsp.exception.OCSPException;
import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class SignerLib {
    private String urlOcsp;
    private List<Documento> documentos;
    private String razon;
    private int NUMER_ALLOWED_FIRMS_FOR_ROW = 1;
    private float PADDING_X = 3.0f;
    private float PADDING_Y = 3.0f;
    private float MARGIN = 10.0f;
    private float ROW_HEIGHT = 50.0f;
    private float TITLE_HEIGHT = 25.0f;
    public Certificado cert;
    private final Logger LOG = Logger.getLogger(SignerLib.class.getName());
    private FileWriter fichero = null;
    private PrintWriter pw = null;
    private PrincipalBase principal;
    private String urlImagen;
    private String razonGeneral;
    private WorkerFirmado wFirmado;
    private int[] coordsEmpleador;
    private int[] coordsEmpleadoDisconf;
    private int[] coordsEmpleadoConf;

    public SignerLib(WorkerFirmado wFirmado) {
        this.wFirmado = wFirmado;
        this.principal = wFirmado.getPrincipal();
    }

    public int firmarConCertificado(Certificado certificado) throws Exception {
        int r = 0;
        try {
            this.cargarDatosGenerales();
            this.cert = certificado;
            if (this.chequearOCSP()) {
                r = this.firmar();
            }
            return r;
        }
        catch (Exception ex) {
            this.principal.finalizarProgressWorker();
            this.mostrarMensaje(ex.getMessage(), "error");
            r = -1;
            return -1;
        }
    }

    private void cargarDatosGenerales() throws Exception {
        if (this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_DOCUMENTOS)) {
            this.razon = Consola.razonMessage.equals(this.principal.getFrame().getRazonText()) ? "" : this.principal.getFrame().getRazonText();
            this.razonGeneral = this.razon.toString();
        } else {
            this.coordsEmpleadoConf = this.principal.getMetadatos().getModuloRecibos().getCoordsConformidad();
            this.coordsEmpleadoDisconf = this.principal.getMetadatos().getModuloRecibos().getCoordsDisconformidad();
            this.coordsEmpleador = this.principal.getMetadatos().getModuloRecibos().getCoordsEmpleador();
        }
        this.urlImagen = this.principal.getFrame().getUrlImagen();
        this.documentos = this.principal.getDocumentos();
    }

    private boolean chequearOCSP() throws Exception {
        String resultado = null;
        if (this.urlOcsp != null && !this.urlOcsp.equals("")) {
            if (!this.urlOcsp.contains("http://") && !this.urlOcsp.contains("https://")) {
                this.urlOcsp = "http://" + this.urlOcsp;
            }
            BasicOCSPValidation basicOCSPValidation = new BasicOCSPValidation();
            basicOCSPValidation.setOCSP_RESPONDER(this.urlOcsp);
            try {
                resultado = basicOCSPValidation.validateOcsp(this.cert.getCert());
            }
            catch (OCSPException e) {
                if (e.getMessage().contains("301 Moved Permanently") && this.urlOcsp.contains("http://")) {
                    this.urlOcsp = this.urlOcsp.replace("http", "https");
                    return this.chequearOCSP();
                }
                if (e.getMessage().contains("Error verificando cadena de issuers")) {
                    throw new Exception(" El certificado no pertenece a la Autoridad Certificante.");
                }
                throw new Exception("Revise la URL y que el certificado pertenezca a tal AC.");
            }
            if (resultado != null) {
                if (resultado.equals("revoked")) {
                    throw new Exception("Certificado revocado.");
                }
                if (resultado.equals("valid")) {
                    return true;
                }
                if (resultado.equals("unknown")) {
                    throw new Exception("Se desconoce el estado del certificado");
                }
                throw new Exception("Ocurri\u00f3 un error chequeando OCSP.");
            }
            throw new Exception("Ocurri\u00f3 un error chequeando OCSP.");
        }
        return true;
    }

    private int firmar() throws Exception {
        int r = 0;
        String texto = "";
        int cantidad = 0;
        for (Documento doc : this.documentos) {
            doc.setEstado(EstadoDoc.FIRMANDO);
            this.wFirmado.publicarFirmando(doc.getId());
            this.razon = this.principal.getModoEjecucion().equals((Object)ModoDeEjecucion.FIRMA_RECIBOS) ? doc.stringConformidad() : this.razonGeneral;
            r = doc.getTif().equals((Object)TipoFirma.XML) ? this.signFile(doc) : this.signPdf(doc);
            ++cantidad;
            texto = String.valueOf(texto) + doc.getFullSignedFilePath() + "\n";
            if (this.principal.tiempoDeSleepsDeTesting != 0) {
                Thread.sleep(this.wFirmado.getPrincipal().tiempoDeSleepsDeTesting);
            }
            doc.setEstado(EstadoDoc.FIRMADO);
            doc.imprimirPorConsola();
            this.wFirmado.publicarFirmado(doc.getId());
        }
        texto = "Se firmaron " + cantidad + " archivos:\n" + texto;
        System.out.println(texto);
        return r;
    }

    private int signPdf(Documento doc) throws Exception {
        try {
            PdfReader.unethicalreading = true;
            PdfReader reader = new PdfReader(doc.getFullFilePath());
            int pages = reader.getNumberOfPages();
            FileOutputStream fout = new FileOutputStream(doc.getFullSignedFilePath());
            try {
                int n;
                PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)'\u0000', null, (boolean)true);
                PdfSignatureAppearance sap = stp.getSignatureAppearance();
                if (this.cert.getKey() != null) {
                    sap.setCrypto(this.cert.getKey(), this.cert.getCertificateChain(), null, PdfSignatureAppearance.SELF_SIGNED);
                }
                System.out.println(doc.isRecibo());
                if (doc.isRecibo()) {
                    this.drawSignatureRecibo(stp, sap, doc, reader, this.cert.getCertificateChain());
                } else {
                    this.drawSignature(stp, sap, pages, this.cert.getCertificateChain());
                }
                PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKLITE, new PdfName("adbe.pkcs7.detached"));
                dic.setReason(sap.getReason());
                dic.setContact(sap.getContact());
                dic.setDate(new PdfDate(sap.getSignDate()));
                sap.setCryptoDictionary((PdfDictionary)dic);
                sap.setAcro6Layers(true);
                Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
                sap.setSignDate(calendar);
                int contentEstimated = 15000;
                HashMap<String, String> moreInfo = new HashMap<String, String>();
                moreInfo.put("SigningToolName", "PlataformaSignar");
                moreInfo.put("SigningToolVersion", "1.0");
                stp.setMoreInfo(moreInfo);
                HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
                exc.put(PdfName.CONTENTS, new Integer(contentEstimated * 2 + 2));
                sap.preClose(exc);
                InputStream data = sap.getRangeStream();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] buf = new byte[8192];
                while ((n = data.read(buf)) > 0) {
                    messageDigest.update(buf, 0, n);
                }
                byte[] hash = messageDigest.digest();
                Calendar cal = Calendar.getInstance();
                PdfPKCS7 sgn = new PdfPKCS7(this.cert.getKey(), this.cert.getCertificateChain(), null, messageDigest.getAlgorithm(), null, false);
                byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, null);
                sgn.update(sh, 0, sh.length);
                byte[] encodedSig = sgn.getEncodedPKCS7(hash, cal, null, null);
                if (contentEstimated + 2 < encodedSig.length) {
                    throw new DocumentException("Not enough space.");
                }
                byte[] paddeSig = new byte[contentEstimated];
                System.arraycopy(encodedSig, 0, paddeSig, 0, encodedSig.length);
                PdfDictionary dic2 = new PdfDictionary();
                dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(paddeSig).setHexWriting(true));
                sap.close(dic2);
                this.LOG.log(Level.INFO, "Firma guardada en: " + doc.getFullSignedFilePath());
            }
            catch (BadPasswordException ex) {
                this.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                this.LOG.log(Level.INFO, "Ocurri\u00f3 un error firmando el archivo. BadPass");
                this.principal.documentoInvalido(doc);
            }
            return 0;
        }
        catch (InvalidPdfException e) {
            e.printStackTrace();
            this.mostrarMensaje(e.getMessage(), "error");
            return -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ex.printStackTrace();
            this.mostrarMensaje(ex.getMessage(), "error");
            return -1;
        }
    }

    private void mostrarMensaje(final String mensaje, String tipo) {
        System.out.println(mensaje);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, mensaje);
            }
        });
    }

    private void drawSignatureRecibo(PdfStamper stp, PdfSignatureAppearance sap, Documento doc, PdfReader reader, Certificate[] certChain) throws Exception {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        sap.setSignDate(calendar);
        sap.setAcro6Layers(true);
        sap.setContact("Lyris TI - https://lyris.com.ar");
        PdfPKCS7.X509Name certData = PdfPKCS7.getSubjectFields((X509Certificate)((X509Certificate)certChain[0]));
        SimpleDateFormat formateador = new SimpleDateFormat("dd 'de' MMMM 'de' yyyy", new Locale("ES"));
        String fecha = formateador.format(new Date());
        AcroFields fields = stp.getAcroFields();
        int number_sings = fields.getSignatureNames().size();
        Rectangle rectangle = null;
        String row = null;
        if (number_sings == 0) {
            row = "Firmado digitalmente por " + certData.getField("CN");
            rectangle = new Rectangle((float)this.coordsEmpleador[0], (float)this.coordsEmpleador[1], (float)this.coordsEmpleador[2], (float)this.coordsEmpleador[3]);
        } else if (this.principal.getMetadatos().getModuloRecibos().igualesConfDisconf) {
            row = "Firmado digitalmente por " + certData.getField("CN") + " " + doc.stringConformidad().toLowerCase();
            rectangle = new Rectangle((float)this.coordsEmpleadoConf[0], (float)this.coordsEmpleadoConf[1], (float)this.coordsEmpleadoConf[2], (float)this.coordsEmpleadoConf[3]);
        } else {
            row = "Firmado digitalmente por " + certData.getField("CN");
            rectangle = doc.getEnConformidad() != false ? new Rectangle((float)this.coordsEmpleadoConf[0], (float)this.coordsEmpleadoConf[1], (float)this.coordsEmpleadoConf[2], (float)this.coordsEmpleadoConf[3]) : new Rectangle((float)this.coordsEmpleadoDisconf[0], (float)this.coordsEmpleadoDisconf[1], (float)this.coordsEmpleadoDisconf[2], (float)this.coordsEmpleadoDisconf[3]);
        }
        sap.setReason(row);
        row = String.valueOf(row) + ", " + fecha;
        sap.setLayer2Text(row);
        sap.setVisibleSignature(rectangle, 1, null);
    }

    private void drawSignature(PdfStamper stp, PdfSignatureAppearance sap, int pages, Certificate[] certChain) throws Exception {
        try {
            ArrayList arrayList;
            AcroFields fields = stp.getAcroFields();
            int number_sings = fields.getSignatureNames().size();
            float page_height = PageSize.A4.getHeight();
            float size_width = (PageSize.A4.getWidth() - this.MARGIN * 2.0f - this.PADDING_X * (float)(this.NUMER_ALLOWED_FIRMS_FOR_ROW - 1)) / (float)this.NUMER_ALLOWED_FIRMS_FOR_ROW;
            float const_height = page_height - this.MARGIN - this.TITLE_HEIGHT;
            int rows = number_sings / this.NUMER_ALLOWED_FIRMS_FOR_ROW;
            int column = number_sings % this.NUMER_ALLOWED_FIRMS_FOR_ROW;
            Rectangle rec_sing = new Rectangle(this.MARGIN + (float)column * this.PADDING_X + size_width * (float)column, const_height - this.PADDING_Y * (float)rows - this.ROW_HEIGHT * (float)rows, this.MARGIN + (float)column * this.PADDING_X + size_width * (float)column + size_width, const_height - this.PADDING_Y * (float)rows - this.ROW_HEIGHT * (float)(rows + 1));
            rec_sing.setBorder(15);
            rec_sing.setBorderWidth(2.0f);
            rec_sing.setBorderColor(BaseColor.BLUE);
            rec_sing.setBackgroundColor(BaseColor.YELLOW);
            sap.setAcro6Layers(true);
            sap.setReason(this.razon);
            sap.setLocation("Santa Fe - Argentina");
            sap.setContact("Lyris - Consultor\u00eda TI");
            Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
            sap.setSignDate(calendar);
            PdfPKCS7.X509Name certData = PdfPKCS7.getSubjectFields((X509Certificate)((X509Certificate)certChain[0]));
            String identidad = certData.getField("CN") != null ? certData.getField("CN") : "";
            String cargo = certData.getField("T") != null ? certData.getField("T") : "";
            String politica = certData.getField("O") != null ? certData.getField("O") : "";
            String email = certData.getField("E") != null ? certData.getField("E") : "";
            String row = "Firma - " + String.valueOf(fields.getSignatureNames().size()) + " - " + identidad;
            row = String.valueOf(row) + "   " + cargo + "\n";
            if (this.razon != null && !this.razon.equals("")) {
                row = String.valueOf(row) + this.razon + "\n";
            }
            if ((arrayList = certData.getFieldArray("OU")) == null) {
                row = String.valueOf(row);
            }
            if (arrayList != null) {
                for (String ou : arrayList) {
                    row = String.valueOf(row) + "   " + ou + "\n";
                }
            }
            row = String.valueOf(row) + "   " + politica + "\n";
            row = String.valueOf(row) + "   " + email + "\n";
            sap.setLayer2Text(row);
            if (!this.urlImagen.isEmpty()) {
                Image image = Image.getInstance((String)this.urlImagen);
                image.scaleToFit(10.0f, 10.0f);
                sap.setImage(image);
                sap.setImageScale(0.3f);
            }
            if (number_sings == 0) {
                stp.insertPage(pages + 1, PageSize.A4);
                PdfContentByte over = stp.getOverContent(1);
                BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
                Font font = new Font(bf);
                font.setColor(BaseColor.WHITE);
                over = stp.getOverContent(pages + 1);
                PdfPTable table = new PdfPTable(1);
                table.setWidthPercentage(100.0f);
                table.setTotalWidth(PageSize.A4.getWidth() - 20.0f);
                table.setHeaderRows(1);
                table.getDefaultCell().setBorder(15);
                table.getDefaultCell().setBorderWidth(2.0f);
                table.getDefaultCell().setHorizontalAlignment(3);
                PdfPCell cell_header = new PdfPCell();
                cell_header.setBackgroundColor(new BaseColor(180, 200, 255));
                cell_header.setBorder(0);
                cell_header.setFixedHeight(this.TITLE_HEIGHT);
                cell_header.setVerticalAlignment(5);
                cell_header.setHorizontalAlignment(1);
                Paragraph paragraph = new Paragraph();
                paragraph.add("Firmas del Documento");
                paragraph.setAlignment(5);
                cell_header.addElement((Element)paragraph);
                table.addCell(cell_header);
                table.writeSelectedRows(0, -1, this.MARGIN, page_height - this.MARGIN, over);
                ++pages;
            }
            sap.setVisibleSignature(rec_sing, pages, null);
        }
        catch (Exception ex) {
            this.LOG.log(Level.SEVERE, null, ex);
            this.LOG.log(Level.INFO, "Ocurri\u00f3 un error firmando el archivo.");
            throw new Exception("Ocurri\u00f3 un error firmando el archivo.");
        }
    }

    private int signFile(Documento doc) throws Exception {
        try {
            RelativeDetachedSignature signature = new RelativeDetachedSignature();
            signature.setToSignFilePath(doc.getFullFilePath());
            signature.setSignedFilePath(doc.getFullSignedFilePath());
            signature.setCertificate(this.cert.getCert());
            signature.setPrivateKey(this.cert.getKey());
            signature.setProvider(Security.getProvider(this.principal.getFrame().getProviderDeTokenSeleccionado()));
            signature.create();
            return 0;
        }
        catch (FileNotFoundException e) {
            e.getMessage();
            this.pw.println("5");
            this.fichero.close();
            this.mostrarMensaje("Ocurri\u00f3 un error guardando el archivo de firma. Detalles: " + e.getMessage(), "error");
            return -1;
        }
        catch (Exception ex) {
            this.LOG.log(Level.SEVERE, ex.getMessage());
            this.LOG.log(Level.INFO, "Ocurri\u00f3 un error firmando el archivo.");
            this.mostrarMensaje("Ocurri\u00f3 un error firmando el archivo. Detalles: " + ex.getMessage(), "error");
            return -1;
        }
    }
}

