/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.validation;

import ar.com.lyris.validation.BasicValidation;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ValidationLib {
    private static String filePathOriginal;
    private static String filePathFirma;
    private static String pathLogFile;
    private static final Logger LOG;
    static FileWriter ficheroLog;
    static PrintWriter pw;
    private static String mostrarResultado;

    static {
        LOG = Logger.getLogger(ValidationLib.class.getName());
        ficheroLog = null;
        pw = null;
    }

    public static void main(String[] args) throws IOException {
        try {
            boolean flag;
            System.out.println("Iniciando validador...\n");
            if (args.length < 4) {
                throw new Exception("Faltan par\ufffdmetros");
            }
            filePathOriginal = args[0];
            filePathFirma = args[1];
            pathLogFile = args[2];
            mostrarResultado = args[3];
            System.out.println("Archivo : " + filePathOriginal + "\n");
            System.out.println("Firma: " + filePathFirma + "\n");
            File f = new File(pathLogFile);
            if (!f.exists() && !(flag = f.createNewFile())) {
                LOG.log(Level.INFO, "No se pudo crear el archivo de log: " + pathLogFile);
            }
            ficheroLog = new FileWriter(pathLogFile);
            pw = new PrintWriter(ficheroLog);
            ValidationLib.validar();
        }
        catch (Exception ex) {
            Logger.getLogger(ValidationLib.class.getName()).log(Level.SEVERE, null, ex);
            ValidationLib.mostrarMensaje(ex.getMessage(), "error");
            pw.println("2");
            ficheroLog.close();
            System.exit(0);
        }
    }

    private static void validar() throws IOException {
        BasicValidation validation = new BasicValidation(filePathOriginal, filePathFirma);
        ArrayList<ResultadoValidacion> results = validation.validate();
        ResultadoValidacion result = null;
        Iterator<ResultadoValidacion> it = results.iterator();
        String mensaje = "";
        while (it.hasNext()) {
            result = it.next();
            boolean isValid = result.isValidate();
            if (isValid) {
                String[] arrayCert;
                mensaje = String.valueOf(mensaje) + "La firma es v\ufffdlida.\n";
                String certificado = "" + ((X509Certificate)result.getDatosFirma().getCadenaFirma().getCertificates().get(0)).getSubjectDN();
                mensaje = String.valueOf(mensaje) + "Certificado:\n";
                String[] stringArray = arrayCert = certificado.split(",");
                int n = arrayCert.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    mensaje = String.valueOf(mensaje) + s + ", \n";
                    ++n2;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date fecha = result.getDatosFirma().getFechaFirma();
                String strFecha = sdf.format(fecha);
                mensaje = String.valueOf(mensaje) + "Fecha de la firma: " + strFecha + "\n";
                pw.println("0");
                ficheroLog.close();
                continue;
            }
            mensaje = String.valueOf(mensaje) + "La firma no es v\ufffdlida.\n";
            mensaje = String.valueOf(mensaje) + result.getLog();
            pw.println("1");
            ficheroLog.close();
        }
        if (mostrarResultado.toLowerCase().equals("si")) {
            ValidationLib.mostrarMensaje(mensaje, "info");
        }
    }

    private static void mostrarMensaje(String mensaje, String tipo) {
        if (tipo.equals("error")) {
            JOptionPane.showMessageDialog(null, mensaje, "Firma Digital", 0);
        } else if (tipo.equals("info")) {
            JOptionPane.showMessageDialog(null, mensaje, "Firma Digital", 1);
        }
    }
}

