/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.vistas;

import ar.com.gs.entidades.Certificado;
import ar.com.lyris.controladores.PrincipalBase;
import ar.com.lyris.vistas.BtnAction;
import ar.com.lyris.vistas.ComponentMover;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class DialogCertificados
extends JDialog {
    private static final long serialVersionUID = 1L;
    private PrincipalBase principal;
    ButtonGroup buttonGroup;

    public DialogCertificados(PrincipalBase p) {
        String backgroundColor = "#2669a0";
        this.getRootPane().setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, Color.decode(backgroundColor)));
        this.principal = p;
        List<Certificado> certs = p.getCertController().getCertificados();
        Container contentPane = this.getContentPane();
        p.certificado = certs.get(0);
        this.setUndecorated(true);
        this.setLocationRelativeTo(p.getFrame());
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JPanel titleBar = new JPanel();
        titleBar.setBackground(Color.decode(backgroundColor));
        titleBar.setOpaque(true);
        titleBar.setBorder(null);
        titleBar.setLayout(new BoxLayout(titleBar, 2));
        JLabel titulo = new JLabel("Seleccione el certificado de firma");
        titulo.setForeground(Color.WHITE);
        titulo.setFont(this.principal.getFrame().fontBold);
        titleBar.add(Box.createRigidArea(new Dimension(5, 0)));
        titleBar.add(titulo);
        titleBar.add(Box.createHorizontalGlue());
        new ComponentMover(this, titleBar);
        listPane.add(titleBar);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.setBackground(Color.decode("#ecf0f1"));
        buttonPane.setPreferredSize(new Dimension(0, 32));
        buttonPane.setOpaque(false);
        JButton cancelButton = new JButton("Cancelar");
        cancelButton.setBorder(null);
        cancelButton.setFont(p.getFrame().fontBold);
        cancelButton.addActionListener(new BtnAction(this.principal, this));
        cancelButton.setPreferredSize(new Dimension(100, 32));
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton okButton = new JButton("Aceptar");
        buttonPane.add(okButton);
        okButton.setBorder(null);
        okButton.setFont(p.getFrame().fontBold);
        okButton.setPreferredSize(new Dimension(100, 32));
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new BtnAction(this.principal, this));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        listPane.add(scrollPane);
        Container cont = new Container();
        scrollPane.setViewportView(cont);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.getVerticalScrollBar().setBackground(Color.white);
        cont.setLayout(new BoxLayout(cont, 1));
        this.buttonGroup = new ButtonGroup();
        for (Certificado cert : certs) {
            Panel panel = new Panel();
            cont.add(panel);
            panel.setLayout(new BoxLayout(panel, 1));
            String s = cert.getCert().getSubjectX500Principal().getName();
            s = DialogCertificados.capitalizeString(this.parsear(s, "CN"));
            JRadioButton rdbtnNewRadioButton = new JRadioButton(s);
            rdbtnNewRadioButton.setActionCommand(cert.getAlias());
            rdbtnNewRadioButton.setOpaque(false);
            rdbtnNewRadioButton.setFont(p.getFrame().font);
            panel.add(rdbtnNewRadioButton);
            this.buttonGroup.add(rdbtnNewRadioButton);
            if (this.buttonGroup.getSelection() == null) {
                this.buttonGroup.setSelected(rdbtnNewRadioButton.getModel(), true);
            }
            s = cert.getCert().getIssuerX500Principal().getName();
            System.out.println(s);
            s = String.valueOf(this.parsear(s, "CN")) + ", " + this.parsear(s, "O");
            s = s.length() > 47 ? String.valueOf(s.substring(0, 47)) + "..." : s;
            JLabel lblNewLabel_1 = new JLabel("Emisor: " + s);
            panel.add(lblNewLabel_1);
            JLabel lblNewLabel_2 = new JLabel("Nro Serie: " + cert.getCert().getSerialNumber());
            panel.add(lblNewLabel_2);
            if (cert.getDiasAExpirar() <= 30L) {
                JLabel lblNewLabel_3 = new JLabel("Dias a expirar: " + cert.getDiasAExpirar());
                lblNewLabel_3.setForeground(Color.RED);
                lblNewLabel_3.setText("ADVERTENCIA - " + lblNewLabel_3.getText());
                panel.add(lblNewLabel_3);
            }
            JSeparator separator = new JSeparator();
            cont.add(separator);
        }
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.pack();
        this.setLocationByPlatform(true);
    }

    private String parsear(String name, String pre) {
        String[] campos = name.split(",");
        int i = 0;
        while (i < campos.length) {
            if (campos[i].contains(String.valueOf(pre) + "=")) {
                return campos[i].replace(String.valueOf(pre) + "=", "");
            }
            ++i;
        }
        return null;
    }

    public static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        int i = 0;
        while (i < chars.length) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
            } else if (Character.isWhitespace(chars[i]) || chars[i] == '.' || chars[i] == '\'') {
                found = false;
            }
            ++i;
        }
        return String.valueOf(chars);
    }
}

