/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.entidades;

import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import java.io.File;
import java.util.HashMap;

public class Documento {
    private String id;
    private EstadoDoc estado;
    private File archivo;
    private String rutaArchivoDestino;
    private int tipoFirma;
    private String path;
    public static int FIRMA_XML = 1;
    public static int FIRMA_PDF = 0;
    private String additionalField;
    private HashMap<String, String> additionalFieldValues;
    private String nombreVisible;

    public Documento() {
        this.estado = EstadoDoc.EN_ESPERA;
        this.archivo = null;
    }

    public Documento(String id, File file) {
        this.id = id;
        this.estado = EstadoDoc.CARGADO;
        this.archivo = file;
    }

    public Documento(String id2) {
        this.estado = EstadoDoc.EN_ESPERA;
        this.id = id2;
    }

    public String getFileName() {
        if (this.archivo != null) {
            return this.archivo.getName();
        }
        return this.id;
    }

    public String getFileNameWithoutExt() {
        return this.archivo.getName().substring(0, this.archivo.getName().length() - 4);
    }

    public String getFullFilePath() {
        return String.valueOf(this.getFilePath()) + File.separator + this.getFileName();
    }

    public String getFullSignedFilePath() {
        return this.rutaArchivoDestino;
    }

    public String getFilePath() {
        if (this.archivo == null) {
            return null;
        }
        return this.archivo.getParentFile().getPath();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String did) {
        this.id = did;
    }

    public EstadoDoc getEstado() {
        return this.estado;
    }

    public void setEstado(EstadoDoc estado) {
        this.estado = estado;
    }

    public File getArchivo() {
        return this.archivo;
    }

    public void setArchivo(File archivo) {
        this.archivo = archivo;
        if (archivo.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            this.setTipoFirma(FIRMA_PDF);
        } else {
            this.setTipoFirma(FIRMA_XML);
        }
    }

    public void imprimirPorConsola() {
        System.out.println("Documento: " + this.id + "/ Nombre: " + this.archivo.getName());
        System.out.println("Estado: " + (Object)((Object)this.estado));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Documento other = (Documento)obj;
        return this.id == other.id;
    }

    public void setearCarpetaDestino(String absolutePath, boolean sufijo) {
        String pathDestino = String.valueOf(absolutePath) + File.separator + this.getFileName();
        if (sufijo || pathDestino.equals(this.archivo.getAbsolutePath())) {
            this.rutaArchivoDestino = pathDestino.replace(".pdf", "-f.pdf");
            return;
        }
        this.rutaArchivoDestino = pathDestino;
    }

    public void setearCarpetaDestino(String absolutePath) {
        if (this.tipoFirma == FIRMA_XML) {
            this.rutaArchivoDestino = String.valueOf(absolutePath) + File.separator + this.getFileNameWithoutExt() + ".xml";
        }
        if (this.tipoFirma == FIRMA_PDF) {
            this.rutaArchivoDestino = String.valueOf(absolutePath) + File.separator + this.getFileName();
        }
    }

    public int getTipoFirma() {
        return this.tipoFirma;
    }

    public void setTipoFirma(int tipoFirma) {
        this.tipoFirma = tipoFirma;
    }

    public String getRemotePath() {
        return this.path;
    }

    public void setRemotePath(String path) {
        this.path = path;
    }

    public String getAdditionalField() {
        return this.additionalField;
    }

    public void setAdditionalField(String additionalField) {
        this.additionalField = additionalField;
        this.additionalFieldValues = new HashMap();
    }

    public HashMap<String, String> getAdditionalFieldValues() {
        return this.additionalFieldValues;
    }

    public void setAdditionalFieldValues(HashMap<String, String> additionalFieldValues) {
        this.additionalFieldValues = additionalFieldValues;
    }

    public void addAdditionalFieldValues(String key, String asString) {
        this.additionalFieldValues.put(key, asString);
    }

    public String getNombreVisible() {
        return this.nombreVisible;
    }

    public void setNombreVisible(String nombreVisible) {
        this.nombreVisible = nombreVisible;
    }
}

