/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.firma;

import ar.com.gs.controladores.CertController;
import ar.com.gs.entidades.Certificado;
import ar.com.lyris.signarStandalone.entidades.ConfigFirmaPDF;
import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarStandalone.firma.RelativeDetachedSignature;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.ConfigFirmaController;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import ar.com.lyris.signarestandalone.controladores.WorkerFirmado;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignature;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class SignerLib {
    private List<Documento> documentos;
    private String razon;
    private int NUMER_ALLOWED_FIRMS_FOR_ROW = 1;
    private float PADDING_X = 3.0f;
    private float PADDING_Y = 3.0f;
    private float MARGIN = 10.0f;
    private float ROW_HEIGHT = 48.0f;
    private float TITLE_HEIGHT = 20.0f;
    public static Certificado cert;
    private Principal principal;
    private String providerToken;
    private WorkerFirmado wFirmado = WorkerFirmado.getInstance();
    private ConfigFirmaPDF configPDF;
    private ConfigFirmaController configFirmaController;
    private String carpetaDestino;

    public SignerLib() {
        this.principal = Principal.getInstance();
        this.configFirmaController = ConfigFirmaController.getInstance();
    }

    public int firmarConCertificado(Certificado certificado) throws Exception {
        int r = 0;
        try {
            this.cargarDatosGenerales();
            cert = certificado;
            this.providerToken = this.principal.getProviderDeTokenSeleccionado();
            int n = r = this.firmar();
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mostrarMensaje(ex.getMessage(), "error");
            r = -1;
            return -1;
        }
        finally {
            try {
                return r;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void cargarDatosGenerales() throws Exception {
        if (Principal.EJECUTA_ESQUEMA) {
            this.razon = this.configFirmaController.getConfigFirma().getRazon();
            this.carpetaDestino = System.getProperty("java.io.tmpdir");
            if (CertController.SO == 1) {
                this.carpetaDestino = this.carpetaDestino.substring(0, this.carpetaDestino.length() - 1);
            }
        } else {
            String string = this.razon = Consola.razonMessage.equals(this.principal.getFrame().getRazonText()) ? "" : this.principal.getFrame().getRazonText();
            if (!this.principal.getFrame().carpetaDestino.isDirectory()) {
                new Exception("la ruta de destino no es una carpeta valida.");
            } else {
                this.carpetaDestino = this.principal.getFrame().carpetaDestino.getAbsolutePath();
            }
        }
        this.documentos = this.principal.getDocumentos();
        System.out.println(this.razon);
    }

    private int firmar() throws Exception {
        EsquemaController esquemaCont = EsquemaController.getInstance();
        int r = 0;
        String texto = "";
        int cantidad = 0;
        for (Documento doc : this.documentos) {
            r = 0;
            doc.setEstado(EstadoDoc.FIRMANDO);
            esquemaCont.calcularDerivables(doc);
            if (esquemaCont.derivablesContiene("reason")) {
                String key = esquemaCont.getDerivable("reason");
                this.razon = esquemaCont.parseDerivable(key, doc.getAdditionalFieldValues());
            }
            this.wFirmado.publicarFirmando(doc.getId());
            r = doc.getTipoFirma() == Documento.FIRMA_PDF ? this.signPdf(doc) : this.signFile(doc);
            if (r == 0) {
                ++cantidad;
                texto = String.valueOf(texto) + doc.getFullSignedFilePath() + "\n";
                doc.setEstado(EstadoDoc.FIRMADO);
                doc.imprimirPorConsola();
            } else {
                doc.setEstado(EstadoDoc.INVALIDO);
            }
            this.wFirmado.publicarFirmado(doc.getId());
        }
        texto = "Se firmaron " + cantidad + " archivos:\n" + texto;
        System.out.println(texto);
        return r;
    }

    private int signFile(Documento doc) throws Exception {
        try {
            RelativeDetachedSignature signature = new RelativeDetachedSignature();
            doc.setearCarpetaDestino(this.carpetaDestino);
            signature.setToSignFilePath(doc.getFullFilePath());
            signature.setSignedFilePath(doc.getFullSignedFilePath());
            signature.setCertificate(cert.getCert());
            signature.setPrivateKey(cert.getKey());
            signature.setProvider(Security.getProvider(this.providerToken));
            signature.create();
        }
        catch (FileNotFoundException e) {
            e.getMessage();
            e.printStackTrace();
            throw new Exception("Ocurri\u00f3 un error guardando el archivo de firma.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Ocurri\u00f3 un error firmando el archivo.");
        }
        return 0;
    }

    private int signPdf(Documento doc) throws Exception {
        try {
            this.configPDF = ConfigFirmaPDF.getInstance();
            PdfReader.unethicalreading = true;
            PdfReader reader = new PdfReader(doc.getFullFilePath());
            doc.setearCarpetaDestino(this.carpetaDestino, this.configPDF.isAgregarSufijoArchivoFirmado());
            try {
                int n;
                FileOutputStream fout = new FileOutputStream(doc.getFullSignedFilePath());
                PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)'\u0000', null, (boolean)true);
                PdfSignatureAppearance sap = stp.getSignatureAppearance();
                HashMap<String, String> moreInfo = reader.getInfo() != null ? reader.getInfo() : new HashMap<String, String>();
                moreInfo.put("SigningToolName", "SignarStandalone");
                moreInfo.put("SigningToolVersion", "V2.7.20");
                stp.setMoreInfo(moreInfo);
                X500Name x500name = new JcaX509CertificateHolder(cert.getCert()).getSubject();
                RDN cn = x500name.getRDNs(BCStyle.CN)[0];
                if (this.razon != null && cn.getFirst().getValue() != null) {
                    String cnString = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
                    this.razon = this.configFirmaController.replaceReservedWords(this.razon, cnString);
                }
                if (cert.getKey() != null) {
                    sap.setCrypto(cert.getKey(), cert.getCertificateChain(), null, PdfSignatureAppearance.SELF_SIGNED);
                }
                if (this.configPDF.getModoFirmado() != 0) {
                    this.drawSignature(stp, sap, reader, cert.getCertificateChain(), doc);
                }
                PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKLITE, new PdfName("adbe.pkcs7.detached"));
                dic.setReason(this.razon);
                dic.setLocation(sap.getLocation());
                dic.setContact(sap.getContact());
                dic.setDate(new PdfDate(sap.getSignDate()));
                sap.setCryptoDictionary((PdfDictionary)dic);
                Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
                sap.setSignDate(calendar);
                int contentEstimated = 15000;
                HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
                exc.put(PdfName.CONTENTS, new Integer(contentEstimated * 2 + 2));
                sap.preClose(exc);
                InputStream data = sap.getRangeStream();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] buf = new byte[8192];
                while ((n = data.read(buf)) > 0) {
                    messageDigest.update(buf, 0, n);
                }
                byte[] hash = messageDigest.digest();
                Calendar cal = Calendar.getInstance();
                PdfPKCS7 sgn = new PdfPKCS7(cert.getKey(), cert.getCertificateChain(), null, messageDigest.getAlgorithm(), null, false);
                byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, null);
                sgn.update(sh, 0, sh.length);
                byte[] encodedSig = sgn.getEncodedPKCS7(hash, cal, null, null);
                if (contentEstimated + 2 < encodedSig.length) {
                    throw new DocumentException("Not enough space.");
                }
                byte[] paddeSig = new byte[contentEstimated];
                System.arraycopy(encodedSig, 0, paddeSig, 0, encodedSig.length);
                PdfDictionary dic2 = new PdfDictionary();
                dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(paddeSig).setHexWriting(true));
                sap.close(dic2);
            }
            catch (BadPasswordException ex) {
                this.principal.documentoInvalido(doc);
            }
            return 0;
        }
        catch (InvalidPdfException e) {
            e.printStackTrace();
            this.mostrarMensaje(e.getMessage(), "error");
            return -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mostrarMensaje(ex.getMessage(), "error");
            return -1;
        }
    }

    private void mostrarMensaje(String mensaje, String tipo) {
        System.out.println(mensaje);
        this.principal.getFrame().informarFallo(mensaje);
    }

    private void drawSignature(PdfStamper stp, PdfSignatureAppearance sap, PdfReader reader, Certificate[] certChain, Documento doc) throws Exception {
        int pages;
        Rectangle rec_sing = null;
        int selectedPage = pages = reader.getNumberOfPages();
        String selectedFont = "Helvetica";
        if (this.configPDF.getFont() != null) {
            selectedFont = this.configPDF.getFont().equals("Courier") ? "Courier" : (this.configPDF.getFont().equals("Helvetica") ? "Helvetica" : "Times");
        }
        Font font = FontFactory.getFont((String)selectedFont);
        try {
            if (this.configPDF.getModoFirmado() == 1) {
                ArrayList arrayList;
                Map moreInfo = stp.getMoreInfo();
                boolean existeHojaDeFirma = moreInfo.get("hoja-de-firmas_cantidad-de-firmas") != null;
                int cantFirmasEnHojaDeFirma = existeHojaDeFirma ? Integer.parseInt((String)moreInfo.get("hoja-de-firmas_cantidad-de-firmas")) : 0;
                float page_height = PageSize.A4.getHeight();
                float size_width = (PageSize.A4.getWidth() - this.MARGIN * 2.0f - this.PADDING_X * (float)(this.NUMER_ALLOWED_FIRMS_FOR_ROW - 1)) / (float)this.NUMER_ALLOWED_FIRMS_FOR_ROW;
                float const_height = page_height - this.MARGIN - this.TITLE_HEIGHT;
                int rows = cantFirmasEnHojaDeFirma / this.NUMER_ALLOWED_FIRMS_FOR_ROW;
                int column = cantFirmasEnHojaDeFirma % this.NUMER_ALLOWED_FIRMS_FOR_ROW;
                rec_sing = new Rectangle(this.MARGIN + (float)column * this.PADDING_X + size_width * (float)column, const_height - this.PADDING_Y * (float)rows - this.ROW_HEIGHT * (float)rows, this.MARGIN + (float)column * this.PADDING_X + size_width * (float)column + size_width, const_height - this.PADDING_Y * (float)rows - this.ROW_HEIGHT * (float)(rows + 1));
                rec_sing.setBorder(15);
                rec_sing.setBorderWidth(2.0f);
                rec_sing.setBorderColor(BaseColor.BLUE);
                rec_sing.setBackgroundColor(BaseColor.YELLOW);
                sap.setAcro6Layers(true);
                sap.setReason(this.razon);
                sap.setLocation("Santa Fe - Argentina");
                sap.setContact("Lyris - Consultor\u00eda TI");
                Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
                sap.setSignDate(calendar);
                PdfPKCS7.X509Name certData = PdfPKCS7.getSubjectFields((X509Certificate)((X509Certificate)certChain[0]));
                String identidad = certData.getField("CN") != null ? certData.getField("CN") : "";
                String cargo = certData.getField("T") != null ? certData.getField("T") : "";
                String email = certData.getField("E") != null ? certData.getField("E") : "";
                String serie = certData.getField("SERIALNUMBER") != null ? " - " + certData.getField("SERIALNUMBER") : "";
                String row = String.valueOf(String.valueOf(cantFirmasEnHojaDeFirma + 1)) + " - " + identidad + serie;
                row = String.valueOf(row) + "   " + cargo + "\n";
                if (this.razon != null && !this.razon.equals("")) {
                    row = String.valueOf(row) + this.razon + "\n";
                }
                if ((arrayList = certData.getFieldArray("OU")) == null) {
                    row = String.valueOf(row);
                }
                if (arrayList != null) {
                    for (String ou : arrayList) {
                        row = String.valueOf(row) + "   " + ou + "\n";
                    }
                }
                row = String.valueOf(row) + "   " + email + "\n";
                sap.setLayer2Text(row);
                if (!existeHojaDeFirma) {
                    stp.insertPage(pages + 1, PageSize.A4);
                    PdfContentByte over = stp.getOverContent(1);
                    sap.setLayer2Font(font);
                    over = stp.getOverContent(pages + 1);
                    PdfPTable table = new PdfPTable(1);
                    table.setWidthPercentage(100.0f);
                    table.setTotalWidth(PageSize.A4.getWidth() - 20.0f);
                    table.setHeaderRows(1);
                    table.getDefaultCell().setBorder(15);
                    table.getDefaultCell().setBorderWidth(2.0f);
                    table.getDefaultCell().setHorizontalAlignment(3);
                    PdfPCell cell_header = new PdfPCell();
                    cell_header.setBorder(1);
                    cell_header.setFixedHeight(this.TITLE_HEIGHT);
                    cell_header.setVerticalAlignment(5);
                    cell_header.setHorizontalAlignment(1);
                    Paragraph paragraph = new Paragraph();
                    paragraph.setFont(font);
                    paragraph.add("Firmas del Documento");
                    paragraph.setAlignment(5);
                    cell_header.addElement((Element)paragraph);
                    table.addCell(cell_header);
                    table.writeSelectedRows(0, -1, this.MARGIN, page_height - this.MARGIN, over);
                    ++pages;
                } else if (cantFirmasEnHojaDeFirma + 1 == 16) {
                    row = "El resto de firmas se puede ver en la pesta\u00f1a de firmas";
                    sap.setLayer2Text(row);
                }
                moreInfo.put("hoja-de-firmas_cantidad-de-firmas", String.valueOf(++cantFirmasEnHojaDeFirma));
                stp.setMoreInfo(moreInfo);
                if (cantFirmasEnHojaDeFirma <= 16) {
                    sap.setVisibleSignature(rec_sing, pages, null);
                }
            } else {
                sap.setAcro6Layers(true);
                PdfPKCS7.X509Name certData = PdfPKCS7.getSubjectFields((X509Certificate)((X509Certificate)certChain[0]));
                int n = selectedPage = this.configPDF.getHojaAfirmar() == -1 ? pages : this.configPDF.getHojaAfirmar();
                if (selectedPage > pages) {
                    selectedPage = pages;
                }
                Rectangle pageSize = reader.getPageSize(selectedPage);
                float height = pageSize.getHeight();
                float width = pageSize.getWidth();
                float signatureHeight = 35.0f;
                float signatureWidth = 200.0f;
                int marginHor = this.configPDF.getMarginHor();
                int marginVer = this.configPDF.getMarginVer();
                float marginY = height * (float)marginVer / 100.0f;
                float marginX = width * (float)marginHor / 100.0f;
                int ubicacion = this.configPDF.getUbicacionFirma();
                if (this.configPDF.getCoordenadas() != null) {
                    int[] coords = this.configPDF.getCoordenadas();
                    rec_sing = new Rectangle((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3]);
                } else if (EsquemaController.getInstance().derivablesContiene("coordinates")) {
                    String coordsKey = EsquemaController.getInstance().getDerivable("coordinates");
                    String finalCoords = EsquemaController.getInstance().parseDerivable(coordsKey, doc.getAdditionalFieldValues());
                    finalCoords = finalCoords.substring(1, finalCoords.length() - 1);
                    int[] coords = Arrays.stream(finalCoords.split(",")).mapToInt(Integer::parseInt).toArray();
                    rec_sing = new Rectangle((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3]);
                } else {
                    switch (ubicacion) {
                        case 0: {
                            rec_sing = new Rectangle(0.0f + marginX, height - marginY - signatureHeight, 0.0f + marginX + signatureWidth, height - marginY);
                            break;
                        }
                        case 1: {
                            rec_sing = new Rectangle(width / 2.0f - signatureWidth / 2.0f, height - marginY - signatureHeight, width / 2.0f + signatureWidth / 2.0f, height - marginY);
                            break;
                        }
                        case 2: {
                            rec_sing = new Rectangle(width - marginX - signatureWidth, height - marginY - signatureHeight, width - marginX, height - marginY);
                            break;
                        }
                        case 3: {
                            rec_sing = new Rectangle(0.0f + marginX, 0.0f + marginY, 0.0f + marginX + signatureWidth, 0.0f + marginY + signatureHeight);
                            break;
                        }
                        case 4: {
                            rec_sing = new Rectangle(width / 2.0f - signatureWidth / 2.0f, 0.0f + marginY, width / 2.0f + signatureWidth / 2.0f, 0.0f + marginY + signatureHeight);
                            break;
                        }
                        case 5: {
                            rec_sing = new Rectangle(width - marginX - signatureWidth, 0.0f + marginY, width - marginX, 0.0f + marginY + signatureHeight);
                        }
                    }
                }
                String row = null;
                SimpleDateFormat formateador = new SimpleDateFormat("dd 'de' MMMM 'de' yyyy", new Locale("ES"));
                String fecha = formateador.format(new Date());
                if (!Principal.EJECUTA_ESQUEMA) {
                    row = "Firmado digitalmente por " + certData.getField("CN") + "\n";
                    if (this.razon != null && !this.razon.equals("")) {
                        row = String.valueOf(row) + this.razon + "\n";
                    }
                    sap.setReason(row);
                    row = String.valueOf(row) + fecha;
                } else {
                    row = this.razon;
                }
                sap.setLayer2Font(font);
                sap.setLayer2Text(row);
            }
            sap.setVisibleSignature(rec_sing, selectedPage, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Ocurri\u00f3 un error firmando el archivo.");
        }
    }
}

