/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.vistas;

import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public final class ProgressWorker
extends SwingWorker<Void, Integer> {
    private static ProgressWorker progressWorker;
    private JProgressBar pb;
    private Principal principal = Principal.getInstance();
    int delay = 1000;
    int index = 0;
    int nroDocs = 0;
    int maxParcial = 10;
    int maxParcialAnterior = 10;

    private ProgressWorker() {
    }

    public static ProgressWorker getInstance() {
        if (progressWorker == null) {
            progressWorker = new ProgressWorker();
        }
        return progressWorker;
    }

    @Override
    protected void process(List<Integer> chunks) {
        if (!this.isDone()) {
            this.pb.setValue(chunks.get(chunks.size() - 1));
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (this.pb.getValue() < 99) {
            int n = this.delay = this.principal.getCantDocumentos() >= 4 ? 4000 : 1000 * (this.principal.getCantDocumentos() + 1);
            if (this.principal.getCantDocumentos() != 0) {
                this.logicaDeProgreso();
            }
            if (this.index < this.maxParcial) {
                ++this.index;
                this.publish(this.index);
            }
            Thread.sleep(this.delay);
        }
        return null;
    }

    private void logicaDeProgreso() {
        this.nroDocs = this.principal.getCantDocEnEstados(EstadoDoc.INVALIDO, this.principal.estadoApp.getEstadoCompleto());
        if (this.principal.getCantDocumentos() <= 0) {
            return;
        }
        this.maxParcial = 100 / this.principal.getCantDocumentos() * (this.nroDocs + 1);
        if (this.maxParcial != this.maxParcialAnterior) {
            this.index = 100 / this.principal.getCantDocumentos() * this.nroDocs;
            this.maxParcialAnterior = this.maxParcial;
        }
    }

    public void refrescarSinDelay() {
        this.logicaDeProgreso();
        this.publish(this.index);
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            System.out.println("Cancelado correctamente. no es error");
        }
    }

    public void setPBar() {
        this.pb = this.principal.getFrame().progressBar;
        this.pb.setValue(0);
    }

    public void finalizarProgressWorker() {
    }
}

