/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.AdditionalField;
import ar.com.lyris.signarStandalone.entidades.ConfigFirmaPDF;
import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoApp;
import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.ConfigFirmaController;
import ar.com.lyris.signarestandalone.controladores.DestinationsController;
import ar.com.lyris.signarestandalone.controladores.GuiController;
import ar.com.lyris.signarestandalone.controladores.OriginsController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.bouncycastle.util.encoders.Hex;

public class EsquemaController {
    public static volatile EsquemaController esquemaController;
    static final Pattern PatronVarPeso;
    static final Pattern PatronVarAmpersand;
    private OriginsController originsController;
    private DestinationsController destinationsController;
    private ConfigFirmaController configFirmaController;
    private File esquema;
    private String esquemaURL;
    private HashMap<String, String> sharedHeaders;
    private JsonObject parametros;
    private ConfigFirmaPDF configFirmaPDF;
    private boolean unirestIniciado = false;
    public static boolean ESQUEMA_EN_TEST;
    private HashMap<String, String> defaultHeaders;
    private HashMap<String, String> derivables = new HashMap();
    private GuiController guiController;
    private AdditionalField additionalField;

    static {
        PatronVarPeso = Pattern.compile("\\$\\{(\\w+)\\}");
        PatronVarAmpersand = Pattern.compile("\\&\\{(\\w+)\\}");
        ESQUEMA_EN_TEST = false;
    }

    private EsquemaController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EsquemaController getInstance() {
        if (esquemaController != null) return esquemaController;
        Class<EsquemaController> clazz = EsquemaController.class;
        synchronized (EsquemaController.class) {
            if (esquemaController != null) return esquemaController;
            esquemaController = new EsquemaController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esquemaController;
        }
    }

    public void inicializar() throws Exception {
        JsonObject esquemaJson;
        if (!this.existeEsquema()) {
            this.descargarEsquema();
        }
        if (this.firmaEsquemaEsValida(esquemaJson = JSONUtils.parsearJson(this.esquema))) {
            JsonObject data = esquemaJson.getAsJsonObject("data");
            if (data.get("additionalFields") != null) {
                this.guiController = GuiController.getInstance();
                this.additionalField = (AdditionalField)new Gson().fromJson(data.get("additionalFields").getAsJsonArray().get(0), AdditionalField.class);
                this.guiController.procesarAdditionalFields(this.additionalField);
            }
            this.configUnirest();
            this.parseHeaders(data.getAsJsonObject("sharedHeaders"));
            if (data.get("signatureType").getAsString().equals("PDF")) {
                this.configFirmaController = ConfigFirmaController.getInstance();
                this.configFirmaController.procesarFirmaPDF(data.getAsJsonObject("pdfSignatureConfig"));
            }
            if (data.get("certConfig") != null) {
                this.configFirmaController = ConfigFirmaController.getInstance();
                this.procesarCertConfig(data.getAsJsonObject("certConfig"));
            }
            if (data.get("fileOrigins") != null) {
                this.originsController = OriginsController.getInstance();
                this.originsController.procesarOrigenes(data.getAsJsonObject("fileOrigins"));
                Consola.getInstance().cargarTabla();
                this.ejecutarOrigen();
            }
            if (data.get("fileDestination") != null) {
                this.destinationsController = DestinationsController.getInstance();
                this.destinationsController.procesarDestinos(data.getAsJsonObject("fileDestination"));
            }
            if (data.get("interfaz") != null) {
                this.guiController = GuiController.getInstance();
                this.guiController.procesarInterfaz(data.getAsJsonObject("interfaz"));
            }
            Consola.getInstance().informarEsquemaCargado();
        } else {
            Principal.getInstance().informarProblemaIrrecuperable("No se pudo verificar la autenticidad del esquema", "Error irrecuperable");
        }
    }

    private void configUnirest() {
        if (!this.unirestIniciado) {
            Unirest.config().followRedirects(false).enableCookieManagement(false);
        }
        this.unirestIniciado = true;
        this.defaultHeaders = new HashMap();
        this.defaultHeaders.put("Accept", "application/json");
        this.defaultHeaders.put("User-Agent", "SignarStandaloneV2.7.20");
    }

    private void parseHeaders(JsonObject data) {
        if (data == null) {
            return;
        }
        if (this.sharedHeaders == null) {
            this.sharedHeaders = JSONUtils.asHashMap(data);
            this.sharedHeaders.forEach((key, value) -> {
                String newValue = value;
                if (PatronVarPeso.matcher((CharSequence)value).find()) {
                    newValue = esquemaController.parseParameters((String)value);
                }
                Unirest.config().setDefaultHeader(key, newValue);
            });
        }
    }

    private void procesarCertConfig(JsonObject certConfig) {
        String certConfigParsed;
        boolean tokenOnly;
        String locationString = null;
        locationString = certConfig.get("certificateLocation").isJsonArray() ? certConfig.get("certificateLocation").getAsJsonArray().toString() : certConfig.get("certificateLocation").getAsString();
        if (PatronVarPeso.matcher(locationString).find()) {
            locationString = this.parseParameters(locationString);
        }
        if (tokenOnly = locationString.equals("[\"HWTOKEN\"]")) {
            this.configFirmaController.setExcluyenteTokenHard();
            return;
        }
        if (locationString.toLowerCase().contains("hwtoken")) {
            this.configFirmaController.agregarTokenHWUbicdeCert();
        }
        if (locationString.toLowerCase().contains("mscapi")) {
            this.configFirmaController.configurarMSCAPI();
        }
        if (locationString.toLowerCase().contains("ask")) {
            this.configFirmaController.habilitarCertificadoLocal();
        }
        if (locationString.toLowerCase().contains("path") && certConfig.get("customPath") != null && (certConfigParsed = this.parseParameters(certConfig.get("customPath").getAsString())) != null && !certConfigParsed.isEmpty()) {
            this.configFirmaController.configurarPathCertificado(this.parseParameters(certConfig.get("customPath").getAsString()));
        }
    }

    private boolean firmaEsquemaEsValida(JsonObject esquemaJson) {
        Boolean templateEnTest = esquemaJson.getAsJsonPrimitive("templateVersion").getAsString().equals("test");
        if (templateEnTest.booleanValue()) {
            JsonObject data = esquemaJson.getAsJsonObject("data").getAsJsonObject("template");
            ESQUEMA_EN_TEST = templateEnTest;
            return true;
        }
        JsonObject data = esquemaJson.getAsJsonObject("data");
        JsonPrimitive signature = esquemaJson.getAsJsonPrimitive("signature");
        try {
            PublicKey pubKey = this.cargarPubKey();
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(pubKey);
            publicSignature.update(JSONUtils.toFullString(data).getBytes(Charset.forName("UTF-8")));
            byte[] signatureBytes = Base64.getDecoder().decode(signature.getAsString());
            boolean resultado = publicSignature.verify(signatureBytes);
            if (resultado) {
                return this.chequearExpiration(data.getAsJsonObject("template"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private boolean chequearExpiration(JsonObject template) {
        return System.currentTimeMillis() <= Long.parseLong(template.get("expiration").getAsString());
    }

    private PublicKey cargarPubKey() throws IOException, URISyntaxException, NoSuchAlgorithmException, InvalidKeySpecException {
        InputStream is = EsquemaController.class.getResourceAsStream("/firma/pkey.pub");
        String pubKeyString = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        byte[] publicBytes = Base64.getDecoder().decode(pubKeyString);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new X509EncodedKeySpec(publicBytes));
    }

    private void descargarEsquema() throws Exception {
        this.configUnirest();
        GetRequest request = Unirest.get((String)this.esquemaURL);
        System.out.println("preparing 'GET' request to URL : " + request.getUrl());
        HttpResponse response = request.asBytes();
        System.out.println(response.getStatus());
        if (response.getStatus() == 200) {
            String dirName = String.valueOf(System.getProperty("user.home")) + File.separator + ".lyris";
            File theDir = new File(dirName);
            if (!theDir.exists()) {
                System.out.println("creating directory: " + dirName);
                try {
                    theDir.mkdir();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            File f = new File(this.getLocalAbsolutePath());
            ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream((byte[])response.getBody()));
            try {
                String inputLine;
                FileOutputStream fos = new FileOutputStream(f);
                fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
                fos.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])response.getBody())));
                StringBuffer responseFile = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    responseFile.append(inputLine);
                }
                in.close();
                this.esquema = f;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new Exception("No se encontr\u00f3 el recurso web, no se puede continuar.");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception("Hubo un problema descargando los datos del recurso.");
            }
        }
    }

    private boolean existeEsquema() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        File f = new File(this.getLocalAbsolutePath());
        if (f.exists()) {
            this.esquema = f;
            return true;
        }
        return false;
    }

    private String getLocalAbsolutePath() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String dir = System.getProperty("user.home");
        int index = this.esquemaURL.indexOf(63);
        String urlBase = this.esquemaURL.substring(0, index >= 0 ? index : this.esquemaURL.length());
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(urlBase.getBytes(StandardCharsets.UTF_8));
        String sha256hex = new String(Hex.encode((byte[])hash));
        return String.valueOf(dir) + "/.lyris/" + sha256hex + ".json";
    }

    public void setUrlEsquema(String url) throws URISyntaxException, MalformedURLException {
        URL u = new URL(url);
        u.toURI();
        this.esquemaURL = url;
    }

    public void setParameters(String params) throws Exception {
        if (!JSONUtils.isJSONValid(params)) {
            throw new Exception("Los parametros no coinciden con JSON bien formado");
        }
        this.parametros = JSONUtils.parsearJson(params);
    }

    public String parseParameters(String element) {
        Matcher m = PatronVarPeso.matcher(element);
        String variable = "";
        while (m.find()) {
            variable = m.group(0);
            if (this.parametros.get(variable = variable.substring(2, variable.length() - 1)).isJsonArray()) {
                element = element.replace("${" + variable + "}", this.parametros.get(variable).getAsJsonArray().toString());
                continue;
            }
            if (!this.parametros.get(variable).isJsonNull()) {
                element = element.replace("${" + variable + "}", this.parametros.get(variable).getAsString());
                continue;
            }
            return null;
        }
        return element;
    }

    public JsonArray parseArrayParameters(String element) {
        Matcher m = PatronVarPeso.matcher(element);
        String variable = "";
        if (m.find()) {
            variable = m.group(0);
            variable = variable.substring(2, variable.length() - 1);
        }
        return this.parametros.get(variable).getAsJsonArray();
    }

    public void ejecutarOrigen() {
        if (this.originsController.getMetodoEjecucion() == 0) {
            this.originsController.iniciarDescarga();
        }
    }

    public ConfigFirmaPDF getConfigFirma() {
        return this.configFirmaPDF;
    }

    public void finFirmado() {
        if (this.destinationsController.metodoEjecucion == 0) {
            Principal.getInstance().setEstadoApp(EstadoApp.SUBIENDO);
            this.destinationsController.iniciarSubida();
        }
    }

    public HashMap<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void agregarDerivable(String clave, String valor) {
        this.derivables.put(clave, valor);
    }

    public HashMap<String, String> getDerivables() {
        return this.derivables;
    }

    public boolean derivablesContiene(String string) {
        if (string.contains("&")) {
            Iterator<String> it = this.derivables.keySet().iterator();
            while (it.hasNext()) {
                if (!it.next().startsWith(string)) continue;
                return true;
            }
        }
        return this.derivables.containsKey(string);
    }

    public String getDerivable(String string) {
        return this.derivables.get(string);
    }

    public void calcularDerivables(Documento doc) {
        String afDelDoc = doc.getAdditionalField();
        if (afDelDoc == null) {
            return;
        }
        JsonObject opcionesCampos = this.additionalField.getValues().get(afDelDoc).getAsJsonObject();
        Set keys = opcionesCampos.get("set").getAsJsonObject().keySet();
        for (String key : keys) {
            String cleanValue = this.parseParameters(opcionesCampos.get("set").getAsJsonObject().get(key).getAsString());
            doc.addAdditionalFieldValues(key, cleanValue);
        }
        System.out.println();
    }

    public String parseDerivable(String key, HashMap<String, String> additionalFieldValues) {
        Matcher m = PatronVarAmpersand.matcher(key);
        String variable = "";
        while (m.find()) {
            variable = m.group(0);
            variable = variable.substring(2, variable.length() - 1);
        }
        return key.replace("&{" + variable + "}", additionalFieldValues.get(variable));
    }

    public String getFullKeyDerivable(String string) {
        if (string.contains("&")) {
            for (String value : this.derivables.keySet()) {
                if (!value.startsWith(string)) continue;
                return value;
            }
        }
        return string;
    }
}

