/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.AdditionalField;
import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GuiController {
    public static volatile GuiController guiController;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    private Consola consola;
    private ArrayList<String> nombresDeCamposAdicionales;

    private GuiController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GuiController getInstance() {
        if (guiController != null) return guiController;
        Class<GuiController> clazz = GuiController.class;
        synchronized (GuiController.class) {
            if (guiController != null) return guiController;
            guiController = new GuiController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return guiController;
        }
    }

    public void procesarInterfaz(JsonObject interfaz) {
        this.consola = Consola.getInstance();
        if (interfaz.get("username") != null) {
            this.consola.configurarUsername();
            String username = interfaz.get("username").getAsString();
            if (EsquemaController.PatronVarPeso.matcher(username).find()) {
                username = this.esquemaController.parseParameters(username);
            }
            this.consola.updateUser(username);
        }
        if (interfaz.get("title") != null) {
            String title = interfaz.get("title").getAsString();
            if (EsquemaController.PatronVarPeso.matcher(title).find()) {
                title = this.esquemaController.parseParameters(title);
            }
            this.consola.updateTitle(title);
        }
        if (interfaz.get("alwaysOnTop") != null) {
            boolean value = interfaz.get("alwaysOnTop").getAsBoolean();
            this.consola.forceAlwaysOnTop(value);
        }
    }

    public void procesarAdditionalFields(AdditionalField additionalField) {
        this.consola = Consola.getInstance();
        Set opcionesCampos = additionalField.getValues().entrySet();
        this.nombresDeCamposAdicionales = new ArrayList();
        Iterator iterator = opcionesCampos.iterator();
        while (iterator.hasNext()) {
            this.nombresDeCamposAdicionales.add((String)((Map.Entry)iterator.next()).getKey());
        }
        if (opcionesCampos.size() == 2) {
            additionalField.setAsBinary();
        }
        this.consola.setAdditionalFields(additionalField);
    }

    public void swapAdditionalField(Documento documento) {
        if (documento.getAdditionalField().equals(this.nombresDeCamposAdicionales.get(0))) {
            documento.setAdditionalField(this.nombresDeCamposAdicionales.get(1));
        } else {
            documento.setAdditionalField(this.nombresDeCamposAdicionales.get(0));
        }
    }

    public void terminarDeProcesarAdditionalFields() {
        if (this.nombresDeCamposAdicionales == null) {
            return;
        }
        String defaultValue = this.nombresDeCamposAdicionales.get(0);
        Consola.getInstance().setAFDefaultValue(defaultValue);
        List<Documento> docs = Principal.getInstance().getDocumentos();
        for (Documento documento : docs) {
            documento.setAdditionalField(defaultValue);
        }
    }
}

