/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.GuiController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import ar.com.lyris.signarestandalone.controladores.WorkerDescarga;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class OriginsController {
    public static final int DESCARGA_DE_ORIGEN = 0;
    public static final int LOCAL_DE_ORIGEN = 1;
    public static volatile OriginsController originsController;
    private int metodoEjecucion = 1;
    private WorkerDescarga workerDescarga;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    private JsonArray fileList;

    private OriginsController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OriginsController getInstance() {
        if (originsController != null) return originsController;
        Class<OriginsController> clazz = OriginsController.class;
        synchronized (OriginsController.class) {
            if (originsController != null) return originsController;
            originsController = new OriginsController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return originsController;
        }
    }

    public void procesarOrigenes(JsonObject origins) {
        if (origins.getAsJsonObject("remote") != null) {
            this.metodoEjecucion = 0;
            this.workerDescarga = WorkerDescarga.getInstance();
            JsonObject remote = origins.getAsJsonObject("remote");
            this.workerDescarga.setURL(this.esquemaController.parseParameters(remote.get("URI").getAsString()));
            this.workerDescarga.setMethod(remote.get("method").getAsString());
            this.fileList = this.esquemaController.parseArrayParameters(remote.get("fileList").getAsString());
            for (JsonElement jsonElement : this.fileList) {
                Documento doc;
                if (jsonElement.isJsonObject()) {
                    doc = originsController.nuevoDocumento(jsonElement.getAsJsonObject().get("id").getAsString());
                    if (jsonElement.getAsJsonObject().get("path") == null) continue;
                    doc.setRemotePath(jsonElement.getAsJsonObject().get("path").getAsString());
                    continue;
                }
                doc = originsController.nuevoDocumento(jsonElement.getAsString());
            }
            HashMap<String, String> originsHeaders = JSONUtils.asHashMap(remote.getAsJsonObject("headers"));
            if (originsHeaders != null) {
                this.computarHeaders(originsHeaders);
            }
            GuiController.getInstance().terminarDeProcesarAdditionalFields();
            if (Principal.getInstance().getCantDocumentos() == 0) {
                String titulo = "No hay documentos para firmar";
                String desc = "La pila de documentos a firmar se encuentra vac\u00eda.";
                Principal.getInstance().informarProblemaIrrecuperable(desc, titulo);
            }
        }
    }

    public Documento nuevoDocumento(String id) {
        Principal p = Principal.getInstance();
        Documento doc = new Documento(id);
        p.getDocumentos().add(doc);
        return doc;
    }

    public void computarHeaders(HashMap<String, String> originsHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.esquemaController.getDefaultHeaders());
        originsHeaders.forEach((key, value) -> {
            String newValue = this.esquemaController.parseParameters((String)value);
            headers.put((String)key, newValue);
        });
        this.workerDescarga.setHeaders(headers);
    }

    public void iniciarDescarga() {
        this.workerDescarga.execute();
    }

    public int getMetodoEjecucion() {
        return this.metodoEjecucion;
    }

    public void setMetodoEjecucion(int metodoEjecucion) {
        this.metodoEjecucion = metodoEjecucion;
    }
}

