/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarestandalone.controladores.ConfigFirmaController;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class WorkerDescargaCert
extends SwingWorker<Boolean, String> {
    public static volatile WorkerDescargaCert workerDescargaCert;
    private String url;
    private String rutaCertNube;
    private boolean resultadoDescargaCert = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerDescargaCert getInstance() {
        if (workerDescargaCert != null) return workerDescargaCert;
        Class<WorkerDescargaCert> clazz = WorkerDescargaCert.class;
        synchronized (WorkerDescargaCert.class) {
            if (workerDescargaCert != null) return workerDescargaCert;
            workerDescargaCert = new WorkerDescargaCert();
            // ** MonitorExit[var0] (shouldn't be in output)
            return workerDescargaCert;
        }
    }

    @Override
    protected Boolean doInBackground() throws IOException {
        System.out.println("-----Inicia descarga certificado-----");
        System.out.println("Tambien se elimina al finalizar la ejecuci\u00f3n.");
        GetRequest request = Unirest.get((String)this.url);
        System.out.println("Preparando un get a: " + request.getUrl());
        HttpResponse response = request.asBytes();
        System.out.println("Status:" + response.getStatus());
        if (response.getStatus() == 200) {
            String inputLine;
            String fileName;
            try {
                fileName = response.getHeaders().getFirst("Content-Disposition").replaceFirst("(?i)^.*filename=\"?([^\"]+)\"?.*$", "$1");
            }
            catch (Exception e) {
                fileName = "certificado.p12";
            }
            if (fileName.isEmpty()) {
                fileName = "certificado.p12";
            }
            fileName = fileName == null || fileName.isEmpty() ? "certificado.p12" : fileName;
            String[] splittedFilename = fileName.split("\\.(?=[^\\.]+$)");
            File temp = File.createTempFile(String.valueOf(splittedFilename[0]) + "__", "." + splittedFilename[1]);
            System.out.println(temp.getAbsolutePath());
            ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream((byte[])response.getBody()));
            System.out.println(temp.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(temp);
            fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
            fos.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])response.getBody())));
            StringBuffer responseFile = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                responseFile.append(inputLine);
            }
            in.close();
            temp.deleteOnExit();
            this.setRutaCertNube(temp.getAbsolutePath());
            System.out.println("Descargado el certificado:" + fileName);
            this.resultadoDescargaCert = true;
            return true;
        }
        return false;
    }

    public void setURL(String urlString) {
        this.url = urlString;
    }

    public void setMethod(String asString) {
    }

    @Override
    protected void done() {
        try {
            this.get();
            ConfigFirmaController.getInstance().habilitarCertificadoDescargado(this.isOkDescargaCert());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void process(List<String> chunks) {
    }

    public String getRutaCertNube() {
        return this.rutaCertNube;
    }

    public void setRutaCertNube(String rutaCertNube) {
        this.rutaCertNube = rutaCertNube;
    }

    public boolean isOkDescargaCert() {
        return this.resultadoDescargaCert;
    }
}

