/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingWorker;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.MultipartBody;
import kong.unirest.Unirest;

public class WorkerSubida
extends SwingWorker<Boolean, String> {
    public static volatile WorkerSubida workerSubida;
    private String url;
    private String fileField;
    private HashMap<String, String> headers;
    private HashMap<String, String> formFields;
    private Consola consola;
    private String[] formFieldWithFileID = new String[2];
    private String urlRastroDeFirma = null;
    private CompletableFuture<HttpResponse<JsonNode>> future = null;
    private Map<String, Object> camposRastroDeFirma;

    private WorkerSubida() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerSubida getInstance() {
        if (workerSubida != null) return workerSubida;
        Class<WorkerSubida> clazz = WorkerSubida.class;
        synchronized (WorkerSubida.class) {
            if (workerSubida != null) return workerSubida;
            workerSubida = new WorkerSubida();
            // ** MonitorExit[var0] (shouldn't be in output)
            return workerSubida;
        }
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        List<Documento> documentos = Principal.getInstance().getDocumentos();
        this.consola = Consola.getInstance();
        boolean urlContainsFILE_IDflag = this.url.contains("{$FILE_ID}");
        for (Documento doc : documentos) {
            doc.setEstado(EstadoDoc.SUBIENDO);
            this.publish(new String[0]);
            String requestURL = urlContainsFILE_IDflag ? this.url.replace("{$FILE_ID}", doc.getId()) : this.url;
            System.out.println("preparing 'POST' request to URL");
            MultipartBody request = null;
            request = this.generarPostGeneral(doc, requestURL);
            System.out.println("Sending 'POST' request to URL : " + request.getUrl());
            HttpResponse response = request.asJson();
            if (response.getStatus() == 200 || response.getStatus() == 201) {
                doc.setEstado(EstadoDoc.SUBIDO);
                System.out.println(((JsonNode)response.getBody()).toString());
                continue;
            }
            doc.setEstado(EstadoDoc.INVALIDO);
            System.out.println(((JsonNode)response.getBody()).toString());
            System.out.println("Codigo de respuesta " + response.getStatus());
        }
        return null;
    }

    MultipartBody generarPostGeneral(Documento doc, String url) throws IOException {
        File signedF = new File(doc.getFullSignedFilePath());
        signedF.deleteOnExit();
        HttpRequestWithBody request = (HttpRequestWithBody)Unirest.post((String)url).headers(this.headers);
        HashMap<String, String> filterMapObj = new HashMap<String, String>();
        filterMapObj.putAll(this.formFields);
        if (this.formFieldWithFileID[0] != null) {
            String fieldWithFILEID = this.formFieldWithFileID[1].replace("{$FILE_ID}", doc.getId());
            filterMapObj.put(this.formFieldWithFileID[0], fieldWithFILEID);
        }
        MultipartBody multiPartBody = request.fields(filterMapObj);
        multiPartBody = multiPartBody.field(this.fileField, signedF);
        EsquemaController esquemaCont = EsquemaController.getInstance();
        if (esquemaCont.derivablesContiene("formField&")) {
            String key_completa = esquemaCont.getFullKeyDerivable("formField&");
            String value = esquemaCont.getDerivable(key_completa);
            String valor_del_formField = esquemaCont.parseDerivable(value, doc.getAdditionalFieldValues());
            multiPartBody = multiPartBody.field(key_completa.split("&")[1], valor_del_formField);
        }
        return multiPartBody;
    }

    public void setMethod(String asString) {
    }

    public void setURL(String urlString) {
        this.url = urlString;
    }

    public void setFileField(String fileField) {
        this.fileField = fileField;
    }

    public void setFormFields(HashMap<String, String> fields) {
        this.formFields = fields;
    }

    public void setHeaders(HashMap<String, String> headersMap) {
        this.headers = headersMap;
    }

    @Override
    protected void process(List<String> chunks) {
        this.consola.refrescarTabla();
    }

    public void setFormFieldWithFileID(String key, String value) {
        this.formFieldWithFileID = new String[]{key, value};
    }

    @Override
    protected void done() {
        this.consola.refrescarTabla();
        Principal.getInstance().etapaFinal();
    }

    void setCamposRastroDeFirma(Map<String, Object> campos) {
        this.camposRastroDeFirma = campos;
    }

    void sendRastroDeFirma() {
        if (this.urlRastroDeFirma != null) {
            this.future = ((HttpRequestWithBody)Unirest.post((String)"https://iramos.com.ar/rastro_de_firma.php").header("accept", "application/json")).fields(this.camposRastroDeFirma).asJsonAsync(response -> {});
        }
    }

    void waitForAsyncs() {
        if (this.future != null) {
            try {
                this.future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    public void habilitarRastroDeFirma(String fileField2) {
        this.urlRastroDeFirma = fileField2;
    }
}

