/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.ComponentEvent;
import com.github.lgooddatepicker.components.ComponentListener;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.zinternaltools.CalculateMinimumDateFieldSize;
import com.github.lgooddatepicker.zinternaltools.Convert;
import com.github.lgooddatepicker.zinternaltools.CustomPopup;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.privatejgoodies.forms.factories.CC;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.chrono.IsoEra;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DatePicker
extends JPanel
implements CustomPopup.CustomPopupCloseListener {
    private CalendarPanel calendarPanel = null;
    private ArrayList<ComponentListener> componentListeners;
    private Convert convert;
    private ArrayList<DateChangeListener> dateChangeListeners = new ArrayList();
    private Instant lastPopupCloseTime = Instant.now();
    private LocalDate lastValidDate = null;
    private CustomPopup popup = null;
    private DatePickerSettings settings;
    private boolean skipTextFieldChangedFunctionWhileTrue = false;
    private JTextField dateTextField;
    private JButton toggleCalendarButton;

    public DatePicker() {
        this((DatePickerSettings)null);
    }

    public DatePicker(DatePickerSettings settings) {
        this.initComponents();
        this.convert = new Convert(this);
        this.toggleCalendarButton.setMargin(new Insets(1, 2, 1, 2));
        this.zAddTextChangeListener();
        this.setSettings(settings);
    }

    public void setSettings(DatePickerSettings settings) {
        settings = settings == null ? new DatePickerSettings() : settings;
        settings.zSetParentDatePicker(this);
        this.settings = settings;
        settings.zApplyGapBeforeButtonPixels();
        settings.zApplyAllowKeyboardEditing();
        settings.zApplyAllowEmptyDates();
        this.zDrawTextFieldIndicators();
        this.zSetAppropriateTextFieldMinimumWidth();
        settings.zDrawDatePickerTextFieldIfNeeded();
        this.zApplyVisibilityOfComponents();
    }

    public void addDateChangeListener(DateChangeListener listener) {
        this.dateChangeListeners.add(listener);
    }

    public void clear() {
        this.setDate(null);
    }

    public void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    public Convert convert() {
        return this.convert;
    }

    public JButton getComponentToggleCalendarButton() {
        return this.toggleCalendarButton;
    }

    @Override
    public int getBaseline(int width, int height) {
        if (this.dateTextField.isVisible()) {
            return this.dateTextField.getBaseline(width, height);
        }
        return super.getBaseline(width, height);
    }

    public JTextField getComponentDateTextField() {
        return this.dateTextField;
    }

    public LocalDate getDate() {
        return this.lastValidDate;
    }

    public ArrayList<DateChangeListener> getDateChangeListeners() {
        return new ArrayList<DateChangeListener>(this.dateChangeListeners);
    }

    public String getDateStringOrEmptyString() {
        LocalDate date = this.getDate();
        return date == null ? "" : date.toString();
    }

    public String getDateStringOrSuppliedString(String emptyDateString) {
        LocalDate date = this.getDate();
        return date == null ? emptyDateString : date.toString();
    }

    public DatePickerSettings getSettings() {
        return this.settings;
    }

    public String getText() {
        return this.dateTextField.getText();
    }

    public boolean isDateAllowed(LocalDate date) {
        if (this.settings == null) {
            return true;
        }
        return this.settings.isDateAllowed(date);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isPopupOpen() {
        return this.popup != null;
    }

    public boolean isTextFieldValid() {
        return this.isTextValid(this.dateTextField.getText());
    }

    public boolean isTextValid(String text) {
        if (text == null || this.settings == null) {
            return false;
        }
        if ((text = text.trim()).isEmpty()) {
            return this.settings.getAllowEmptyDates();
        }
        LocalDate parsedDate = InternalUtilities.getParsedDateOrNull(text, this.settings.getFormatForDatesCommonEra(), this.settings.getFormatForDatesBeforeCommonEra(), this.settings.getFormatsForParsing(), this.settings.getLocale());
        if (parsedDate == null) {
            return false;
        }
        DateVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        return !InternalUtilities.isDateVetoed(vetoPolicy, parsedDate);
    }

    public void openPopup() {
        if (this.isPopupOpen()) {
            this.closePopup();
            return;
        }
        if (this.settings == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dateTextField.hasFocus()) {
            this.dateTextField.requestFocusInWindow();
        }
        LocalDate selectedDateForCalendar = this.lastValidDate;
        DatePicker thisDatePicker = this;
        this.calendarPanel = new CalendarPanel(thisDatePicker);
        this.fireComponentEvent(new ComponentEvent(1, this.calendarPanel.getPreviousYearButton()));
        this.fireComponentEvent(new ComponentEvent(2, this.calendarPanel.getPreviousMonthButton()));
        this.fireComponentEvent(new ComponentEvent(3, this.calendarPanel.getNextMonthButton()));
        this.fireComponentEvent(new ComponentEvent(4, this.calendarPanel.getNextYearButton()));
        if (selectedDateForCalendar != null) {
            this.calendarPanel.setSelectedDate(selectedDateForCalendar);
        }
        this.popup = new CustomPopup((Component)this.calendarPanel, SwingUtilities.getWindowAncestor(this), this, this.settings.getBorderCalendarPopup());
        int defaultX = this.toggleCalendarButton.getLocationOnScreen().x + this.toggleCalendarButton.getBounds().width - this.popup.getBounds().width - 2;
        int defaultY = this.toggleCalendarButton.getLocationOnScreen().y + this.toggleCalendarButton.getBounds().height + 2;
        JComponent verticalFlipReference = this.settings.getVisibleDateTextField() ? this.dateTextField : this.toggleCalendarButton;
        DatePicker.zSetPopupLocation(this.popup, defaultX, defaultY, this, verticalFlipReference, 2, 6);
        this.popup.show();
        this.calendarPanel.requestFocus();
    }

    public void removeDateChangeListener(DateChangeListener listener) {
        this.dateChangeListeners.remove(listener);
    }

    public final void setDate(LocalDate optionalDate) {
        String textFieldString;
        String standardDateString = this.zGetStandardTextFieldDateString(optionalDate);
        if (!standardDateString.equals(textFieldString = this.dateTextField.getText())) {
            this.zInternalSetDateTextField(standardDateString);
        }
    }

    public void setDateToToday() {
        this.setDate(LocalDate.now());
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.closePopup();
        }
        this.setTextFieldToValidStateIfNeeded();
        super.setEnabled(enabled);
        this.toggleCalendarButton.setEnabled(enabled);
        this.dateTextField.setEnabled(enabled);
        this.zDrawTextFieldIndicators();
    }

    @Override
    public void setLocale(Locale locale) {
        DatePickerSettings currentSettings = this.getSettings();
        if (currentSettings != null) {
            currentSettings.setLocale(locale);
        }
        super.setLocale(locale);
    }

    public void setText(String text) {
        this.zInternalSetDateTextField(text);
        this.dateTextField.requestFocusInWindow();
    }

    public void setTextFieldToValidStateIfNeeded() {
        String textFieldString;
        String standardDateString = this.zGetStandardTextFieldDateString(this.lastValidDate);
        if (!standardDateString.equals(textFieldString = this.dateTextField.getText())) {
            this.setDate(this.lastValidDate);
        }
    }

    @Override
    public String toString() {
        return this.getDateStringOrEmptyString();
    }

    public void togglePopup() {
        if (Instant.now().toEpochMilli() - this.lastPopupCloseTime.toEpochMilli() < 200L) {
            return;
        }
        this.openPopup();
    }

    private void zAddTextChangeListener() {
        this.dateTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DatePicker.this.zEventTextFieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DatePicker.this.zEventTextFieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DatePicker.this.zEventTextFieldChanged();
            }
        });
    }

    void zApplyVisibilityOfComponents() {
        boolean showDateTextField = this.settings.getVisibleDateTextField();
        this.dateTextField.setVisible(showDateTextField);
    }

    void zSetAppropriateTextFieldMinimumWidth() {
        if (this.settings == null) {
            return;
        }
        Integer programmerSuppliedWidth = this.settings.getSizeTextFieldMinimumWidth();
        int minimumWidthPixels = CalculateMinimumDateFieldSize.getFormattedDateWidthInPixels(this.settings.getFormatForDatesCommonEra(), this.settings.getLocale(), this.settings.getFontValidDate(), 0);
        if (programmerSuppliedWidth != null) {
            minimumWidthPixels = this.settings.getSizeTextFieldMinimumWidthDefaultOverride() ? Math.max(programmerSuppliedWidth, minimumWidthPixels) : programmerSuppliedWidth;
        }
        Dimension newMinimumSize = this.dateTextField.getMinimumSize();
        newMinimumSize.width = minimumWidthPixels;
        this.dateTextField.setMinimumSize(newMinimumSize);
        Dimension newPreferredSize = this.dateTextField.getPreferredSize();
        newPreferredSize.width = minimumWidthPixels;
        this.dateTextField.setPreferredSize(newPreferredSize);
        this.validate();
    }

    static void zSetPopupLocation(CustomPopup popup, int defaultX, int defaultY, JComponent picker, JComponent verticalFlipReference, int verticalFlipDistance, int bottomOverlapAllowed) {
        Window topWindowOrNull = SwingUtilities.getWindowAncestor(picker);
        Rectangle workingArea = InternalUtilities.getScreenWorkingArea(topWindowOrNull);
        int popupWidth = popup.getBounds().width;
        int popupHeight = popup.getBounds().height;
        Rectangle popupRectangle = new Rectangle(defaultX, defaultY, popupWidth, popupHeight);
        if (popupRectangle.getMaxY() > workingArea.getMaxY() + (double)bottomOverlapAllowed) {
            popupRectangle.y = verticalFlipReference.getLocationOnScreen().y - popupHeight - verticalFlipDistance;
        }
        if (popupRectangle.getMaxX() > workingArea.getMaxX()) {
            popupRectangle.x = (int)((double)popupRectangle.x - (popupRectangle.getMaxX() - workingArea.getMaxX()));
        }
        if (popupRectangle.getMaxY() > workingArea.getMaxY() + (double)bottomOverlapAllowed) {
            popupRectangle.y = (int)((double)popupRectangle.y - (popupRectangle.getMaxY() - workingArea.getMaxY()));
        }
        if (popupRectangle.x < workingArea.x) {
            popupRectangle.x += workingArea.x - popupRectangle.x;
        }
        if (popupRectangle.y < workingArea.y) {
            popupRectangle.y += workingArea.y - popupRectangle.y;
        }
        popup.setLocation(popupRectangle.x, popupRectangle.y);
    }

    private void zEventToggleCalendarButtonMousePressed(MouseEvent event) {
        this.togglePopup();
    }

    private String zGetStandardTextFieldDateString(LocalDate date) {
        if (this.settings == null) {
            return "";
        }
        String standardDateString = "";
        if (date == null) {
            return standardDateString;
        }
        standardDateString = date.getEra() == IsoEra.CE ? date.format(this.settings.getFormatForDatesCommonEra()) : date.format(this.settings.getFormatForDatesBeforeCommonEra());
        return standardDateString;
    }

    private void zInternalSetDateTextField(String text) {
        this.skipTextFieldChangedFunctionWhileTrue = true;
        this.dateTextField.setText(text);
        this.skipTextFieldChangedFunctionWhileTrue = false;
        this.zEventTextFieldChanged();
    }

    private void zInternalSetLastValidDateAndNotifyListeners(LocalDate newDate) {
        LocalDate oldDate = this.lastValidDate;
        this.lastValidDate = newDate;
        if (!PickerUtilities.isSameLocalDate(oldDate, newDate)) {
            for (DateChangeListener dateChangeListener : this.dateChangeListeners) {
                DateChangeEvent dateChangeEvent = new DateChangeEvent(this, oldDate, newDate);
                dateChangeListener.dateChanged(dateChangeEvent);
            }
            this.firePropertyChange("date", oldDate, newDate);
        }
    }

    private void zEventTextFieldChanged() {
        if (this.settings == null) {
            return;
        }
        if (this.skipTextFieldChangedFunctionWhileTrue) {
            return;
        }
        String dateText = this.dateTextField.getText();
        boolean textIsEmpty = dateText.trim().isEmpty();
        DateVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        boolean nullIsAllowed = this.settings.getAllowEmptyDates();
        LocalDate parsedDate = null;
        if (!textIsEmpty) {
            parsedDate = InternalUtilities.getParsedDateOrNull(dateText, this.settings.getFormatForDatesCommonEra(), this.settings.getFormatForDatesBeforeCommonEra(), this.settings.getFormatsForParsing(), this.settings.getLocale());
        }
        boolean dateIsVetoed = false;
        if (parsedDate != null) {
            dateIsVetoed = InternalUtilities.isDateVetoed(vetoPolicy, parsedDate);
        }
        if (textIsEmpty && nullIsAllowed) {
            this.zInternalSetLastValidDateAndNotifyListeners(null);
        }
        if (!textIsEmpty && parsedDate != null && !dateIsVetoed) {
            this.zInternalSetLastValidDateAndNotifyListeners(parsedDate);
        }
        this.zDrawTextFieldIndicators();
        this.firePropertyChange("text", null, this.dateTextField.getText());
    }

    private void initComponents() {
        this.dateTextField = new JTextField();
        this.toggleCalendarButton = new JButton();
        this.setLayout(new FormLayout("pref:grow, [3px,pref], [26px,pref]", "fill:pref:grow"));
        this.dateTextField.setMargin(new Insets(1, 3, 2, 2));
        this.dateTextField.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, new Color(122, 138, 153)), new EmptyBorder(1, 3, 2, 2)));
        this.dateTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DatePicker.this.setTextFieldToValidStateIfNeeded();
            }
        });
        this.add((Component)this.dateTextField, CC.xy(1, 1));
        this.toggleCalendarButton.setText("...");
        this.toggleCalendarButton.setFocusPainted(false);
        this.toggleCalendarButton.setFocusable(false);
        this.toggleCalendarButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DatePicker.this.zEventToggleCalendarButtonMousePressed(e);
            }
        });
        this.add((Component)this.toggleCalendarButton, CC.xy(3, 1));
    }

    public void zDrawTextFieldIndicators() {
        if (this.settings == null) {
            return;
        }
        if (!this.isEnabled()) {
            this.dateTextField.setBackground(new Color(240, 240, 240));
            this.dateTextField.setForeground(new Color(109, 109, 109));
            this.dateTextField.setFont(this.settings.getFontValidDate());
            return;
        }
        this.dateTextField.setBackground(this.settings.getColor(DatePickerSettings.DateArea.TextFieldBackgroundValidDate));
        this.dateTextField.setForeground(this.settings.getColor(DatePickerSettings.DateArea.DatePickerTextValidDate));
        this.dateTextField.setFont(this.settings.getFontValidDate());
        String dateText = this.dateTextField.getText();
        boolean textIsEmpty = dateText.trim().isEmpty();
        if (textIsEmpty) {
            if (!this.settings.getAllowEmptyDates()) {
                this.dateTextField.setBackground(this.settings.getColor(DatePickerSettings.DateArea.TextFieldBackgroundDisallowedEmptyDate));
            }
            return;
        }
        LocalDate parsedDate = InternalUtilities.getParsedDateOrNull(dateText, this.settings.getFormatForDatesCommonEra(), this.settings.getFormatForDatesBeforeCommonEra(), this.settings.getFormatsForParsing(), this.settings.getLocale());
        if (parsedDate == null) {
            this.dateTextField.setBackground(this.settings.getColor(DatePickerSettings.DateArea.TextFieldBackgroundInvalidDate));
            this.dateTextField.setForeground(this.settings.getColor(DatePickerSettings.DateArea.DatePickerTextInvalidDate));
            this.dateTextField.setFont(this.settings.getFontInvalidDate());
            return;
        }
        DateVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        boolean isDateVetoed = InternalUtilities.isDateVetoed(vetoPolicy, parsedDate);
        if (isDateVetoed) {
            this.dateTextField.setBackground(this.settings.getColor(DatePickerSettings.DateArea.TextFieldBackgroundVetoedDate));
            this.dateTextField.setForeground(this.settings.getColor(DatePickerSettings.DateArea.DatePickerTextVetoedDate));
            this.dateTextField.setFont(this.settings.getFontVetoedDate());
        }
    }

    @Override
    public void zEventCustomPopupWasClosed(CustomPopup popup) {
        this.popup = null;
        this.calendarPanel = null;
        this.lastPopupCloseTime = Instant.now();
    }

    public void addComponentListener(ComponentListener listener) {
        if (this.componentListeners == null) {
            this.componentListeners = new ArrayList();
        }
        this.componentListeners.add(listener);
    }

    public void removeComponentListener(ComponentListener listener) {
        if (this.componentListeners == null) {
            return;
        }
        this.componentListeners.remove(listener);
    }

    protected void fireComponentEvent(ComponentEvent e) {
        if (this.componentListeners == null || e == null) {
            return;
        }
        for (ComponentListener listener : this.componentListeners) {
            listener.componentCreated(e);
        }
    }
}

