/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.io;

import es.mityc.javasign.io.IDecoder;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DecoderInputStream
extends FilterInputStream {
    private static final int MAX_TRIES = 3;
    private static final int DEFAULT_BUFFER_SIZE = 512;
    protected IDecoder decoder;
    protected byte[] buf;
    protected int lenBuffer;
    private boolean closed = false;
    private boolean reachEOF = false;
    private byte[] singleByteBuf = new byte[1];
    private static final int MASK_BYTE = 255;
    private byte[] tempBuffer = new byte[512];

    public DecoderInputStream(InputStream in, IDecoder dec) {
        this(in, dec, 512);
    }

    public DecoderInputStream(InputStream in, IDecoder dec, int size) {
        super(in);
        if (in == null || dec == null) {
            throw new NullPointerException();
        }
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.decoder = dec;
        this.buf = new byte[size];
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int tries = 0;
        while ((n = this.decoder.decode(b, off, len)) == 0) {
            if (this.decoder.needsInput() && this.fill() == -1) {
                if (this.decoder.isIncomplete()) {
                    throw new EOFException("Decoder has buffer not depleted");
                }
                this.reachEOF = true;
                return -1;
            }
            if (++tries <= 3) continue;
            break;
        }
        return n;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > this.tempBuffer.length) {
                len = this.tempBuffer.length;
            }
            if ((len = this.read(this.tempBuffer, 0, len)) != -1) continue;
            this.reachEOF = true;
            break;
        }
        return total;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    protected int fill() throws IOException {
        this.ensureOpen();
        this.lenBuffer = this.in.read(this.buf, 0, this.buf.length);
        if (this.lenBuffer > -1) {
            this.decoder.addInput(this.buf, 0, this.lenBuffer);
        }
        return this.lenBuffer;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

