/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.mozilla.IPINDialogConfigurable;
import es.mityc.javasign.pkstore.mozilla.MozillaTokenLoginModeEnum;
import es.mityc.javasign.pkstore.mozilla.PassStoreMozilla;
import es.mityc.javasign.utils.CopyFilesTool;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaStore
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(MozillaStore.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static boolean isNativeInitialized = false;
    private static final String STR_MOZILLA = "mozilla";
    private static final String STR_PASS_HANDLER = "passCallbackHandler";
    private static final String STR_FIX_JSS_BUILT_IN = "Builtin Object Token";
    private static CryptoManager cm;
    private MozillaTokenLoginModeEnum loginMode = MozillaTokenLoginModeEnum.getDefault();
    private int loginTimeoutMinutes = 5;

    public MozillaStore(String profile) {
        this(profile, LIB_MODE.FULL);
    }

    public MozillaStore(String profile, LIB_MODE mode) {
        this.initializeJSS(profile, mode);
    }

    public CertPath getCertPath(java.security.cert.X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PrivateKey getPrivateKey(java.security.cert.X509Certificate certificate) throws CertStoreException {
        try {
            X509Certificate certJSS = cm.findCertByIssuerAndSerialNumber(certificate.getIssuerX500Principal().getEncoded(), new INTEGER(certificate.getSerialNumber()));
            return cm.findPrivKeyByCert(certJSS);
        }
        catch (ObjectNotFoundException ex) {
            throw new CertStoreException((Throwable)ex);
        }
        catch (TokenException ex) {
            throw new CertStoreException((Throwable)ex);
        }
    }

    public Provider getProvider(java.security.cert.X509Certificate cert) {
        return new JSSProvider();
    }

    public List<java.security.cert.X509Certificate> getSignCertificates() throws CertStoreException {
        ArrayList<java.security.cert.X509Certificate> allCerts = new ArrayList<java.security.cert.X509Certificate>();
        if (cm != null) {
            try {
                Enumeration enModules = cm.getModules();
                boolean modulesHasMore = enModules.hasMoreElements();
                while (modulesHasMore) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Procesando modulo PK11 de mozilla");
                    }
                    PK11Module module = (PK11Module)enModules.nextElement();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Modulo: " + module.getName()));
                    }
                    modulesHasMore = enModules.hasMoreElements();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Recargando tokens");
                    }
                    module.reloadTokens();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Tokens recargados");
                    }
                    Enumeration enTok = module.getTokens();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Tokens del m\u00f3dulo obtenidos");
                    }
                    boolean tokHasMore = enTok.hasMoreElements();
                    while (tokHasMore) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Procesando token");
                        }
                        PK11Token token = (PK11Token)enTok.nextElement();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Token: " + token.getName()));
                        }
                        tokHasMore = enTok.hasMoreElements();
                        if (STR_FIX_JSS_BUILT_IN.equals(token.getName()) || token.isInternalCryptoToken() || token.isInternalKeyStorageToken()) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Procesando token externo");
                        }
                        if (!token.isPresent()) continue;
                        if (token.isLoggedIn()) {
                            boolean doLogout;
                            boolean bl = doLogout = this.loginMode != MozillaTokenLoginModeEnum.getLoginMode(token.getLoginMode());
                            if (!doLogout && this.loginMode == MozillaTokenLoginModeEnum.TIMEOUT) {
                                boolean bl2 = doLogout = this.loginTimeoutMinutes != token.getLoginTimeoutMinutes();
                            }
                            if (doLogout) {
                                token.logout();
                            }
                        }
                        if (!token.isLoggedIn()) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)"Loggin de token...");
                            }
                            int tries = 0;
                            while (tries < 3) {
                                try {
                                    token.setLoginMode(this.loginMode.getInteger());
                                    if (this.loginMode == MozillaTokenLoginModeEnum.TIMEOUT) {
                                        token.setLoginTimeoutMinutes(this.loginTimeoutMinutes);
                                    }
                                    token.login(this.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO_TOKEN, null, I18N.getLocalMessage("i18n.mityc.cert.mozilla.8")));
                                    tries += 3;
                                    if (!LOG.isTraceEnabled()) continue;
                                    LOG.trace((Object)"Loggin de token correcto!");
                                }
                                catch (IncorrectPasswordException ex) {
                                    LOG.info((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.6"));
                                    ++tries;
                                }
                                catch (TokenException ex) {
                                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.7", new Object[]{token.getName()}), (Throwable)ex);
                                    ++tries;
                                }
                            }
                        }
                        if (!token.isLoggedIn()) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Accediendo a token...");
                        }
                        CryptoStore store = token.getCryptoStore();
                        X509Certificate[] certs = store.getCertificates();
                        for (int i = 0; i < certs.length; ++i) {
                            java.security.cert.X509Certificate cert = this.convert(certs[i]);
                            boolean[] usage = cert.getKeyUsage();
                            if (cert == null || usage != null && !usage[0] && !usage[1]) continue;
                            allCerts.add(cert);
                        }
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)"Modulo P11 procesado");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Pide certificados");
                }
                X509Certificate[] certs = cm.getInternalKeyStorageToken().getCryptoStore().getCertificates();
                if (LOG.isTraceEnabled()) {
                    if (certs != null) {
                        LOG.trace((Object)("Se han obtenido " + certs.length + " certificados"));
                    } else {
                        LOG.trace((Object)"No hay certificados disponibles");
                    }
                }
                for (int i = 0; i < certs.length; ++i) {
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Buscando clave privada para: " + certs[i]));
                        }
                        if (cm.findPrivKeyByCert(certs[i]) == null) continue;
                        java.security.cert.X509Certificate cert = this.convert(certs[i]);
                        allCerts.add(cert);
                        continue;
                    }
                    catch (ObjectNotFoundException ex) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)"No hay clave privada");
                    }
                }
            }
            catch (SecurityException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
            }
            catch (TokenException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"), (Throwable)ex);
            }
        }
        return allCerts;
    }

    public List<java.security.cert.X509Certificate> getTrustCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private synchronized void initializeJSS(String profile, LIB_MODE mode) {
        if (!isNativeInitialized) {
            this.copyLibraries(mode);
            try {
                CryptoManager.initialize((String)profile);
                cm = CryptoManager.getInstance();
                Security.removeProvider(new JSSProvider().getName());
            }
            catch (KeyDatabaseException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            catch (CertDatabaseException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            catch (AlreadyInitializedException ex) {
            }
            catch (GeneralSecurityException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            catch (CryptoManager.NotInitializedException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            if (cm != null) {
                cm.setPasswordCallback(this.getPassHandler(IPINDialogConfigurable.MESSAGES_MODE.AUTO, null, null));
                isNativeInitialized = true;
            }
        }
    }

    private synchronized void copyLibraries(LIB_MODE mode) {
        try {
            CopyFilesTool cft = new CopyFilesTool("libs/mozilla/MITyCLibCertJNI_mozilla.properties", this.getClass().getClassLoader());
            switch (mode) {
                case FULL: {
                    cft.copyFilesOS(null, "mozilla.cliente", true);
                    break;
                }
                case ONLY_JSS: {
                    cft.copyFilesOS(null, "mozilla.applet", true);
                }
            }
            System.loadLibrary("nspr4");
            System.loadLibrary("plds4");
            System.loadLibrary("plc4");
            System.loadLibrary("softokn3");
            System.loadLibrary("nss3");
            System.loadLibrary("smime3");
            System.loadLibrary("ssl3");
        }
        catch (SecurityException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (UnsatisfiedLinkError ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CopyFileException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    private PasswordCallback getPassHandler(IPINDialogConfigurable.MESSAGES_MODE mode, String title, String pinMessage) {
        PasswordCallback handler = null;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Obteniendo Passhandler...");
            }
            ResourceBundle rb = ResourceBundle.getBundle(STR_MOZILLA);
            String handlerClass = rb.getString(STR_PASS_HANDLER);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Nombre de ventana de pin: " + handlerClass));
            }
            handler = (PasswordCallback)Class.forName(handlerClass).newInstance();
            ((IPINDialogConfigurable)handler).setMessagesMode(mode);
            if (title != null) {
                ((IPINDialogConfigurable)handler).setTitle(title);
            }
            if (pinMessage != null) {
                ((IPINDialogConfigurable)handler).setPINMessage(pinMessage);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Pashandler configurado");
            }
        }
        catch (MissingResourceException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            handler = new PassStoreMozilla();
        }
        catch (InstantiationException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (IllegalAccessException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (ClassCastException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        return handler;
    }

    private java.security.cert.X509Certificate convert(X509Certificate certificate) {
        try {
            byte[] certFirma = certificate.getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certFirma));
        }
        catch (CertificateEncodingException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CertificateException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        return null;
    }

    public MozillaTokenLoginModeEnum getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(MozillaTokenLoginModeEnum mode) {
        this.loginMode = mode;
    }

    public int getLoginTimeoutMinutes() {
        return this.loginTimeoutMinutes;
    }

    public void setLoginTimeoutMinutes(int timeoutMinutes) {
        this.loginTimeoutMinutes = timeoutMinutes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LIB_MODE {
        FULL,
        ONLY_JSS;

    }
}

