/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp.config;

import es.mityc.firmaJava.ocsp.config.ConstantesProveedores;
import es.mityc.firmaJava.ocsp.config.ProveedorInfo;
import es.mityc.firmaJava.ocsp.config.ServidorOcsp;
import java.net.URISyntaxException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigProveedoresHandler
extends DefaultHandler
implements ConstantesProveedores {
    static Log logger = LogFactory.getLog(ConfigProveedoresHandler.class);
    private boolean leyendoProveedor = false;
    private String valorTmp = "";
    private Vector<ProveedorInfo> proveedores = new Vector();
    private String version = "";
    private String fecha = "";

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        logger.warn((Object)exception.getMessage());
    }

    @Override
    public void startElement(String namespace, String localname, String type, Attributes attributes) throws SAXException {
        int at2;
        int at1;
        String v2;
        String v1;
        if (localname.equals(NODO_PROVEEDOR)) {
            this.leyendoProveedor = true;
            v1 = "";
            v2 = "";
            at1 = attributes.getIndex("nombre");
            at2 = attributes.getIndex("descripcion");
            if (at1 >= 0) {
                v1 = attributes.getValue(at1);
            }
            if (at2 >= 0) {
                v2 = attributes.getValue(at2);
            }
            ProveedorInfo po = new ProveedorInfo();
            po.setNombre(v1);
            po.setDescripcion(v2);
            this.proveedores.add(po);
        } else if (!this.leyendoProveedor) {
            return;
        }
        if (localname.equals(NODO_CA)) {
            v1 = "";
            v2 = "";
            at1 = attributes.getIndex("nameHash");
            at2 = attributes.getIndex("pkHash");
            if (at1 >= 0) {
                v1 = attributes.getValue(at1);
            }
            if (at2 >= 0) {
                v2 = attributes.getValue(at2);
            }
            this.proveedores.lastElement().addCA(v1, v2);
        }
        if (localname.equals(NODO_OCSP)) {
            v1 = "";
            v2 = "";
            at1 = attributes.getIndex("URI");
            at2 = attributes.getIndex("descripcion");
            if (at1 >= 0) {
                v1 = attributes.getValue(at1);
            }
            if (at2 >= 0) {
                v2 = attributes.getValue(at2);
            }
            ServidorOcsp server = null;
            try {
                server = new ServidorOcsp(v1, v2);
                this.proveedores.lastElement().addServidor(server);
            }
            catch (URISyntaxException e) {
                throw new SAXException("Invalid Uri. " + e.getMessage());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int end) throws SAXException {
        this.valorTmp = new String(ch, start, end);
        this.valorTmp = this.valorTmp.trim();
    }

    @Override
    public void endElement(String namespace, String localname, String type) {
        if (localname.equals(NODO_PROVEEDOR)) {
            this.leyendoProveedor = false;
        }
        if (localname.equals(NODO_VERSION)) {
            this.version = this.valorTmp;
        }
        if (localname.equals(NODO_FECHA)) {
            this.fecha = this.valorTmp;
        }
    }

    protected Vector<ProveedorInfo> getProveedores() {
        return this.proveedores;
    }

    protected String getFecha() {
        return this.fecha;
    }

    protected String getVersion() {
        return this.version;
    }
}

