/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ts;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.tsp.TSPAlgorithms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSPAlgoritmos {
    private static HashMap<String, String> algoritmosVSoids = null;

    public static Set<String> getPermitidos() {
        HashSet<String> permitidos = new HashSet<String>(Arrays.asList(TSPAlgoritmos.getValoresPermitidos()));
        return permitidos;
    }

    public static String getAlgName(String oid) {
        if (TSPAlgorithms.SHA1.equals(oid)) {
            return "SHA-1";
        }
        if (TSPAlgorithms.SHA256.equals(oid)) {
            return "SHA-2";
        }
        if (TSPAlgorithms.SHA224.equals(oid)) {
            return "SHA-224";
        }
        if (TSPAlgorithms.SHA256.equals(oid)) {
            return "SHA-256";
        }
        if (TSPAlgorithms.SHA384.equals(oid)) {
            return "SHA-384";
        }
        if (TSPAlgorithms.SHA512.equals(oid)) {
            return "SHA-512";
        }
        return oid;
    }

    public static String getOID(String algoritmo) {
        HashSet<String> permitidos = new HashSet<String>(Arrays.asList(TSPAlgoritmos.getValoresPermitidos()));
        if (permitidos.contains(algoritmo)) {
            if ("SHA-1".equals(algoritmo)) {
                return TSPAlgorithms.SHA1;
            }
            if ("SHA-2".equals(algoritmo)) {
                return TSPAlgorithms.SHA256;
            }
            if ("SHA-224".equals(algoritmo)) {
                return TSPAlgorithms.SHA224;
            }
            if ("SHA-256".equals(algoritmo)) {
                return TSPAlgorithms.SHA256;
            }
            if ("SHA-384".equals(algoritmo)) {
                return TSPAlgorithms.SHA384;
            }
            if ("SHA-512".equals(algoritmo)) {
                return TSPAlgorithms.SHA512;
            }
        }
        return null;
    }

    public static MessageDigest getDigest(String oid) {
        String algName = algoritmosVSoids.get(oid);
        if (algName == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algName);
            return md;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String[] getValoresPermitidos() {
        String[] valoresPermitidos = new String[]{"SHA-1", "SHA-2", "SHA-224", "SHA-256", "SHA-384", "SHA-512"};
        return valoresPermitidos;
    }

    static {
        algoritmosVSoids = new HashMap();
        algoritmosVSoids.put(TSPAlgorithms.SHA1, "SHA-1");
        algoritmosVSoids.put(TSPAlgorithms.SHA224, "SHA-224");
        algoritmosVSoids.put(TSPAlgorithms.SHA256, "SHA-256");
        algoritmosVSoids.put(TSPAlgorithms.SHA384, "SHA-384");
        algoritmosVSoids.put(TSPAlgorithms.SHA512, "SHA-512");
        algoritmosVSoids.put(TSPAlgorithms.MD5, "MD5");
    }
}

