/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ts;

import es.mityc.firmaJava.ts.Base64Coder;
import es.mityc.firmaJava.ts.I18n;
import es.mityc.firmaJava.ts.TSClienteError;
import es.mityc.firmaJava.ts.TSPAlgoritmos;
import es.mityc.firmaJava.ts.TSValidacion;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.GenTimeAccuracy;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TSValidator {
    public static TSValidacion validarSelloTiempo(byte[] binarioaSellar, byte[] sellodeTiempo) throws NoSuchAlgorithmException, TSPException, IOException, NoSuchProviderException, CertStoreException, TSClienteError {
        TimeStampToken tst = null;
        TSValidacion tsv = new TSValidacion();
        try {
            tst = new TimeStampToken(new CMSSignedData(sellodeTiempo));
        }
        catch (CMSException e) {
            try {
                TimeStampResponse tsr = new TimeStampResponse(sellodeTiempo);
                tst = tsr.getTimeStampToken();
                if (tst == null) {
                    throw new TSClienteError(I18n.getResource("libreriatsa.error2"));
                }
            }
            catch (TSPException ex) {
                throw new TSClienteError(I18n.getResource("libreriatsa.error2"));
            }
            catch (IOException ex) {
                throw new TSClienteError(I18n.getResource("libreriatsa.error2"));
            }
        }
        tsv.setTst(tst);
        TimeStampTokenInfo tokenInfo = tst.getTimeStampInfo();
        MessageDigest resumen = TSPAlgoritmos.getDigest(tokenInfo.getMessageImprintAlgOID());
        if (resumen == null) {
            tsv.setRespuesta(false);
            return tsv;
        }
        resumen.update(binarioaSellar);
        if (MessageDigest.isEqual(resumen.digest(), tst.getTimeStampInfo().getMessageImprintDigest())) {
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy H:mm:ss.SSS");
            tsv.setFecha(formato.format(tokenInfo.getGenTime()));
            tsv.setFechaDate(tokenInfo.getGenTime());
            GenTimeAccuracy precision = tokenInfo.getGenTimeAccuracy();
            tsv.setPrecision(precision);
            long accuLong = 0L;
            if (precision != null) {
                accuLong = (long)precision.getMicros() * 1L + (long)precision.getMillis() * 1000L + (long)precision.getSeconds() * 1000000L;
            }
            tsv.setPrecisionLong(accuLong);
            tsv.setSello(tokenInfo.getSerialNumber());
            tsv.setFirmaDigest(new String(Base64Coder.encode(tokenInfo.getMessageImprintDigest())));
            tsv.setRespuesta(true);
            tsv.setSelloAlg(tokenInfo.getMessageImprintAlgOID());
            X500Principal signer = null;
            GeneralName gn = tokenInfo.getTsa();
            if (gn != null && gn.getTagNo() == 4) {
                signer = new X500Principal(X509Name.getInstance((Object)gn.getName()).getEncoded());
            }
            if (signer == null) {
                try {
                    Certificate cert;
                    CertStore cs = tst.getCertificatesAndCRLs("Collection", null);
                    Collection<? extends Certificate> certs = cs.getCertificates(null);
                    if (certs.size() > 0 && (cert = certs.iterator().next()) instanceof X509Certificate) {
                        signer = ((X509Certificate)cert).getSubjectX500Principal();
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                }
                catch (NoSuchProviderException ex) {
                }
                catch (CMSException ex) {
                }
                catch (CertStoreException ex) {
                    // empty catch block
                }
            }
            tsv.setEmisor(signer);
        } else {
            tsv.setRespuesta(false);
        }
        return tsv;
    }
}

