/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.FakedTrustException;
import es.mityc.javasign.trust.NotTrustedException;
import es.mityc.javasign.trust.TrustAdapter;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.trust.UnknownTrustException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;

public class PropsTruster
extends TrustAdapter {
    private static final Log LOG = LogFactory.getLog(PropsTruster.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibTrust");
    private static final String CONF_DEFAULT = "trust/myTruster.properties";
    protected static TrustAdapter instance;
    private CertStore issuersCerts;
    private CertStore certsCerts;
    private CertStore issuersOCSP;
    private CertStore certsOCSP;
    private CertStore issuersCRL;
    private CertStore issuersTSA;
    private CertStore certsTSA;

    public PropsTruster(String fileconf) {
        this.loadConf(fileconf, null);
    }

    public PropsTruster(String fileconf, String extfileconf) {
        this.loadConf(fileconf, extfileconf);
    }

    protected synchronized void loadConf(String fileconf, String extfileconf) {
        block14: {
            Properties internalProps = null;
            try {
                ClassLoader cl = PropsTruster.getClassLoader();
                InputStream is = cl.getResourceAsStream(fileconf);
                if (is != null) {
                    internalProps = new Properties();
                    internalProps.load(is);
                } else {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.1", new Object[]{fileconf}));
                }
            }
            catch (IOException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.1", new Object[]{fileconf}));
            }
            Properties externalProps = null;
            if (extfileconf != null) {
                try {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(extfileconf);
                    }
                    catch (FileNotFoundException e) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.1", new Object[]{extfileconf}));
                    }
                    if (fis != null) {
                        externalProps = new Properties();
                        externalProps.load(fis);
                    } else {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.1", new Object[]{extfileconf}));
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.1", new Object[]{extfileconf}));
                }
            }
            if (internalProps != null) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    this.issuersCerts = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_SIGNCERTS_ISSUER);
                    this.certsCerts = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_SIGNCERTS_CERTS);
                    this.issuersOCSP = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_OCSP_ISSUER);
                    this.certsOCSP = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_OCSP_CERTS);
                    this.issuersCRL = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_CRL_ISSUER);
                    this.issuersTSA = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_TSA_ISSUER);
                    this.certsTSA = this.loadCerts(cf, internalProps, externalProps, TrusterType.TRUSTER_TSA_CERTS);
                }
                catch (CertificateException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.9", new Object[]{ex.getMessage()}));
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    public void isTrusted(X509CRL crl) throws TrustException {
        if (this.issuersCRL != null) {
            Iterator<? extends Certificate> it;
            boolean faked = false;
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setSubject(crl.getIssuerX500Principal());
            try {
                it = this.issuersCRL.getCertificates(certSelector).iterator();
            }
            catch (CertStoreException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.21", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            while (it.hasNext()) {
                X509Certificate issuer = (X509Certificate)it.next();
                try {
                    crl.verify(issuer.getPublicKey());
                    return;
                }
                catch (InvalidKeyException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.2", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (CRLException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.3", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.4", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchProviderException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.5", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (SignatureException ex) {
                    faked = true;
                }
            }
            if (faked) {
                throw new FakedTrustException();
            }
            throw new NotTrustedException();
        }
        throw new UnknownTrustException();
    }

    public void isTrusted(OCSPResp ocsp) throws TrustException {
        BasicOCSPResp basicResp = null;
        try {
            basicResp = (BasicOCSPResp)ocsp.getResponseObject();
        }
        catch (OCSPException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.11", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"", (Throwable)ex);
            }
            throw new UnknownTrustException();
        }
        if (this.certsOCSP != null) {
            X509Certificate[] certs;
            X509CertSelector certSelector = null;
            try {
                certs = basicResp.getCerts("SUN");
            }
            catch (NoSuchProviderException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.12", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (OCSPException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.12", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            if (certs != null && certs.length > 0) {
                certSelector = new X509CertSelector();
                certSelector.setSubjectPublicKey(certs[0].getPublicKey());
            } else {
                ResponderID responderId = basicResp.getResponderId().toASN1Object();
                if (responderId != null) {
                    ASN1TaggedObject tagged = (ASN1TaggedObject)responderId.toASN1Object();
                    switch (tagged.getTagNo()) {
                        case 1: {
                            X509Principal cerX509Principal = new X509Principal(X509Name.getInstance((Object)tagged.getObject()).toString());
                            X500Principal cerX500Principal = new X500Principal(cerX509Principal.getDEREncoded());
                            certSelector = new X509CertSelector();
                            certSelector.setSubject(cerX500Principal);
                            break;
                        }
                        case 2: {
                            ASN1OctetString octect = (ASN1OctetString)tagged.getObject();
                            certSelector = new X509CertSelector();
                            try {
                                certSelector.setSubjectPublicKey(octect.getOctets());
                                break;
                            }
                            catch (IOException ex) {
                                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.13", new Object[]{ex.getMessage()}));
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"", (Throwable)ex);
                                }
                                throw new UnknownTrustException();
                            }
                        }
                        default: {
                            throw new UnknownTrustException();
                        }
                    }
                }
            }
            if (certSelector != null) {
                Iterator<? extends Certificate> it;
                try {
                    it = this.certsOCSP.getCertificates(certSelector).iterator();
                }
                catch (CertStoreException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.22", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                if (it.hasNext()) {
                    X509Certificate cert = (X509Certificate)it.next();
                    try {
                        if (basicResp.verify(cert.getPublicKey(), "SunRsaSign")) {
                            return;
                        }
                        throw new FakedTrustException();
                    }
                    catch (OCSPException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.15", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.14", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                }
            }
        }
        if (this.issuersOCSP != null) {
            X509Certificate[] certs;
            try {
                certs = basicResp.getCerts("SUN");
            }
            catch (NoSuchProviderException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.12", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (OCSPException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.12", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            if (certs == null || certs.length == 0) {
                throw new UnknownTrustException();
            }
            this.validateIssuer(certs, this.issuersOCSP);
            try {
                if (basicResp.verify(certs[0].getPublicKey(), "SunRsaSign")) {
                    return;
                }
                throw new FakedTrustException();
            }
            catch (OCSPException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.15", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.14", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
        }
        throw new NotTrustedException();
    }

    private void validateIssuer(X509Certificate[] certs, CertStore store) throws UnknownTrustException, NotTrustedException {
        for (int i = 0; i < certs.length; ++i) {
            Collection<? extends Certificate> certsCollection;
            X509CertSelector certSelector = new X509CertSelector();
            if (certs.length > i + 1) {
                certSelector.setSubjectPublicKey(certs[i + 1].getPublicKey());
            } else {
                certSelector.setSubject(certs[i].getIssuerX500Principal());
            }
            try {
                certsCollection = store.getCertificates(certSelector);
            }
            catch (CertStoreException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.22", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            if (certsCollection.size() > 0) {
                for (X509Certificate x509Certificate : certsCollection) {
                    try {
                        certs[i].verify(x509Certificate.getPublicKey());
                        return;
                    }
                    catch (InvalidKeyException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (CertificateException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchAlgorithmException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"", (Throwable)ex);
                        }
                        throw new UnknownTrustException();
                    }
                    catch (SignatureException ex) {
                    }
                }
                throw new FakedTrustException();
            }
            if (i + 1 < certs.length) {
                try {
                    certs[i].verify(certs[i + 1].getPublicKey());
                    continue;
                }
                catch (InvalidKeyException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (CertificateException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchProviderException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.23", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (SignatureException ex) {
                    throw new FakedTrustException();
                }
            }
            throw new NotTrustedException();
        }
        throw new NotTrustedException();
    }

    public void isTrusted(CertPath certs) throws TrustException {
        if (certs == null || certs.getCertificates().size() == 0) {
            throw new UnknownTrustException();
        }
        if (this.certsCerts != null) {
            Iterator<? extends Certificate> it;
            Collection<? extends Certificate> certsCollection;
            X509Certificate cert = (X509Certificate)certs.getCertificates().get(0);
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(cert);
            try {
                certsCollection = this.certsCerts.getCertificates(certSelector);
            }
            catch (CertStoreException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.24", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            if (certsCollection.size() > 0 && (it = certsCollection.iterator()).hasNext()) {
                X509Certificate certIssuer = (X509Certificate)it.next();
                try {
                    cert.verify(certIssuer.getPublicKey());
                    return;
                }
                catch (InvalidKeyException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.2", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (CertificateException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.16", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.17", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (NoSuchProviderException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.5", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                catch (SignatureException ex) {
                    throw new FakedTrustException();
                }
            }
        }
        if (this.issuersCerts != null) {
            X509Certificate[] list = certs.getCertificates().toArray(new X509Certificate[0]);
            this.validateIssuer(list, this.issuersCerts);
            return;
        }
        throw new NotTrustedException();
    }

    public void isTrusted(TimeStampToken tst) throws TrustException {
        if (this.certsTSA != null) {
            SignerId sid = tst.getSID();
            if (sid != null) {
                Collection<? extends Certificate> certsColl;
                try {
                    certsColl = this.certsTSA.getCertificates((CertSelector)sid);
                }
                catch (CertStoreException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.25", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    throw new UnknownTrustException();
                }
                if (certsColl.size() > 0) {
                    for (X509Certificate x509Certificate : certsColl) {
                        try {
                            tst.validate(x509Certificate, "SunRsaSign");
                            return;
                        }
                        catch (CertificateExpiredException ex) {
                        }
                        catch (CertificateNotYetValidException ex) {
                        }
                        catch (TSPValidationException ex) {
                            throw new FakedTrustException();
                        }
                        catch (NoSuchProviderException ex) {
                            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.6", new Object[]{ex.getMessage()}));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"", (Throwable)ex);
                            }
                            throw new UnknownTrustException();
                        }
                        catch (TSPException ex) {
                            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.7", new Object[]{ex.getMessage()}));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"", (Throwable)ex);
                            }
                            throw new UnknownTrustException();
                        }
                    }
                }
            } else {
                throw new UnknownTrustException();
            }
        }
        if (this.issuersTSA != null) {
            X509Certificate[] certs;
            try {
                certs = tst.getCertificatesAndCRLs("Collection", null).getCertificates(null).toArray(new X509Certificate[0]);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.19", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.19", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (CMSException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.19", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (CertStoreException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.25", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            if (certs == null || certs.length == 0) {
                throw new UnknownTrustException();
            }
            this.validateIssuer(certs, this.issuersTSA);
            try {
                tst.validate(certs[0], "SunRsaSign");
                return;
            }
            catch (CertificateExpiredException ex) {
            }
            catch (CertificateNotYetValidException ex) {
            }
            catch (TSPValidationException ex) {
                throw new FakedTrustException();
            }
            catch (NoSuchProviderException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.6", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
            catch (TSPException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.7", new Object[]{ex.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                throw new UnknownTrustException();
            }
        }
        throw new NotTrustedException();
    }

    public static TrustAdapter getInstance() {
        if (instance == null) {
            instance = new PropsTruster(CONF_DEFAULT, null);
        }
        return instance;
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TrustFactory.class.getClassLoader();
    }

    private CertStore loadCerts(CertificateFactory cf, Properties internalProps, Properties externalProps, TrusterType trusterType) {
        CertStore cs;
        block22: {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            if (internalProps != null) {
                ClassLoader cl = PropsTruster.getClassLoader();
                Enumeration<?> en = internalProps.propertyNames();
                while (en.hasMoreElements()) {
                    String propName = (String)en.nextElement();
                    if (!propName.startsWith(trusterType.toString())) continue;
                    try {
                        String value = internalProps.getProperty(propName);
                        StringTokenizer st = new StringTokenizer(value, ",");
                        while (st.hasMoreTokens()) {
                            String res = st.nextToken();
                            InputStream is = cl.getResourceAsStream(res);
                            if (is != null) {
                                try {
                                    list.add((X509Certificate)cf.generateCertificate(is));
                                }
                                catch (CertificateException ex) {
                                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.10", new Object[]{ex.getMessage()}));
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)"", (Throwable)ex);
                                }
                                continue;
                            }
                            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.trust.props.8", new Object[]{res}));
                        }
                    }
                    catch (MissingResourceException ex) {
                    }
                }
            }
            if (externalProps != null) {
                Enumeration<?> en = externalProps.propertyNames();
                while (en.hasMoreElements()) {
                    String propName = (String)en.nextElement();
                    if (!propName.startsWith(trusterType.toString())) continue;
                    try {
                        String value = externalProps.getProperty(propName);
                        StringTokenizer st = new StringTokenizer(value, ",");
                        String res = null;
                        FileInputStream fis = null;
                        while (st.hasMoreTokens()) {
                            res = st.nextToken();
                            fis = new FileInputStream(res);
                            if (fis != null) {
                                try {
                                    list.add((X509Certificate)cf.generateCertificate(fis));
                                }
                                catch (CertificateException ex) {
                                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.10", new Object[]{ex.getMessage()}));
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)"", (Throwable)ex);
                                }
                                continue;
                            }
                            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.trust.props.8", new Object[]{res}));
                        }
                    }
                    catch (MissingResourceException ex) {
                    }
                    catch (FileNotFoundException e) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.10", new Object[]{e.getMessage()}));
                    }
                }
            }
            cs = null;
            if (list.size() > 0) {
                try {
                    cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(list));
                }
                catch (InvalidAlgorithmParameterException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.20", new Object[]{ex.getMessage()}));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.trust.props.20", new Object[]{ex.getMessage()}));
                    if (!LOG.isDebugEnabled()) break block22;
                    LOG.debug((Object)"", (Throwable)ex);
                }
            }
        }
        return cs;
    }

    public CertPath getCertPath(X509Certificate cert) throws UnknownTrustException {
        Vector<X509Certificate> certsChain = new Vector<X509Certificate>();
        certsChain.add(cert);
        ArrayList<CertStore> arrayStores = new ArrayList<CertStore>();
        arrayStores.add(this.issuersCerts);
        arrayStores.add(this.certsCerts);
        arrayStores.add(this.issuersOCSP);
        arrayStores.add(this.certsOCSP);
        arrayStores.add(this.issuersCRL);
        arrayStores.add(this.issuersTSA);
        arrayStores.add(this.certsTSA);
        X509CertSelector certSelector = new X509CertSelector();
        CertStore cs = null;
        X509Certificate certToValidate = cert;
        X509Certificate issuer = null;
        Iterator<? extends Certificate> it = null;
        boolean chainCompleted = false;
        block8: for (int i = 0; i < arrayStores.size() && !chainCompleted; ++i) {
            cs = (CertStore)arrayStores.get(i);
            int chainLenght = 0;
            block9: while (chainLenght != certsChain.size() && cs != null) {
                chainLenght = certsChain.size();
                try {
                    certToValidate.verify(certToValidate.getPublicKey());
                    chainCompleted = true;
                    continue block8;
                }
                catch (Exception ex) {
                    certSelector.setSubject(certToValidate.getIssuerX500Principal());
                    try {
                        Collection<? extends Certificate> preselCerts = cs.getCertificates(certSelector);
                        if (preselCerts == null) continue;
                        it = preselCerts.iterator();
                    }
                    catch (CertStoreException ex2) {
                        throw new UnknownTrustException();
                    }
                    while (it.hasNext()) {
                        issuer = (X509Certificate)it.next();
                        try {
                            certToValidate.verify(issuer.getPublicKey());
                            certsChain.add(issuer);
                            certToValidate = issuer;
                            continue block9;
                        }
                        catch (Exception ex3) {
                        }
                    }
                }
            }
        }
        if (!chainCompleted) {
            throw new UnknownTrustException(I18N.getLocalMessage("i18n.mityc.trust.props.23") + cert.getSubjectX500Principal().getName());
        }
        CertPath cp = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cp = cf.generateCertPath(certsChain);
        }
        catch (CertificateException ex) {
            throw new UnknownTrustException();
        }
        return cp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TrusterType {
        TRUSTER_SIGNCERTS_ISSUER("signcerts.issuers"),
        TRUSTER_SIGNCERTS_CERTS("signcerts.certs"),
        TRUSTER_OCSP_ISSUER("ocsp.issuers"),
        TRUSTER_OCSP_CERTS("ocsp.certs"),
        TRUSTER_CRL_ISSUER("crl.issuers"),
        TRUSTER_TSA_ISSUER("tsa.issuers"),
        TRUSTER_TSA_CERTS("tsa.certs");

        private String id;

        private TrusterType(String key) {
            this.id = key;
        }

        public String toString() {
            return this.id;
        }
    }
}

