/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.HexEncoder;

public class Utilidades {
    static Log logger = LogFactory.getLog(Utilidades.class);
    private static final String STR_ABRIENDO_CONEXION = "Abriendo conexion con ";
    private static final String STR_TRES_PUNTOS = "...";
    private static int[] XML_ENTITIES = new int[]{34, 38, 39, 60, 62};

    public static boolean isAfirmativo(String valor) {
        return valor != null && (valor.trim().toUpperCase().equals("Y") || valor.trim().toUpperCase().equals("S"));
    }

    public static boolean tieneValor(String valor) {
        return valor != null && !valor.trim().equals("");
    }

    public static boolean isEmpty(String valor) {
        return valor == null || valor.trim().equals("");
    }

    public static InputStream getInputStreamFromURL(String _url) throws Exception {
        URL url = new URL(_url);
        logger.debug((Object)(STR_ABRIENDO_CONEXION + _url + STR_TRES_PUNTOS));
        url.openConnection();
        InputStream is = url.openStream();
        System.out.flush();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStream(File sourceFile, Writer wtargetFile) throws IOException {
        byte[] buffer = new byte[510];
        int numBytes = 0;
        BufferedInputStream bSourceFile = null;
        BufferedWriter targetFile = (BufferedWriter)wtargetFile;
        try {
            bSourceFile = new BufferedInputStream(new FileInputStream(sourceFile));
            String aux = "";
            do {
                if ((numBytes = bSourceFile.read(buffer)) == -1) {
                    break;
                }
                aux = new String(Base64Coder.encode(buffer, numBytes));
                targetFile.write(aux);
            } while (numBytes >= 0);
        }
        finally {
            if (null != bSourceFile) {
                bSourceFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStream(File sourceFile, File attachedFile, Writer wtargetFile) throws IOException {
        byte[] buffer = new byte[510];
        int numBytes = 0;
        BufferedInputStream bSourceFile = null;
        BufferedWriter targetFile = (BufferedWriter)wtargetFile;
        BufferedWriter ficheroAdjuntoDatos = new BufferedWriter(new FileWriter(attachedFile));
        attachedFile.deleteOnExit();
        try {
            bSourceFile = new BufferedInputStream(new FileInputStream(sourceFile));
            String aux = "";
            do {
                if ((numBytes = bSourceFile.read(buffer)) == -1) {
                    break;
                }
                aux = new String(Base64Coder.encode(buffer, numBytes));
                targetFile.write(aux);
                ficheroAdjuntoDatos.write(aux);
                targetFile.flush();
                ficheroAdjuntoDatos.flush();
            } while (numBytes >= 0);
        }
        finally {
            if (null != ficheroAdjuntoDatos) {
                ficheroAdjuntoDatos.close();
            }
            if (null != bSourceFile) {
                bSourceFile.close();
            }
        }
    }

    public static String binary2String(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HexEncoder enc = new HexEncoder();
            enc.encode(data, 0, data.length, (OutputStream)baos);
            return baos.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isEqual(byte[] data1, byte[] data2) {
        if (data1 == null && data2 == null) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public static String escapeXML(String str) {
        StringWriter stringWriter = new StringWriter((int)((double)str.length() + (double)str.length() * 0.1));
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (XML_ENTITIES[0] == c || XML_ENTITIES[1] == c || XML_ENTITIES[2] == c || XML_ENTITIES[3] == c || XML_ENTITIES[4] == c) {
                stringWriter.write("&#");
                stringWriter.write(Integer.toString(c, 10));
                stringWriter.write(59);
                continue;
            }
            stringWriter.write(c);
        }
        return stringWriter.toString();
    }
}

